/*
 * Decompiled with CFR 0.152.
 */
package com.android.camera.ui;

import android.content.Context;
import com.android.camera.IconListPreference;
import com.android.camera.ListPreference;
import com.android.camera.PreferenceGroup;
import com.android.camera.ui.GLRootView;
import com.android.camera.ui.GpsIndicator;
import com.android.camera.ui.HeadUpDisplay;
import com.android.camera.ui.OtherSettingsIndicator;
import com.android.camera.ui.ZoomControllerListener;
import com.android.camera.ui.ZoomIndicator;

public class CameraHeadUpDisplay
extends HeadUpDisplay {
    private static final String TAG = "CamcoderHeadUpDisplay";
    private OtherSettingsIndicator mOtherSettings;
    private GpsIndicator mGpsIndicator;
    private ZoomIndicator mZoomIndicator;
    private Context mContext;
    private float[] mInitialZoomRatios;
    private int mInitialOrientation;

    public CameraHeadUpDisplay(Context context) {
        super(context);
        this.mContext = context;
    }

    public void initialize(Context context, PreferenceGroup group, float[] initialZoomRatios, int initialOrientation) {
        this.mInitialZoomRatios = initialZoomRatios;
        this.mInitialOrientation = initialOrientation;
        super.initialize(context, group);
    }

    protected void initializeIndicatorBar(Context context, PreferenceGroup group) {
        super.initializeIndicatorBar(context, group);
        ListPreference[] prefs = CameraHeadUpDisplay.getListPreferences(group, "pref_camera_focusmode_key", "pref_camera_exposure_key", "pref_camera_scenemode_key", "pref_camera_picturesize_key", "pref_camera_jpegquality_key", "pref_camera_coloreffect_key");
        this.mOtherSettings = new OtherSettingsIndicator(context, prefs);
        this.mOtherSettings.setOnRestorePreferencesClickedRunner(new Runnable(){

            public void run() {
                if (CameraHeadUpDisplay.this.mListener != null) {
                    CameraHeadUpDisplay.this.mListener.onRestorePreferencesClicked();
                }
            }
        });
        this.mIndicatorBar.addComponent(this.mOtherSettings);
        this.mGpsIndicator = new GpsIndicator(context, (IconListPreference)group.findPreference("pref_camera_recordlocation_key"));
        this.mIndicatorBar.addComponent(this.mGpsIndicator);
        this.addIndicator(context, group, "pref_camera_whitebalance_key");
        this.addIndicator(context, group, "pref_camera_flashmode_key");
        if (this.mInitialZoomRatios != null) {
            this.mZoomIndicator = new ZoomIndicator(this.mContext);
            this.mZoomIndicator.setZoomRatios(this.mInitialZoomRatios);
            this.mIndicatorBar.addComponent(this.mZoomIndicator);
        } else {
            this.mZoomIndicator = null;
        }
        this.addIndicator(context, group, "pref_camera_id_key");
        this.mIndicatorBar.setOrientation(this.mInitialOrientation);
    }

    public void setZoomListener(ZoomControllerListener listener) {
        this.mZoomIndicator.setZoomListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setZoomIndex(int index) {
        GLRootView root = this.getGLRootView();
        if (root != null) {
            GLRootView gLRootView = root;
            synchronized (gLRootView) {
                this.mZoomIndicator.setZoomIndex(index);
            }
        } else {
            this.mZoomIndicator.setZoomIndex(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGpsHasSignal(boolean hasSignal) {
        GLRootView root = this.getGLRootView();
        if (root != null) {
            GLRootView gLRootView = root;
            synchronized (gLRootView) {
                this.mGpsIndicator.setHasSignal(hasSignal);
            }
        } else {
            this.mGpsIndicator.setHasSignal(hasSignal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setZoomRatios(float[] zoomRatios) {
        GLRootView root = this.getGLRootView();
        if (root != null) {
            GLRootView gLRootView = root;
            synchronized (gLRootView) {
                this.setZoomRatiosLocked(zoomRatios);
            }
        } else {
            this.setZoomRatiosLocked(zoomRatios);
        }
    }

    private void setZoomRatiosLocked(float[] zoomRatios) {
        this.mZoomIndicator.setZoomRatios(zoomRatios);
    }
}

