/*
 * Decompiled with CFR 0.152.
 */
package com.android.camera.ui;

import android.opengl.GLSurfaceView;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLDisplay;

class CameraEGLConfigChooser
implements GLSurfaceView.EGLConfigChooser {
    private static final int COLOR_BITS = 8;
    private int mStencilBits;
    private final int[] mConfigSpec = new int[]{12324, 8, 12323, 8, 12322, 8, 12321, 8, 12344};

    CameraEGLConfigChooser() {
    }

    public int getStencilBits() {
        return this.mStencilBits;
    }

    public EGLConfig chooseConfig(EGL10 egl, EGLDisplay display) {
        int[] numConfig = new int[1];
        if (!egl.eglChooseConfig(display, this.mConfigSpec, null, 0, numConfig)) {
            throw new RuntimeException("eglChooseConfig failed");
        }
        if (numConfig[0] <= 0) {
            throw new RuntimeException("No configs match configSpec");
        }
        EGLConfig[] configs = new EGLConfig[numConfig[0]];
        if (!egl.eglChooseConfig(display, this.mConfigSpec, configs, configs.length, numConfig)) {
            throw new RuntimeException();
        }
        return this.chooseConfig(egl, display, configs);
    }

    private EGLConfig chooseConfig(EGL10 egl, EGLDisplay display, EGLConfig[] configs) {
        EGLConfig result = null;
        int minStencil = Integer.MAX_VALUE;
        int[] value = new int[1];
        int n = configs.length;
        for (int i = 0; i < n; ++i) {
            if (egl.eglGetConfigAttrib(display, configs[i], 12326, value)) {
                if (value[0] == 0 || value[0] >= minStencil) continue;
                minStencil = value[0];
                result = configs[i];
                continue;
            }
            throw new RuntimeException("eglGetConfigAttrib error: " + egl.eglGetError());
        }
        if (result == null) {
            result = configs[0];
        }
        egl.eglGetConfigAttrib(display, result, 12326, value);
        this.mStencilBits = value[0];
        return result;
    }
}

