/*
 * Decompiled with CFR 0.152.
 */
package com.android.camera.ui;

import android.content.Context;
import com.android.camera.ListPreference;
import com.android.camera.PreferenceGroup;
import com.android.camera.ui.HeadUpDisplay;
import com.android.camera.ui.OtherSettingsIndicator;

public class CamcorderHeadUpDisplay
extends HeadUpDisplay {
    private static final String TAG = "CamcorderHeadUpDisplay";
    private OtherSettingsIndicator mOtherSettings;
    private int mInitialOrientation;

    public CamcorderHeadUpDisplay(Context context) {
        super(context);
    }

    public void initialize(Context context, PreferenceGroup group, int initialOrientation) {
        this.mInitialOrientation = initialOrientation;
        super.initialize(context, group);
    }

    protected void initializeIndicatorBar(Context context, PreferenceGroup group) {
        super.initializeIndicatorBar(context, group);
        ListPreference[] prefs = CamcorderHeadUpDisplay.getListPreferences(group, "pref_camera_focusmode_key", "pref_camera_exposure_key", "pref_camera_scenemode_key", "pref_camera_picturesize_key", "pref_camera_jpegquality_key", "pref_camera_coloreffect_key");
        this.mOtherSettings = new OtherSettingsIndicator(context, prefs);
        this.mOtherSettings.setOnRestorePreferencesClickedRunner(new Runnable(){

            public void run() {
                if (CamcorderHeadUpDisplay.this.mListener != null) {
                    CamcorderHeadUpDisplay.this.mListener.onRestorePreferencesClicked();
                }
            }
        });
        this.mIndicatorBar.addComponent(this.mOtherSettings);
        this.addIndicator(context, group, "pref_camera_whitebalance_key");
        this.addIndicator(context, group, "pref_camera_video_flashmode_key");
        this.addIndicator(context, group, "pref_video_quality_key");
        this.addIndicator(context, group, "pref_camera_id_key");
        this.mIndicatorBar.setOrientation(this.mInitialOrientation);
    }
}

