/*
 * Decompiled with CFR 0.152.
 */
package com.android.camera.ui;

import com.android.camera.ui.GLRootView;
import com.android.camera.ui.Texture;
import javax.microedition.khronos.opengles.GL11;

abstract class BasicTexture
implements Texture {
    protected static final int UNSPECIFIED = -1;
    public static final int STATE_UNLOADED = 0;
    public static final int STATE_LOADED = 1;
    public static final int STATE_ERROR = -1;
    protected GL11 mGL;
    protected int mId;
    protected int mState;
    protected int mWidth = -1;
    protected int mHeight = -1;
    protected int mTextureWidth;
    protected int mTextureHeight;

    protected BasicTexture(GL11 gl, int id2, int state) {
        this.mGL = gl;
        this.mId = id2;
        this.mState = state;
    }

    protected BasicTexture() {
        this(null, 0, 0);
    }

    protected void setSize(int width, int height) {
        this.mWidth = width;
        this.mHeight = height;
    }

    protected void setTextureSize(int width, int height) {
        this.mTextureWidth = width;
        this.mTextureHeight = height;
    }

    public int getId() {
        return this.mId;
    }

    public int getWidth() {
        return this.mWidth;
    }

    public int getHeight() {
        return this.mHeight;
    }

    public void deleteFromGL() {
        if (this.mState == 1) {
            this.mGL.glDeleteTextures(1, new int[]{this.mId}, 0);
        }
        this.mState = 0;
    }

    public void draw(GLRootView root, int x, int y) {
        root.drawTexture(this, x, y, this.mWidth, this.mHeight);
    }

    public void draw(GLRootView root, int x, int y, int w, int h) {
        root.drawTexture(this, x, y, w, h);
    }

    protected abstract boolean bind(GLRootView var1, GL11 var2);
}

