/*
 * Decompiled with CFR 0.152.
 */
package com.android.camera.gallery;

import android.content.ContentResolver;
import android.database.Cursor;
import android.net.Uri;
import android.provider.MediaStore;
import com.android.camera.gallery.BaseImage;
import com.android.camera.gallery.BaseImageList;
import com.android.camera.gallery.VideoObject;

public class VideoList
extends BaseImageList {
    private static final String TAG = "BaseImageList";
    private static final String[] VIDEO_PROJECTION = new String[]{"_id", "datetaken", "mini_thumb_magic", "date_modified"};
    private static final int INDEX_ID = 0;
    private static final int INDEX_DATE_TAKEN = 1;
    private static final int INDEX_MIMI_THUMB_MAGIC = 2;
    private static final int INDEX_DATE_MODIFIED = 3;

    protected BaseImage loadImageFromCursor(Cursor cursor) {
        long id2 = cursor.getLong(0);
        long dateTaken = cursor.getLong(1);
        if (dateTaken == 0L) {
            dateTaken = cursor.getLong(3) * 1000L;
        }
        long miniThumbMagic = cursor.getLong(2);
        return new VideoObject(this.mContentResolver, id2, this.contentUri(id2), miniThumbMagic, dateTaken);
    }

    public VideoList(ContentResolver resolver, Uri uri, int sort, String bucketId) {
        super(resolver, uri, sort, bucketId);
    }

    protected String whereClause() {
        return this.mBucketId != null ? "bucket_id = '" + this.mBucketId + "'" : null;
    }

    protected String[] whereClauseArgs() {
        return null;
    }

    protected Cursor createCursor() {
        Cursor c = MediaStore.Images.Media.query((ContentResolver)this.mContentResolver, (Uri)this.mBaseUri, (String[])VIDEO_PROJECTION, (String)this.whereClause(), (String[])this.whereClauseArgs(), (String)this.sortOrder());
        return c;
    }
}

