/*
 * Decompiled with CFR 0.152.
 */
package com.android.camera.gallery;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LruCache<K, V> {
    private final HashMap<K, V> mLruMap;
    private final HashMap<K, Entry<K, V>> mWeakMap = new HashMap();
    private ReferenceQueue<V> mQueue = new ReferenceQueue();

    public LruCache(final int capacity) {
        this.mLruMap = new LinkedHashMap<K, V>(16, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
                return this.size() > capacity;
            }
        };
    }

    private void cleanUpWeakMap() {
        Entry entry = (Entry)this.mQueue.poll();
        while (entry != null) {
            this.mWeakMap.remove(entry.mKey);
            entry = (Entry)this.mQueue.poll();
        }
    }

    public synchronized V put(K key, V value) {
        this.cleanUpWeakMap();
        this.mLruMap.put(key, value);
        Entry<K, V> entry = this.mWeakMap.put(key, new Entry<K, V>(key, value, this.mQueue));
        return entry == null ? null : (V)entry.get();
    }

    public synchronized V get(K key) {
        this.cleanUpWeakMap();
        V value = this.mLruMap.get(key);
        if (value != null) {
            return value;
        }
        Entry<K, V> entry = this.mWeakMap.get(key);
        return entry == null ? null : (V)entry.get();
    }

    public synchronized void clear() {
        this.mLruMap.clear();
        this.mWeakMap.clear();
        this.mQueue = new ReferenceQueue();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Entry<K, V>
    extends WeakReference<V> {
        K mKey;

        public Entry(K key, V value, ReferenceQueue<V> queue) {
            super(value, queue);
            this.mKey = key;
        }
    }
}

