/*
 * Decompiled with CFR 0.152.
 */
package com.android.camera.gallery;

import com.android.camera.gallery.IImage;
import com.android.camera.gallery.IImageList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.PriorityQueue;

public class ImageListUber
implements IImageList {
    private static final String TAG = "ImageListUber";
    private final IImageList[] mSubList;
    private final PriorityQueue<MergeSlot> mQueue;
    private long[] mSkipList;
    private int mSkipListSize;
    private final int[] mSkipCounts;
    private int mLastListIndex;

    public ImageListUber(IImageList[] sublist, int sort) {
        this.mSubList = (IImageList[])sublist.clone();
        this.mQueue = new PriorityQueue<MergeSlot>(4, sort == 1 ? new AscendingComparator() : new DescendingComparator());
        this.mSkipList = new long[16];
        this.mSkipListSize = 0;
        this.mSkipCounts = new int[this.mSubList.length];
        this.mLastListIndex = -1;
        this.mQueue.clear();
        int n = this.mSubList.length;
        for (int i = 0; i < n; ++i) {
            IImageList list = this.mSubList[i];
            MergeSlot slot = new MergeSlot(list, i);
            if (!slot.next()) continue;
            this.mQueue.add(slot);
        }
    }

    public int getCount() {
        int count = 0;
        for (IImageList subList : this.mSubList) {
            count += subList.getCount();
        }
        return count;
    }

    public IImage getImageAt(int index) {
        if (index < 0 || index > this.getCount()) {
            throw new IndexOutOfBoundsException("index " + index + " out of range max is " + this.getCount());
        }
        int[] skipCounts = this.mSkipCounts;
        Arrays.fill(skipCounts, 0);
        int skipCount = 0;
        int n = this.mSkipListSize;
        for (int i = 0; i < n; ++i) {
            long v = this.mSkipList[i];
            int offset = (int)(v & 0xFFFFFFFFFFFFFFFFL);
            int which = (int)(v >> 32);
            if (skipCount + offset > index) {
                int subindex = this.mSkipCounts[which] + (index - skipCount);
                return this.mSubList[which].getImageAt(subindex);
            }
            skipCount += offset;
            int n2 = which;
            this.mSkipCounts[n2] = this.mSkipCounts[n2] + offset;
        }
        MergeSlot slot;
        while ((slot = this.nextMergeSlot()) != null) {
            if (skipCount == index) {
                IImage result = slot.mImage;
                if (slot.next()) {
                    this.mQueue.add(slot);
                }
                return result;
            }
            if (slot.next()) {
                this.mQueue.add(slot);
            }
            ++skipCount;
        }
        return null;
    }

    private MergeSlot nextMergeSlot() {
        MergeSlot slot = this.mQueue.poll();
        if (slot == null) {
            return null;
        }
        if (slot.mListIndex == this.mLastListIndex) {
            int lastIndex;
            int n = lastIndex = this.mSkipListSize - 1;
            this.mSkipList[n] = this.mSkipList[n] + 1L;
        } else {
            this.mLastListIndex = slot.mListIndex;
            if (this.mSkipList.length == this.mSkipListSize) {
                long[] temp = new long[this.mSkipListSize * 2];
                System.arraycopy(this.mSkipList, 0, temp, 0, this.mSkipListSize);
                this.mSkipList = temp;
            }
            this.mSkipList[this.mSkipListSize++] = (long)this.mLastListIndex << 32 | 1L;
        }
        return slot;
    }

    public void close() {
        int n = this.mSubList.length;
        for (int i = 0; i < n; ++i) {
            this.mSubList[i].close();
        }
    }

    private static class MergeSlot {
        private int mOffset = -1;
        private final IImageList mList;
        int mListIndex;
        long mDateTaken;
        IImage mImage;

        public MergeSlot(IImageList list, int index) {
            this.mList = list;
            this.mListIndex = index;
        }

        public boolean next() {
            if (this.mOffset >= this.mList.getCount() - 1) {
                return false;
            }
            this.mImage = this.mList.getImageAt(++this.mOffset);
            this.mDateTaken = this.mImage.getDateTaken();
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AscendingComparator
    implements Comparator<MergeSlot> {
        private AscendingComparator() {
        }

        @Override
        public int compare(MergeSlot m1, MergeSlot m2) {
            if (m1.mDateTaken != m2.mDateTaken) {
                return m1.mDateTaken < m2.mDateTaken ? -1 : 1;
            }
            return m1.mListIndex - m2.mListIndex;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DescendingComparator
    implements Comparator<MergeSlot> {
        private DescendingComparator() {
        }

        @Override
        public int compare(MergeSlot m1, MergeSlot m2) {
            if (m1.mDateTaken != m2.mDateTaken) {
                return m1.mDateTaken < m2.mDateTaken ? 1 : -1;
            }
            return m1.mListIndex - m2.mListIndex;
        }
    }
}

