/*
 * Decompiled with CFR 0.152.
 */
package com.android.camera.gallery;

import android.content.ContentResolver;
import android.content.ContentUris;
import android.database.Cursor;
import android.net.Uri;
import android.util.Log;
import com.android.camera.gallery.BaseImage;
import com.android.camera.gallery.IImage;
import com.android.camera.gallery.IImageList;
import com.android.camera.gallery.LruCache;

public abstract class BaseImageList
implements IImageList {
    private static final String TAG = "BaseImageList";
    private static final int CACHE_CAPACITY = 512;
    private final LruCache<Integer, BaseImage> mCache = new LruCache(512);
    protected ContentResolver mContentResolver;
    protected int mSort;
    protected Uri mBaseUri;
    protected Cursor mCursor;
    protected String mBucketId;
    protected boolean mCursorDeactivated = false;

    public BaseImageList(ContentResolver resolver, Uri uri, int sort, String bucketId) {
        this.mSort = sort;
        this.mBaseUri = uri;
        this.mBucketId = bucketId;
        this.mContentResolver = resolver;
        this.mCursor = this.createCursor();
        if (this.mCursor == null) {
            Log.w((String)TAG, (String)"createCursor returns null.");
        }
        this.mCache.clear();
    }

    public void close() {
        try {
            this.invalidateCursor();
        }
        catch (IllegalStateException e) {
            Log.e((String)TAG, (String)"Caught exception while deactivating cursor.", (Throwable)e);
        }
        this.mContentResolver = null;
        if (this.mCursor != null) {
            this.mCursor.close();
            this.mCursor = null;
        }
    }

    public Uri contentUri(long id2) {
        try {
            long existingId = ContentUris.parseId((Uri)this.mBaseUri);
            if (existingId != id2) {
                Log.e((String)TAG, (String)"id mismatch");
            }
            return this.mBaseUri;
        }
        catch (NumberFormatException ex) {
            return ContentUris.withAppendedId((Uri)this.mBaseUri, (long)id2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCount() {
        Cursor cursor = this.getCursor();
        if (cursor == null) {
            return 0;
        }
        BaseImageList baseImageList = this;
        synchronized (baseImageList) {
            return cursor.getCount();
        }
    }

    public boolean isEmpty() {
        return this.getCount() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Cursor getCursor() {
        BaseImageList baseImageList = this;
        synchronized (baseImageList) {
            if (this.mCursor == null) {
                return null;
            }
            if (this.mCursorDeactivated) {
                this.mCursor.requery();
                this.mCursorDeactivated = false;
            }
            return this.mCursor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IImage getImageAt(int i) {
        BaseImage result = this.mCache.get(i);
        if (result == null) {
            Cursor cursor = this.getCursor();
            if (cursor == null) {
                return null;
            }
            BaseImageList baseImageList = this;
            synchronized (baseImageList) {
                result = cursor.moveToPosition(i) ? this.loadImageFromCursor(cursor) : null;
                this.mCache.put(i, result);
            }
        }
        return result;
    }

    protected abstract Cursor createCursor();

    protected abstract BaseImage loadImageFromCursor(Cursor var1);

    protected void invalidateCursor() {
        if (this.mCursor == null) {
            return;
        }
        this.mCursor.deactivate();
        this.mCursorDeactivated = true;
    }

    protected String sortOrder() {
        String ascending = this.mSort == 1 ? " ASC" : " DESC";
        String dateExpr = "case ifnull(datetaken,0) when 0 then date_modified*1000 else datetaken end";
        return dateExpr + ascending + ", _id" + ascending;
    }
}

