/*
 * Decompiled with CFR 0.152.
 */
package com.android.camera;

import android.app.Activity;
import android.content.Context;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;

public class PreviewFrameLayout
extends ViewGroup {
    private static final int MIN_HORIZONTAL_MARGIN = 10;
    private double mAspectRatio = 1.3333333333333333;
    private FrameLayout mFrame;
    private OnSizeChangedListener mSizeListener;
    private final DisplayMetrics mMetrics = new DisplayMetrics();

    public PreviewFrameLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        ((Activity)context).getWindowManager().getDefaultDisplay().getMetrics(this.mMetrics);
    }

    public void setOnSizeChangedListener(OnSizeChangedListener listener) {
        this.mSizeListener = listener;
    }

    protected void onFinishInflate() {
        this.mFrame = (FrameLayout)this.findViewById(2131427336);
        if (this.mFrame == null) {
            throw new IllegalStateException("must provide child with id as \"frame\"");
        }
    }

    public void setAspectRatio(double ratio) {
        if (ratio <= 0.0) {
            throw new IllegalArgumentException();
        }
        if (this.mAspectRatio != ratio) {
            this.mAspectRatio = ratio;
            this.requestLayout();
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int verticalPadding;
        int previewHeight;
        int frameWidth = this.getWidth();
        int frameHeight = this.getHeight();
        FrameLayout f = this.mFrame;
        int horizontalPadding = f.getPaddingLeft() + f.getPaddingRight();
        int previewWidth = frameWidth - horizontalPadding;
        if ((double)previewWidth > (double)(previewHeight = frameHeight - (verticalPadding = f.getPaddingBottom() + f.getPaddingTop())) * this.mAspectRatio) {
            previewWidth = (int)((double)previewHeight * this.mAspectRatio + 0.5);
        } else {
            previewHeight = (int)((double)previewWidth / this.mAspectRatio + 0.5);
        }
        frameWidth = previewWidth + horizontalPadding;
        frameHeight = previewHeight + verticalPadding;
        int hSpace = (r - l - frameWidth) / 2;
        int vSpace = (b - t - frameHeight) / 2;
        this.mFrame.measure(View.MeasureSpec.makeMeasureSpec((int)frameWidth, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)frameHeight, (int)0x40000000));
        this.mFrame.layout(l + hSpace, t + vSpace, r - hSpace, b - vSpace);
        if (this.mSizeListener != null) {
            this.mSizeListener.onSizeChanged();
        }
    }

    public static interface OnSizeChangedListener {
        public void onSizeChanged();
    }
}

