/*
 * Decompiled with CFR 0.152.
 */
package com.android.camera;

import android.content.Context;
import android.util.AttributeSet;
import android.util.Xml;
import android.view.InflateException;
import com.android.camera.CameraPreference;
import com.android.camera.PreferenceGroup;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class PreferenceInflater {
    private static final String PACKAGE_NAME = PreferenceInflater.class.getPackage().getName();
    private static final Class<?>[] CTOR_SIGNATURE = new Class[]{Context.class, AttributeSet.class};
    private static final HashMap<String, Constructor<?>> sConstructorMap = new HashMap();
    private Context mContext;

    public PreferenceInflater(Context context) {
        this.mContext = context;
    }

    public CameraPreference inflate(int resId) {
        return this.inflate((XmlPullParser)this.mContext.getResources().getXml(resId));
    }

    private CameraPreference newPreference(String tagName, Object[] args) {
        String name = PACKAGE_NAME + "." + tagName;
        Constructor<?> constructor = sConstructorMap.get(name);
        try {
            if (constructor == null) {
                Class<?> clazz = this.mContext.getClassLoader().loadClass(name);
                constructor = clazz.getConstructor(CTOR_SIGNATURE);
                sConstructorMap.put(name, constructor);
            }
            return (CameraPreference)constructor.newInstance(args);
        }
        catch (NoSuchMethodException e) {
            throw new InflateException("Error inflating class " + name, (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new InflateException("No such class: " + name, (Throwable)e);
        }
        catch (Exception e) {
            throw new InflateException("While create instance of" + name, (Throwable)e);
        }
    }

    private CameraPreference inflate(XmlPullParser parser) {
        AttributeSet attrs = Xml.asAttributeSet((XmlPullParser)parser);
        ArrayList<CameraPreference> list = new ArrayList<CameraPreference>();
        Object[] args = new Object[]{this.mContext, attrs};
        try {
            int type = parser.next();
            while (type != 1) {
                if (type == 2) {
                    CameraPreference pref = this.newPreference(parser.getName(), args);
                    int depth = parser.getDepth();
                    if (depth > list.size()) {
                        list.add(pref);
                    } else {
                        list.set(depth - 1, pref);
                    }
                    if (depth > 1) {
                        ((PreferenceGroup)list.get(depth - 2)).addChild(pref);
                    }
                }
                type = parser.next();
            }
            if (list.size() == 0) {
                throw new InflateException("No root element found");
            }
            return (CameraPreference)list.get(0);
        }
        catch (XmlPullParserException e) {
            throw new InflateException((Throwable)e);
        }
        catch (IOException e) {
            throw new InflateException(parser.getPositionDescription(), (Throwable)e);
        }
    }
}

