/*
 * Decompiled with CFR 0.152.
 */
package com.android.camera;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import com.android.camera.CameraPreference;
import com.android.camera.R;
import com.android.camera.Util;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListPreference
extends CameraPreference {
    private final String mKey;
    private String mValue;
    private final String mDefaultValue;
    private CharSequence[] mEntries;
    private CharSequence[] mEntryValues;
    private boolean mLoaded = false;

    public ListPreference(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ListPreference, 0, 0);
        this.mKey = Util.checkNotNull(a.getString(0));
        this.mDefaultValue = a.getString(1);
        this.setEntries(a.getTextArray(3));
        this.setEntryValues(a.getTextArray(2));
        a.recycle();
    }

    public String getKey() {
        return this.mKey;
    }

    public CharSequence[] getEntries() {
        return this.mEntries;
    }

    public CharSequence[] getEntryValues() {
        return this.mEntryValues;
    }

    public void setEntries(CharSequence[] entries) {
        this.mEntries = entries == null ? new CharSequence[]{} : entries;
    }

    public void setEntryValues(CharSequence[] values) {
        this.mEntryValues = values == null ? new CharSequence[]{} : values;
    }

    public String getValue() {
        if (!this.mLoaded) {
            this.mValue = this.getSharedPreferences().getString(this.mKey, this.mDefaultValue);
            this.mLoaded = true;
        }
        return this.mValue;
    }

    public void setValue(String value) {
        if (this.findIndexOfValue(value) < 0) {
            throw new IllegalArgumentException();
        }
        this.mValue = value;
        this.persistStringValue(value);
    }

    public void setValueIndex(int index) {
        this.setValue(((Object)this.mEntryValues[index]).toString());
    }

    public int findIndexOfValue(String value) {
        int n = this.mEntryValues.length;
        for (int i = 0; i < n; ++i) {
            if (!Util.equals(this.mEntryValues[i], value)) continue;
            return i;
        }
        return -1;
    }

    public String getEntry() {
        return ((Object)this.mEntries[this.findIndexOfValue(this.getValue())]).toString();
    }

    protected void persistStringValue(String value) {
        SharedPreferences.Editor editor = this.getSharedPreferences().edit();
        editor.putString(this.mKey, value);
        editor.apply();
    }

    @Override
    public void reloadValue() {
        this.mLoaded = false;
    }

    public void filterUnsupported(List<String> supported) {
        ArrayList<CharSequence> entries = new ArrayList<CharSequence>();
        ArrayList<CharSequence> entryValues = new ArrayList<CharSequence>();
        int len = this.mEntryValues.length;
        for (int i = 0; i < len; ++i) {
            if (supported.indexOf(((Object)this.mEntryValues[i]).toString()) < 0) continue;
            entries.add(this.mEntries[i]);
            entryValues.add(this.mEntryValues[i]);
        }
        int size = entries.size();
        this.mEntries = entries.toArray(new CharSequence[size]);
        this.mEntryValues = entryValues.toArray(new CharSequence[size]);
    }
}

