/*
 * Decompiled with CFR 0.152.
 */
package com.android.camera;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.location.Location;
import android.media.ExifInterface;
import android.net.Uri;
import android.os.Environment;
import android.os.Parcel;
import android.os.Parcelable;
import android.provider.MediaStore;
import android.util.Log;
import com.android.camera.Util;
import com.android.camera.gallery.BaseImageList;
import com.android.camera.gallery.IImage;
import com.android.camera.gallery.IImageList;
import com.android.camera.gallery.ImageList;
import com.android.camera.gallery.ImageListUber;
import com.android.camera.gallery.VideoList;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;

public class ImageManager {
    private static final String TAG = "ImageManager";
    private static final Uri STORAGE_URI = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
    private static final Uri VIDEO_STORAGE_URI = Uri.parse((String)"content://media/external/video/media");
    public static final int INCLUDE_IMAGES = 1;
    public static final int INCLUDE_VIDEOS = 4;
    public static final int SORT_ASCENDING = 1;
    public static final int SORT_DESCENDING = 2;
    public static final String CAMERA_IMAGE_BUCKET_NAME = Environment.getExternalStorageDirectory().toString() + "/DCIM/Camera";
    public static final String CAMERA_IMAGE_BUCKET_ID = ImageManager.getBucketId(CAMERA_IMAGE_BUCKET_NAME);

    private ImageManager() {
    }

    public static String getBucketId(String path) {
        return String.valueOf(path.toLowerCase().hashCode());
    }

    public static void ensureOSXCompatibleFolder() {
        File nnnAAAAA = new File(Environment.getExternalStorageDirectory().toString() + "/DCIM/100ANDRO");
        if (!nnnAAAAA.exists() && !nnnAAAAA.mkdir()) {
            Log.e((String)TAG, (String)("create NNNAAAAA file: " + nnnAAAAA.getPath() + " failed"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static Uri addImage(ContentResolver cr, String title, long dateTaken, Location location, String directory, String filename, Bitmap source, byte[] jpegData, int[] degree) {
        FileOutputStream outputStream = null;
        String filePath = directory + "/" + filename;
        try {
            File dir = new File(directory);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            File file = new File(directory, filename);
            outputStream = new FileOutputStream(file);
            if (source != null) {
                source.compress(Bitmap.CompressFormat.JPEG, 75, (OutputStream)outputStream);
                degree[0] = 0;
            } else {
                ((OutputStream)outputStream).write(jpegData);
                degree[0] = ImageManager.getExifOrientation(filePath);
            }
            Util.closeSilently(outputStream);
        }
        catch (FileNotFoundException ex) {
            Log.w((String)TAG, (Throwable)ex);
            Uri uri = null;
            return uri;
        }
        catch (IOException ex2) {
            Log.w((String)TAG, (Throwable)ex2);
            Uri uri = null;
            return uri;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            Util.closeSilently(outputStream);
        }
        long size = new File(directory, filename).length();
        ContentValues values = new ContentValues(9);
        values.put("title", title);
        values.put("_display_name", filename);
        values.put("datetaken", Long.valueOf(dateTaken));
        values.put("mime_type", "image/jpeg");
        values.put("orientation", Integer.valueOf(degree[0]));
        values.put("_data", filePath);
        values.put("_size", Long.valueOf(size));
        if (location != null) {
            values.put("latitude", Double.valueOf(location.getLatitude()));
            values.put("longitude", Double.valueOf(location.getLongitude()));
        }
        return cr.insert(STORAGE_URI, values);
    }

    public static int getExifOrientation(String filepath) {
        int orientation;
        int degree = 0;
        ExifInterface exif = null;
        try {
            exif = new ExifInterface(filepath);
        }
        catch (IOException ex) {
            Log.e((String)TAG, (String)"cannot read exif", (Throwable)ex);
        }
        if (exif != null && (orientation = exif.getAttributeInt("Orientation", -1)) != -1) {
            switch (orientation) {
                case 6: {
                    degree = 90;
                    break;
                }
                case 3: {
                    degree = 180;
                    break;
                }
                case 8: {
                    degree = 270;
                }
            }
        }
        return degree;
    }

    public static IImageList makeImageList(ContentResolver cr, ImageListParam param) {
        DataLocation location = param.mLocation;
        int inclusion = param.mInclusion;
        int sort = param.mSort;
        String bucketId = param.mBucketId;
        boolean isEmptyImageList = param.mIsEmptyImageList;
        if (isEmptyImageList || cr == null) {
            return new EmptyImageList();
        }
        boolean haveSdCard = ImageManager.hasStorage(false);
        ArrayList<BaseImageList> l = new ArrayList<BaseImageList>();
        if (haveSdCard && location != DataLocation.INTERNAL) {
            if ((inclusion & 1) != 0) {
                l.add(new ImageList(cr, STORAGE_URI, sort, bucketId));
            }
            if ((inclusion & 4) != 0) {
                l.add(new VideoList(cr, VIDEO_STORAGE_URI, sort, bucketId));
            }
        }
        if ((location == DataLocation.INTERNAL || location == DataLocation.ALL) && (inclusion & 1) != 0) {
            l.add(new ImageList(cr, MediaStore.Images.Media.INTERNAL_CONTENT_URI, sort, bucketId));
        }
        Iterator iter = l.iterator();
        while (iter.hasNext()) {
            BaseImageList sublist = (BaseImageList)iter.next();
            if (!sublist.isEmpty()) continue;
            sublist.close();
            iter.remove();
        }
        if (l.size() == 1) {
            BaseImageList list = (BaseImageList)l.get(0);
            return list;
        }
        ImageListUber uber = new ImageListUber(l.toArray(new IImageList[l.size()]), sort);
        return uber;
    }

    public static ImageListParam getImageListParam(DataLocation location, int inclusion, int sort, String bucketId) {
        ImageListParam param = new ImageListParam();
        param.mLocation = location;
        param.mInclusion = inclusion;
        param.mSort = sort;
        param.mBucketId = bucketId;
        return param;
    }

    public static IImageList makeImageList(ContentResolver cr, DataLocation location, int inclusion, int sort, String bucketId) {
        ImageListParam param = ImageManager.getImageListParam(location, inclusion, sort, bucketId);
        return ImageManager.makeImageList(cr, param);
    }

    private static boolean checkFsWritable() {
        String directoryName = Environment.getExternalStorageDirectory().toString() + "/DCIM";
        File directory = new File(directoryName);
        if (!directory.isDirectory() && !directory.mkdirs()) {
            return false;
        }
        return directory.canWrite();
    }

    public static boolean hasStorage() {
        return ImageManager.hasStorage(true);
    }

    public static boolean hasStorage(boolean requireWriteAccess) {
        String state = Environment.getExternalStorageState();
        if ("mounted".equals(state)) {
            if (requireWriteAccess) {
                boolean writable = ImageManager.checkFsWritable();
                return writable;
            }
            return true;
        }
        return !requireWriteAccess && "mounted_ro".equals(state);
    }

    private static Cursor query(ContentResolver resolver, Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        try {
            if (resolver == null) {
                return null;
            }
            return resolver.query(uri, projection, selection, selectionArgs, sortOrder);
        }
        catch (UnsupportedOperationException ex) {
            return null;
        }
    }

    public static boolean isMediaScannerScanning(ContentResolver cr) {
        boolean result = false;
        Cursor cursor = ImageManager.query(cr, MediaStore.getMediaScannerUri(), new String[]{"volume"}, null, null, null);
        if (cursor != null) {
            if (cursor.getCount() == 1) {
                cursor.moveToFirst();
                result = "external".equals(cursor.getString(0));
            }
            cursor.close();
        }
        return result;
    }

    public static String getLastImageThumbPath() {
        return Environment.getExternalStorageDirectory().toString() + "/DCIM/.thumbnails/image_last_thumb";
    }

    public static String getLastVideoThumbPath() {
        return Environment.getExternalStorageDirectory().toString() + "/DCIM/.thumbnails/video_last_thumb";
    }

    public static String getTempJpegPath() {
        return Environment.getExternalStorageDirectory().toString() + "/DCIM/.tempjpeg";
    }

    private static class EmptyImageList
    implements IImageList {
        private EmptyImageList() {
        }

        public void close() {
        }

        public int getCount() {
            return 0;
        }

        public IImage getImageAt(int i) {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DataLocation {
        NONE,
        INTERNAL,
        EXTERNAL,
        ALL;

    }

    public static class ImageListParam
    implements Parcelable {
        public DataLocation mLocation;
        public int mInclusion;
        public int mSort;
        public String mBucketId;
        public boolean mIsEmptyImageList;
        public static final Parcelable.Creator<ImageListParam> CREATOR = new Parcelable.Creator<ImageListParam>(){

            public ImageListParam createFromParcel(Parcel in) {
                return new ImageListParam(in);
            }

            public ImageListParam[] newArray(int size) {
                return new ImageListParam[size];
            }
        };

        public ImageListParam() {
        }

        public void writeToParcel(Parcel out, int flags) {
            out.writeInt(this.mLocation.ordinal());
            out.writeInt(this.mInclusion);
            out.writeInt(this.mSort);
            out.writeString(this.mBucketId);
            out.writeInt(this.mIsEmptyImageList ? 1 : 0);
        }

        private ImageListParam(Parcel in) {
            this.mLocation = DataLocation.values()[in.readInt()];
            this.mInclusion = in.readInt();
            this.mSort = in.readInt();
            this.mBucketId = in.readString();
            this.mIsEmptyImageList = in.readInt() != 0;
        }

        public String toString() {
            return String.format("ImageListParam{loc=%s,inc=%d,sort=%d,bucket=%s,empty=%b}", new Object[]{this.mLocation, this.mInclusion, this.mSort, this.mBucketId, this.mIsEmptyImageList});
        }

        public int describeContents() {
            return 0;
        }
    }
}

