/*
 * Decompiled with CFR 0.152.
 */
package com.android.camera;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import com.android.camera.IntArray;
import com.android.camera.ListPreference;
import com.android.camera.R;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IconListPreference
extends ListPreference {
    private int[] mIconIds;
    private int[] mLargeIconIds;

    public IconListPreference(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.IconListPreference, 0, 0);
        Resources res = context.getResources();
        this.mIconIds = this.getIconIds(res, a.getResourceId(0, 0));
        this.mLargeIconIds = this.getIconIds(res, a.getResourceId(1, 0));
        a.recycle();
    }

    public int[] getLargeIconIds() {
        return this.mLargeIconIds;
    }

    public int[] getIconIds() {
        return this.mIconIds;
    }

    public void setLargeIconIds(int[] largeIconIds) {
        this.mLargeIconIds = largeIconIds;
    }

    public void setIconIds(int[] iconIds) {
        this.mIconIds = iconIds;
    }

    private int[] getIconIds(Resources res, int iconsRes) {
        if (iconsRes == 0) {
            return null;
        }
        TypedArray array2 = res.obtainTypedArray(iconsRes);
        int n = array2.length();
        int[] ids = new int[n];
        for (int i = 0; i < n; ++i) {
            ids[i] = array2.getResourceId(i, 0);
        }
        array2.recycle();
        return ids;
    }

    @Override
    public void filterUnsupported(List<String> supported) {
        CharSequence[] entryValues = this.getEntryValues();
        IntArray iconIds = new IntArray();
        IntArray largeIconIds = new IntArray();
        int len = entryValues.length;
        for (int i = 0; i < len; ++i) {
            if (supported.indexOf(((Object)entryValues[i]).toString()) < 0) continue;
            iconIds.add(this.mIconIds[i]);
            largeIconIds.add(this.mLargeIconIds[i]);
        }
        int size = iconIds.size();
        this.mIconIds = iconIds.toArray(new int[size]);
        this.mLargeIconIds = iconIds.toArray(new int[size]);
        super.filterUnsupported(supported);
    }
}

