/*
 * Decompiled with CFR 0.152.
 */
package com.android.camera;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.widget.ImageView;
import com.android.camera.R;

public class IconIndicator
extends ImageView {
    private Drawable[] mIcons;
    private CharSequence[] mModes;

    public IconIndicator(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.IconIndicator, defStyle, 0);
        Drawable[] icons = this.loadIcons(context.getResources(), a.getResourceId(0, 0));
        CharSequence[] modes = a.getTextArray(1);
        a.recycle();
        this.setModesAndIcons(modes, icons);
        this.setImageDrawable(this.mIcons.length > 0 ? this.mIcons[0] : null);
    }

    public IconIndicator(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    private Drawable[] loadIcons(Resources resources, int iconsId) {
        TypedArray array2 = resources.obtainTypedArray(iconsId);
        int n = array2.length();
        Drawable[] drawable2 = new Drawable[n];
        for (int i = 0; i < n; ++i) {
            int id2 = array2.getResourceId(i, 0);
            drawable2[i] = id2 == 0 ? null : resources.getDrawable(id2);
        }
        array2.recycle();
        return drawable2;
    }

    private void setModesAndIcons(CharSequence[] modes, Drawable[] icons) {
        if (modes.length != icons.length || icons.length == 0) {
            throw new IllegalArgumentException();
        }
        this.mIcons = icons;
        this.mModes = modes;
    }

    public void setMode(String mode) {
        int n = this.mModes.length;
        for (int i = 0; i < n; ++i) {
            if (!this.mModes[i].equals(mode)) continue;
            this.setImageDrawable(this.mIcons[i]);
            return;
        }
        throw new IllegalArgumentException("unknown mode: " + mode);
    }
}

