/*
 * Decompiled with CFR 0.152.
 */
package com.android.camera;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComboPreferences
implements SharedPreferences,
SharedPreferences.OnSharedPreferenceChangeListener {
    private SharedPreferences mPrefGlobal;
    private SharedPreferences mPrefLocal;
    private CopyOnWriteArrayList<SharedPreferences.OnSharedPreferenceChangeListener> mListeners;
    private static WeakHashMap<Context, ComboPreferences> sMap = new WeakHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ComboPreferences(Context context) {
        this.mPrefGlobal = PreferenceManager.getDefaultSharedPreferences((Context)context);
        this.mPrefGlobal.registerOnSharedPreferenceChangeListener((SharedPreferences.OnSharedPreferenceChangeListener)this);
        WeakHashMap<Context, ComboPreferences> weakHashMap = sMap;
        synchronized (weakHashMap) {
            sMap.put(context, this);
        }
        this.mListeners = new CopyOnWriteArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ComboPreferences get(Context context) {
        WeakHashMap<Context, ComboPreferences> weakHashMap = sMap;
        synchronized (weakHashMap) {
            return sMap.get(context);
        }
    }

    public void setLocalId(Context context, int cameraId) {
        String prefName = context.getPackageName() + "_preferences_" + cameraId;
        if (this.mPrefLocal != null) {
            this.mPrefLocal.unregisterOnSharedPreferenceChangeListener((SharedPreferences.OnSharedPreferenceChangeListener)this);
        }
        this.mPrefLocal = context.getSharedPreferences(prefName, 0);
        this.mPrefLocal.registerOnSharedPreferenceChangeListener((SharedPreferences.OnSharedPreferenceChangeListener)this);
    }

    public SharedPreferences getGlobal() {
        return this.mPrefGlobal;
    }

    public SharedPreferences getLocal() {
        return this.mPrefLocal;
    }

    public Map<String, ?> getAll() {
        throw new UnsupportedOperationException();
    }

    private static boolean isGlobal(String key) {
        return key.equals("pref_camera_id_key") || key.equals("pref_camera_recordlocation_key");
    }

    public String getString(String key, String defValue) {
        if (ComboPreferences.isGlobal(key) || !this.mPrefLocal.contains(key)) {
            return this.mPrefGlobal.getString(key, defValue);
        }
        return this.mPrefLocal.getString(key, defValue);
    }

    public int getInt(String key, int defValue) {
        if (ComboPreferences.isGlobal(key) || !this.mPrefLocal.contains(key)) {
            return this.mPrefGlobal.getInt(key, defValue);
        }
        return this.mPrefLocal.getInt(key, defValue);
    }

    public long getLong(String key, long defValue) {
        if (ComboPreferences.isGlobal(key) || !this.mPrefLocal.contains(key)) {
            return this.mPrefGlobal.getLong(key, defValue);
        }
        return this.mPrefLocal.getLong(key, defValue);
    }

    public float getFloat(String key, float defValue) {
        if (ComboPreferences.isGlobal(key) || !this.mPrefLocal.contains(key)) {
            return this.mPrefGlobal.getFloat(key, defValue);
        }
        return this.mPrefLocal.getFloat(key, defValue);
    }

    public boolean getBoolean(String key, boolean defValue) {
        if (ComboPreferences.isGlobal(key) || !this.mPrefLocal.contains(key)) {
            return this.mPrefGlobal.getBoolean(key, defValue);
        }
        return this.mPrefLocal.getBoolean(key, defValue);
    }

    public Set<String> getStringSet(String key, Set<String> defValues) {
        throw new UnsupportedOperationException();
    }

    public boolean contains(String key) {
        if (this.mPrefLocal.contains(key)) {
            return true;
        }
        return this.mPrefGlobal.contains(key);
    }

    public SharedPreferences.Editor edit() {
        return new MyEditor();
    }

    public void registerOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener listener) {
        this.mListeners.add(listener);
    }

    public void unregisterOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener listener) {
        this.mListeners.remove(listener);
    }

    public void onSharedPreferenceChanged(SharedPreferences sharedPreferences, String key) {
        for (SharedPreferences.OnSharedPreferenceChangeListener listener : this.mListeners) {
            listener.onSharedPreferenceChanged((SharedPreferences)this, key);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MyEditor
    implements SharedPreferences.Editor {
        private SharedPreferences.Editor mEditorGlobal;
        private SharedPreferences.Editor mEditorLocal;

        MyEditor() {
            this.mEditorGlobal = ComboPreferences.this.mPrefGlobal.edit();
            this.mEditorLocal = ComboPreferences.this.mPrefLocal.edit();
        }

        public boolean commit() {
            boolean result1 = this.mEditorGlobal.commit();
            boolean result2 = this.mEditorLocal.commit();
            return result1 && result2;
        }

        public void apply() {
            this.mEditorGlobal.apply();
            this.mEditorLocal.apply();
        }

        public SharedPreferences.Editor clear() {
            this.mEditorGlobal.clear();
            this.mEditorLocal.clear();
            return this;
        }

        public SharedPreferences.Editor remove(String key) {
            this.mEditorGlobal.remove(key);
            this.mEditorLocal.remove(key);
            return this;
        }

        public SharedPreferences.Editor putString(String key, String value) {
            if (ComboPreferences.isGlobal(key)) {
                this.mEditorGlobal.putString(key, value);
            } else {
                this.mEditorLocal.putString(key, value);
            }
            return this;
        }

        public SharedPreferences.Editor putInt(String key, int value) {
            if (ComboPreferences.isGlobal(key)) {
                this.mEditorGlobal.putInt(key, value);
            } else {
                this.mEditorLocal.putInt(key, value);
            }
            return this;
        }

        public SharedPreferences.Editor putLong(String key, long value) {
            if (ComboPreferences.isGlobal(key)) {
                this.mEditorGlobal.putLong(key, value);
            } else {
                this.mEditorLocal.putLong(key, value);
            }
            return this;
        }

        public SharedPreferences.Editor putFloat(String key, float value) {
            if (ComboPreferences.isGlobal(key)) {
                this.mEditorGlobal.putFloat(key, value);
            } else {
                this.mEditorLocal.putFloat(key, value);
            }
            return this;
        }

        public SharedPreferences.Editor putBoolean(String key, boolean value) {
            if (ComboPreferences.isGlobal(key)) {
                this.mEditorGlobal.putBoolean(key, value);
            } else {
                this.mEditorLocal.putBoolean(key, value);
            }
            return this;
        }

        public SharedPreferences.Editor putStringSet(String key, Set<String> values) {
            throw new UnsupportedOperationException();
        }
    }
}

