/*
 * Decompiled with CFR 0.152.
 */
package com.android.camera;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import com.android.camera.ComboPreferences;
import com.android.camera.R;

public abstract class CameraPreference {
    private final String mTitle;
    private SharedPreferences mSharedPreferences;
    private final Context mContext;

    public CameraPreference(Context context, AttributeSet attrs) {
        this.mContext = context;
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.CameraPreference, 0, 0);
        this.mTitle = a.getString(0);
        a.recycle();
    }

    public String getTitle() {
        return this.mTitle;
    }

    public SharedPreferences getSharedPreferences() {
        if (this.mSharedPreferences == null) {
            this.mSharedPreferences = ComboPreferences.get(this.mContext);
        }
        return this.mSharedPreferences;
    }

    public abstract void reloadValue();
}

