/*
 * Decompiled with CFR 0.152.
 */
package com.android.camera;

import android.content.ContentResolver;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.provider.MediaStore;
import android.util.Log;
import java.util.WeakHashMap;

public class BitmapManager {
    private static final String TAG = "BitmapManager";
    private final WeakHashMap<Thread, ThreadStatus> mThreadStatus = new WeakHashMap();
    private static BitmapManager sManager = null;

    private BitmapManager() {
    }

    private synchronized ThreadStatus getOrCreateThreadStatus(Thread t) {
        ThreadStatus status = this.mThreadStatus.get(t);
        if (status == null) {
            status = new ThreadStatus();
            this.mThreadStatus.put(t, status);
        }
        return status;
    }

    public synchronized boolean canThreadDecoding(Thread t) {
        ThreadStatus status = this.mThreadStatus.get(t);
        if (status == null) {
            return true;
        }
        boolean result = status.mState != State.CANCEL;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bitmap getThumbnail(ContentResolver cr, long origId, int kind, BitmapFactory.Options options, boolean isVideo) {
        Thread t = Thread.currentThread();
        ThreadStatus status = this.getOrCreateThreadStatus(t);
        if (!this.canThreadDecoding(t)) {
            Log.d((String)TAG, (String)("Thread " + t + " is not allowed to decode."));
            return null;
        }
        try {
            if (isVideo) {
                Bitmap bitmap = MediaStore.Video.Thumbnails.getThumbnail((ContentResolver)cr, (long)origId, (long)t.getId(), (int)kind, null);
                return bitmap;
            }
            Bitmap bitmap = MediaStore.Images.Thumbnails.getThumbnail((ContentResolver)cr, (long)origId, (long)t.getId(), (int)kind, null);
            return bitmap;
        }
        finally {
            ThreadStatus threadStatus = status;
            synchronized (threadStatus) {
                status.notifyAll();
            }
        }
    }

    public static synchronized BitmapManager instance() {
        if (sManager == null) {
            sManager = new BitmapManager();
        }
        return sManager;
    }

    private static class ThreadStatus {
        public State mState = State.ALLOW;
        public BitmapFactory.Options mOptions;

        private ThreadStatus() {
        }

        public String toString() {
            String s = this.mState == State.CANCEL ? "Cancel" : (this.mState == State.ALLOW ? "Allow" : "?");
            s = "thread state = " + s + ", options = " + this.mOptions;
            return s;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        CANCEL,
        ALLOW;

    }
}

