/*
 * Decompiled with CFR 0.152.
 */
package com.android.camera.ui;

import android.content.Context;
import android.graphics.Rect;
import android.view.MotionEvent;
import com.android.camera.Util;
import com.android.camera.ui.BitmapTexture;
import com.android.camera.ui.GLRootView;
import com.android.camera.ui.GLView;
import com.android.camera.ui.MeasureHelper;
import com.android.camera.ui.NinePatchTexture;
import com.android.camera.ui.ResourceTexture;
import com.android.camera.ui.StringTexture;
import com.android.camera.ui.ZoomControllerListener;
import java.text.DecimalFormat;
import java.util.Arrays;
import javax.microedition.khronos.opengles.GL11;

class ZoomController
extends GLView {
    private static final int LABEL_COLOR = -1;
    private static final DecimalFormat sZoomFormat = new DecimalFormat("#.#x");
    private static final int INVALID_POSITION = Integer.MAX_VALUE;
    private static final float LABEL_FONT_SIZE = 18.0f;
    private static final int HORIZONTAL_PADDING = 3;
    private static final int VERTICAL_PADDING = 3;
    private static final int MINIMAL_HEIGHT = 150;
    private static final float TOLERANCE_RADIUS = 30.0f;
    private static float sLabelSize;
    private static int sHorizontalPadding;
    private static int sVerticalPadding;
    private static int sMinimalHeight;
    private static float sToleranceRadius;
    private static NinePatchTexture sBackground;
    private static BitmapTexture sSlider;
    private static BitmapTexture sTickMark;
    private static BitmapTexture sFineTickMark;
    private StringTexture[] mTickLabels;
    private float[] mRatios;
    private int mIndex;
    private int mFineTickStep;
    private int mLabelStep;
    private int mMaxLabelWidth;
    private int mMaxLabelHeight;
    private int mSliderTop;
    private int mSliderBottom;
    private int mSliderLeft;
    private int mSliderPosition = Integer.MAX_VALUE;
    private float mValueGap;
    private ZoomControllerListener mZoomListener;

    public ZoomController(Context context) {
        ZoomController.initializeStaticVariable(context);
    }

    private void onSliderMoved(int position, boolean isMoving) {
        this.mSliderPosition = position = Util.clamp(position, this.mSliderTop, this.mSliderBottom - sSlider.getHeight());
        this.invalidate();
        int index = this.mRatios.length - 1 - (int)((float)(position - this.mSliderTop) / this.mValueGap + 0.5f);
        if (index != this.mIndex || !isMoving) {
            this.mIndex = index;
            if (this.mZoomListener != null) {
                this.mZoomListener.onZoomChanged(this.mIndex, this.mRatios[this.mIndex], isMoving);
            }
        }
    }

    private static void initializeStaticVariable(Context context) {
        if (sBackground != null) {
            return;
        }
        sLabelSize = GLRootView.dpToPixel(context, 18.0f);
        sHorizontalPadding = GLRootView.dpToPixel(context, 3);
        sVerticalPadding = GLRootView.dpToPixel(context, 3);
        sMinimalHeight = GLRootView.dpToPixel(context, 150);
        sToleranceRadius = GLRootView.dpToPixel(context, 30.0f);
        sBackground = new NinePatchTexture(context, 2130837576);
        sSlider = new ResourceTexture(context, 2130837578);
        sTickMark = new ResourceTexture(context, 2130837579);
        sFineTickMark = new ResourceTexture(context, 2130837577);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        if (!changed) {
            return;
        }
        Rect p = this.mPaddings;
        int height = b - t - p.top - p.bottom;
        int margin = Math.max(sSlider.getHeight(), this.mMaxLabelHeight);
        this.mValueGap = (float)(height - margin) / (float)(this.mRatios.length - 1);
        this.mSliderLeft = p.left + this.mMaxLabelWidth + sHorizontalPadding + sTickMark.getWidth() + sHorizontalPadding;
        this.mSliderTop = p.top + margin / 2 - sSlider.getHeight() / 2;
        this.mSliderBottom = this.mSliderTop + height - margin + sSlider.getHeight();
    }

    private boolean withInToleranceRange(float x, float y) {
        float sy;
        float sx = this.mSliderLeft + sSlider.getWidth() / 2;
        float dist = Util.distance(x, y, sx, sy = (float)this.mSliderTop + (float)(this.mRatios.length - 1 - this.mIndex) * this.mValueGap + (float)(sSlider.getHeight() / 2));
        return dist <= sToleranceRadius;
    }

    protected boolean onTouch(MotionEvent e) {
        float x = e.getX();
        float y = e.getY();
        switch (e.getAction()) {
            case 0: {
                if (this.withInToleranceRange(x, y)) {
                    this.onSliderMoved((int)(y - (float)sSlider.getHeight()), true);
                }
                return true;
            }
            case 2: {
                if (this.mSliderPosition != Integer.MAX_VALUE) {
                    this.onSliderMoved((int)(y - (float)sSlider.getHeight()), true);
                }
                return true;
            }
            case 1: {
                if (this.mSliderPosition != Integer.MAX_VALUE) {
                    this.onSliderMoved((int)(y - (float)sSlider.getHeight()), false);
                    this.mSliderPosition = Integer.MAX_VALUE;
                }
                return true;
            }
        }
        return true;
    }

    public void setAvailableZoomRatios(float[] ratios) {
        if (Arrays.equals(ratios, this.mRatios)) {
            return;
        }
        this.mRatios = ratios;
        this.mLabelStep = this.getLabelStep(ratios.length);
        this.mTickLabels = new StringTexture[(ratios.length + this.mLabelStep - 1) / this.mLabelStep];
        int n = this.mTickLabels.length;
        for (int i = 0; i < n; ++i) {
            this.mTickLabels[i] = StringTexture.newInstance(sZoomFormat.format(ratios[i * this.mLabelStep]), sLabelSize, -1);
        }
        this.mFineTickStep = this.mLabelStep % 3 == 0 ? this.mLabelStep / 3 : (this.mLabelStep % 2 == 0 ? this.mLabelStep / 2 : 0);
        int maxHeight = 0;
        int maxWidth = 0;
        int labelCount = this.mTickLabels.length;
        for (int i = 0; i < labelCount; ++i) {
            maxWidth = Math.max(maxWidth, this.mTickLabels[i].getWidth());
            maxHeight = Math.max(maxHeight, this.mTickLabels[i].getHeight());
        }
        this.mMaxLabelHeight = maxHeight;
        this.mMaxLabelWidth = maxWidth;
        this.invalidate();
    }

    private int getLabelStep(int valueCount) {
        if (valueCount < 5) {
            return 1;
        }
        int step = valueCount / 5;
        while (valueCount / step > 5) {
            ++step;
        }
        return step;
    }

    protected void onMeasure(int widthSpec, int heightSpec) {
        int labelCount = this.mTickLabels.length;
        int ratioCount = this.mRatios.length;
        int height = (this.mMaxLabelHeight + sVerticalPadding) * (labelCount - 1) * ratioCount / (this.mLabelStep * labelCount) + Math.max(sSlider.getHeight(), this.mMaxLabelHeight);
        int width = this.mMaxLabelWidth + sHorizontalPadding + sTickMark.getWidth() + sHorizontalPadding + sBackground.getWidth();
        height = Math.max(sMinimalHeight, height);
        new MeasureHelper(this).setPreferredContentSize(width, height).measure(widthSpec, heightSpec);
    }

    protected void render(GLRootView root, GL11 gl) {
        this.renderTicks(root, gl);
        this.renderSlider(root, gl);
    }

    private void renderTicks(GLRootView root, GL11 gl) {
        int i;
        float gap = this.mValueGap;
        int labelStep = this.mLabelStep;
        int xoffset = this.mPaddings.left + this.mMaxLabelWidth;
        float yoffset = this.mSliderBottom - sSlider.getHeight() / 2;
        for (StringTexture t : this.mTickLabels) {
            t.draw(root, xoffset - t.getWidth(), (int)(yoffset - (float)(t.getHeight() / 2)));
            yoffset -= (float)labelStep * gap;
        }
        BitmapTexture tickMark = sTickMark;
        xoffset += sHorizontalPadding;
        yoffset = this.mSliderBottom - sSlider.getHeight() / 2;
        int halfHeight = tickMark.getHeight() / 2;
        int n = this.mTickLabels.length;
        for (i = 0; i < n; ++i) {
            tickMark.draw(root, xoffset, (int)(yoffset - (float)halfHeight));
            yoffset -= (float)labelStep * gap;
        }
        if (this.mFineTickStep > 0) {
            tickMark = sFineTickMark;
            xoffset += sTickMark.getWidth() - tickMark.getWidth();
            yoffset = this.mSliderBottom - sSlider.getHeight() / 2;
            halfHeight = tickMark.getHeight() / 2;
            n = this.mRatios.length;
            for (i = 0; i < n; ++i) {
                if (i % this.mLabelStep != 0) {
                    tickMark.draw(root, xoffset, (int)(yoffset - (float)halfHeight));
                }
                yoffset -= gap;
            }
        }
    }

    private void renderSlider(GLRootView root, GL11 gl) {
        int left = this.mSliderLeft;
        int bottom = this.mSliderBottom;
        int top = this.mSliderTop;
        sBackground.draw(root, left, top, sBackground.getWidth(), bottom - top);
        if (this.mSliderPosition == Integer.MAX_VALUE) {
            sSlider.draw(root, left, (int)((float)top + this.mValueGap * (float)(this.mRatios.length - 1 - this.mIndex)));
        } else {
            sSlider.draw(root, left, this.mSliderPosition);
        }
    }

    public void setZoomListener(ZoomControllerListener listener) {
        this.mZoomListener = listener;
    }

    public void setZoomIndex(int index) {
        if (this.mIndex == (index = Util.clamp(index, 0, this.mRatios.length - 1))) {
            return;
        }
        this.mIndex = index;
        if (this.mZoomListener != null) {
            this.mZoomListener.onZoomChanged(this.mIndex, this.mRatios[this.mIndex], false);
        }
    }
}

