/*
 * Decompiled with CFR 0.152.
 */
package com.android.camera.ui;

import android.graphics.Matrix;
import android.view.MotionEvent;
import com.android.camera.ui.GLRootView;
import com.android.camera.ui.GLView;
import javax.microedition.khronos.opengles.GL11;

class RotatePane
extends GLView {
    public static final int UP = 0;
    public static final int RIGHT = 1;
    public static final int DOWN = 2;
    public static final int LEFT = 3;
    private int mOrientation = 0;
    private GLView mChild;

    RotatePane() {
    }

    protected void onLayout(boolean change, int left, int top, int right, int bottom) {
        int width = right - left;
        int height = bottom - top;
        switch (this.mOrientation) {
            case 0: 
            case 2: {
                this.mChild.layout(0, 0, width, height);
                break;
            }
            case 1: 
            case 3: {
                this.mChild.layout(0, 0, height, width);
            }
        }
    }

    protected void onMeasure(int widthSpec, int heightSpec) {
        GLView c = this.mChild;
        switch (this.mOrientation) {
            case 0: 
            case 2: {
                c.measure(widthSpec, heightSpec);
                this.setMeasuredSize(c.getMeasuredWidth(), c.getMeasuredHeight());
                break;
            }
            case 1: 
            case 3: {
                this.mChild.measure(heightSpec, widthSpec);
                this.setMeasuredSize(c.getMeasuredHeight(), c.getMeasuredWidth());
            }
        }
    }

    protected void render(GLRootView view, GL11 gl) {
        if (this.mOrientation == 0) {
            this.mChild.render(view, gl);
            return;
        }
        view.pushTransform();
        Matrix matrix = view.getTransformation().getMatrix();
        float width = this.getWidth();
        float height = this.getHeight();
        switch (this.mOrientation) {
            case 2: {
                matrix.preRotate(180.0f, width / 2.0f, height / 2.0f);
                break;
            }
            case 3: {
                matrix.preRotate(270.0f, height / 2.0f, height / 2.0f);
                break;
            }
            case 1: {
                matrix.preRotate(90.0f, width / 2.0f, width / 2.0f);
            }
        }
        this.mChild.render(view, gl);
        view.popTransform();
    }

    protected boolean dispatchTouchEvent(MotionEvent event) {
        float x = event.getX();
        float y = event.getY();
        float width = this.getWidth();
        float height = this.getHeight();
        switch (this.mOrientation) {
            case 2: {
                event.setLocation(width - x, height - y);
                break;
            }
            case 3: {
                event.setLocation(height - y, x);
                break;
            }
            case 1: {
                event.setLocation(y, width - x);
            }
        }
        boolean result = this.mChild.dispatchTouchEvent(event);
        event.setLocation(x, y);
        return result;
    }

    public void setOrientation(int orientation) {
        if (this.mOrientation == orientation) {
            return;
        }
        this.mOrientation = orientation;
        this.requestLayout();
    }

    public void setContent(GLView view) {
        if (this.mChild == view) {
            return;
        }
        if (this.mChild != null) {
            super.clearComponents();
        }
        this.mChild = view;
        if (view != null) {
            super.addComponent(view);
        }
        this.requestLayout();
    }

    public void addComponent(GLView view) {
        throw new UnsupportedOperationException("use setContent(GLView)");
    }

    public void clearComponents() {
        throw new UnsupportedOperationException("use setContent(null)");
    }
}

