/*
 * Decompiled with CFR 0.152.
 */
package com.android.camera.ui;

import android.content.Context;
import android.content.SharedPreferences;
import com.android.camera.IconListPreference;
import com.android.camera.ListPreference;
import com.android.camera.Util;
import com.android.camera.ui.GLListView;
import com.android.camera.ui.GLOptionHeader;
import com.android.camera.ui.GLOptionItem;
import com.android.camera.ui.GLView;
import java.util.ArrayList;

class PreferenceAdapter
implements GLListView.Model,
GLListView.OnItemSelectedListener {
    private static final int ICON_NONE = 0;
    private final ArrayList<GLView> mContent = new ArrayList();
    private final ListPreference mPreference;
    private String mOverride;

    public PreferenceAdapter(Context context, ListPreference preference) {
        this.mPreference = preference;
        this.generateContent(context, preference);
    }

    public void reload() {
        this.updateContent(null, true);
    }

    public void overrideSettings(String settings) {
        this.updateContent(settings, false);
    }

    private void updateContent(String settings, boolean reloadValues) {
        if (!reloadValues && Util.equals(settings, this.mOverride)) {
            return;
        }
        this.mOverride = settings;
        CharSequence[] values = this.mPreference.getEntryValues();
        String value = this.mPreference.getValue();
        if (settings == null) {
            int n = this.mContent.size();
            for (int i = 1; i < n; ++i) {
                GLOptionItem item = (GLOptionItem)this.mContent.get(i);
                item.setChecked(values[i - 1].equals(value));
                item.setEnabled(true);
            }
        } else {
            int n = this.mContent.size();
            for (int i = 1; i < n; ++i) {
                GLOptionItem item = (GLOptionItem)this.mContent.get(i);
                boolean checked = values[i - 1].equals(settings);
                item.setChecked(checked);
                item.setEnabled(checked);
            }
        }
    }

    private void generateContent(Context context, ListPreference preference) {
        GLOptionHeader header = new GLOptionHeader(context, preference.getTitle());
        this.mContent.add(header);
        CharSequence[] entries = preference.getEntries();
        CharSequence[] values = preference.getEntryValues();
        String value = preference.getValue();
        int[] icons = null;
        if (preference instanceof IconListPreference) {
            IconListPreference iPref = (IconListPreference)preference;
            icons = iPref.getIconIds();
        }
        int n = entries.length;
        for (int i = 0; i < n; ++i) {
            GLOptionItem item = new GLOptionItem(context, icons == null ? 0 : icons[i], ((Object)entries[i]).toString());
            item.setChecked(values[i].equals(value));
            this.mContent.add(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onItemSelected(GLView view, int position) {
        if (this.mOverride != null) {
            return;
        }
        ListPreference pref = this.mPreference;
        CharSequence[] values = pref.getEntryValues();
        if (position < values.length + 1) {
            int index = position - 1;
            int oldIndex = pref.findIndexOfValue(pref.getValue());
            if (oldIndex != index) {
                SharedPreferences sharedPreferences = pref.getSharedPreferences();
                synchronized (sharedPreferences) {
                    pref.setValueIndex(index);
                }
                ((GLOptionItem)this.mContent.get(1 + oldIndex)).setChecked(false);
                ((GLOptionItem)view).setChecked(true);
            }
            return;
        }
    }

    public GLView getView(int index) {
        return this.mContent.get(index);
    }

    public boolean isSelectable(int index) {
        return this.mContent.get(index) instanceof GLOptionItem;
    }

    public int size() {
        return this.mContent.size();
    }
}

