/*
 * Decompiled with CFR 0.152.
 */
package com.android.camera.ui;

import android.graphics.Rect;
import android.view.View;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.Interpolator;
import android.view.animation.OvershootInterpolator;
import android.view.animation.ScaleAnimation;
import com.android.camera.ui.BitmapTexture;
import com.android.camera.ui.GLOutOfMemoryException;
import com.android.camera.ui.GLRootView;
import com.android.camera.ui.GLView;
import com.android.camera.ui.NinePatchTexture;
import com.android.camera.ui.RawTexture;
import com.android.camera.ui.RotatePane;
import com.android.camera.ui.Texture;
import javax.microedition.khronos.opengles.GL11;

class PopupWindow
extends GLView {
    protected BitmapTexture mAnchor;
    protected int mAnchorOffset;
    protected int mAnchorPosition;
    private final RotatePane mRotatePane = new RotatePane();
    private RawTexture mBackupTexture;
    protected Texture mBackground;
    private boolean mUsingStencil;

    public PopupWindow() {
        super.addComponent(this.mRotatePane);
    }

    protected void onAttachToRoot(GLRootView root) {
        super.onAttachToRoot(root);
        this.mUsingStencil = root.getEGLConfigChooser().getStencilBits() > 0;
    }

    public void setBackground(Texture background) {
        if (background == this.mBackground) {
            return;
        }
        this.mBackground = background;
        if (background != null && background instanceof NinePatchTexture) {
            this.setPaddings(((NinePatchTexture)this.mBackground).getPaddings());
        } else {
            this.setPaddings(0, 0, 0, 0);
        }
        this.invalidate();
    }

    public void setAnchor(BitmapTexture anchor, int offset) {
        this.mAnchor = anchor;
        this.mAnchorOffset = offset;
    }

    public void addComponent(GLView component) {
        throw new UnsupportedOperationException("use setContent(GLView)");
    }

    protected void onMeasure(int widthSpec, int heightSpec) {
        int heightMode;
        int widthMode = View.MeasureSpec.getMode((int)widthSpec);
        if (widthMode != 0) {
            Rect p = this.mPaddings;
            int width = View.MeasureSpec.getSize((int)widthSpec);
            widthSpec = View.MeasureSpec.makeMeasureSpec((int)Math.max(0, width - p.left - p.right - this.mAnchor.getWidth() + this.mAnchorOffset), (int)widthMode);
        }
        if ((heightMode = View.MeasureSpec.getMode((int)heightSpec)) != 0) {
            int height = View.MeasureSpec.getSize((int)widthSpec);
            widthSpec = View.MeasureSpec.makeMeasureSpec((int)Math.max(0, height - this.mPaddings.top - this.mPaddings.bottom), (int)heightMode);
        }
        Rect p = this.mPaddings;
        RotatePane child = this.mRotatePane;
        child.measure(widthSpec, heightSpec);
        this.setMeasuredSize(child.getMeasuredWidth() + p.left + p.right + this.mAnchor.getWidth() - this.mAnchorOffset, child.getMeasuredHeight() + p.top + p.bottom);
    }

    protected void onLayout(boolean change, int left, int top, int right, int bottom) {
        Rect p = this.getPaddings();
        RotatePane view = this.mRotatePane;
        view.layout(p.left, p.top, this.getWidth() - p.right - this.mAnchor.getWidth() + this.mAnchorOffset, this.getHeight() - p.bottom);
    }

    public void setAnchorPosition(int yoffset) {
        this.mAnchorPosition = yoffset;
    }

    private void renderBackgroundWithStencil(GLRootView root, GL11 gl) {
        int width = this.getWidth();
        int height = this.getHeight();
        int aWidth = this.mAnchor.getWidth();
        int aHeight = this.mAnchor.getHeight();
        Rect p = this.mPaddings;
        int aXoffset = width - aWidth;
        int aYoffset = Math.max(p.top, this.mAnchorPosition - aHeight / 2);
        aYoffset = Math.min(aYoffset, height - p.bottom - aHeight);
        if (this.mAnchor != null) {
            gl.glStencilOp(7680, 7680, 7681);
            gl.glStencilFunc(519, 1, 1);
            this.mAnchor.draw(root, aXoffset, aYoffset);
            gl.glStencilFunc(517, 1, 1);
            gl.glStencilOp(7680, 7680, 7680);
        }
        if (this.mBackground != null) {
            this.mBackground.draw(root, 0, 0, width - aWidth + this.mAnchorOffset, height);
        }
    }

    private void renderBackgroundWithoutStencil(GLRootView root, GL11 gl) {
        int width = this.getWidth();
        int height = this.getHeight();
        int aWidth = this.mAnchor.getWidth();
        int aHeight = this.mAnchor.getHeight();
        Rect p = this.mPaddings;
        int aXoffset = width - aWidth;
        int aYoffset = Math.max(p.top, this.mAnchorPosition - aHeight / 2);
        aYoffset = Math.min(aYoffset, height - p.bottom - aHeight);
        if (this.mAnchor != null) {
            this.mAnchor.draw(root, aXoffset, aYoffset);
        }
        if (this.mBackupTexture == null || this.mBackupTexture.getBoundGL() != gl) {
            this.mBackupTexture = RawTexture.newInstance(gl);
        }
        RawTexture backup = this.mBackupTexture;
        try {
            root.copyTexture2D(backup, aXoffset, aYoffset, aWidth, aHeight);
        }
        catch (GLOutOfMemoryException e) {
            e.printStackTrace();
        }
        if (this.mBackground != null) {
            this.mBackground.draw(root, 0, 0, width - aWidth + this.mAnchorOffset, height);
        }
        gl.glBlendFunc(1, 0);
        backup.drawBack(root, aXoffset, aYoffset, aWidth, aHeight);
        gl.glBlendFunc(1, 771);
    }

    protected void renderBackground(GLRootView root, GL11 gl) {
        if (this.mUsingStencil) {
            this.renderBackgroundWithStencil(root, gl);
        } else {
            this.renderBackgroundWithoutStencil(root, gl);
        }
    }

    public void setContent(GLView content) {
        this.mRotatePane.setContent(content);
    }

    public void clearComponents() {
        throw new UnsupportedOperationException();
    }

    public void popup() {
        this.setVisibility(0);
        AnimationSet set = new AnimationSet(false);
        ScaleAnimation scale = new ScaleAnimation(0.7f, 1.0f, 0.7f, 1.0f, (float)this.getWidth(), (float)this.mAnchorPosition);
        AlphaAnimation alpha = new AlphaAnimation(0.5f, 1.0f);
        set.addAnimation((Animation)scale);
        set.addAnimation((Animation)alpha);
        scale.setDuration(150L);
        alpha.setDuration(100L);
        scale.setInterpolator((Interpolator)new OvershootInterpolator());
        this.startAnimation((Animation)set);
    }

    public void popoff() {
        this.setVisibility(1);
        AlphaAnimation alpha = new AlphaAnimation(0.7f, 0.0f);
        alpha.setDuration(100L);
        this.startAnimation((Animation)alpha);
    }

    public void setOrientation(int orientation) {
        switch (orientation) {
            case 90: {
                this.mRotatePane.setOrientation(3);
                break;
            }
            case 180: {
                this.mRotatePane.setOrientation(2);
                break;
            }
            case 270: {
                this.mRotatePane.setOrientation(1);
                break;
            }
            default: {
                this.mRotatePane.setOrientation(0);
            }
        }
    }
}

