/*
 * Decompiled with CFR 0.152.
 */
package com.android.camera.ui;

import android.graphics.Rect;
import android.view.View;
import com.android.camera.ui.GLView;

class MeasureHelper {
    private final GLView mComponent;
    private int mPreferredWidth;
    private int mPreferredHeight;

    public MeasureHelper(GLView component) {
        this.mComponent = component;
    }

    public MeasureHelper setPreferredContentSize(int width, int height) {
        this.mPreferredWidth = width;
        this.mPreferredHeight = height;
        return this;
    }

    public void measure(int widthSpec, int heightSpec) {
        Rect p = this.mComponent.getPaddings();
        this.setMeasuredSize(MeasureHelper.getLength(widthSpec, this.mPreferredWidth + p.left + p.right), MeasureHelper.getLength(heightSpec, this.mPreferredHeight + p.top + p.bottom));
    }

    private static int getLength(int measureSpec, int prefered) {
        int specLength = View.MeasureSpec.getSize((int)measureSpec);
        switch (View.MeasureSpec.getMode((int)measureSpec)) {
            case 0x40000000: {
                return specLength;
            }
            case -2147483648: {
                return Math.min(prefered, specLength);
            }
        }
        return prefered;
    }

    protected void setMeasuredSize(int width, int height) {
        this.mComponent.setMeasuredSize(width, height);
    }
}

