/*
 * Decompiled with CFR 0.152.
 */
package com.android.camera.ui;

import android.graphics.Matrix;
import android.graphics.Rect;
import android.os.SystemClock;
import android.view.MotionEvent;
import android.view.animation.Animation;
import android.view.animation.Transformation;
import com.android.camera.ui.GLRootView;
import java.util.ArrayList;
import javax.microedition.khronos.opengles.GL11;

public class GLView {
    private static final String TAG = "GLView";
    public static final int VISIBLE = 0;
    public static final int INVISIBLE = 1;
    public static final int FLAG_INVISIBLE = 1;
    public static final int FLAG_SET_MEASURED_SIZE = 2;
    public static final int FLAG_LAYOUT_REQUESTED = 4;
    protected final Rect mBounds = new Rect();
    protected final Rect mPaddings = new Rect();
    private GLRootView mRootView;
    private GLView mParent;
    private ArrayList<GLView> mComponents;
    private GLView mMotionTarget;
    private OnTouchListener mOnTouchListener;
    private Animation mAnimation;
    protected int mViewFlags = 0;
    protected int mMeasuredWidth = 0;
    protected int mMeasuredHeight = 0;
    private int mLastWidthSpec = -1;
    private int mLastHeightSpec = -1;
    protected int mScrollY = 0;
    protected int mScrollX = 0;
    protected int mScrollHeight = 0;
    protected int mScrollWidth = 0;

    public void startAnimation(Animation animation) {
        GLRootView root = this.getGLRootView();
        if (root == null) {
            throw new IllegalStateException();
        }
        this.mAnimation = animation;
        animation.initialize(this.getWidth(), this.getHeight(), this.mParent.getWidth(), this.mParent.getHeight());
        this.mAnimation.start();
        root.registerLaunchedAnimation(animation);
        this.invalidate();
    }

    public void setVisibility(int visibility) {
        if (visibility == this.getVisibility()) {
            return;
        }
        this.mViewFlags = visibility == 0 ? (this.mViewFlags &= 0xFFFFFFFE) : (this.mViewFlags |= 1);
        this.onVisibilityChanged(visibility);
        this.invalidate();
    }

    public int getVisibility() {
        return (this.mViewFlags & 1) == 0 ? 0 : 1;
    }

    private boolean setBounds(int left, int top, int right, int bottom) {
        boolean sizeChanged = right - left != this.mBounds.right - this.mBounds.left || bottom - top != this.mBounds.bottom - this.mBounds.top;
        this.mBounds.set(left, top, right, bottom);
        return sizeChanged;
    }

    protected void onAddToParent(GLView parent) {
        this.mParent = parent;
        if (parent != null && parent.mRootView != null) {
            this.onAttachToRoot(parent.mRootView);
        }
    }

    protected void onRemoveFromParent(GLView parent) {
        if (parent != null && parent.mMotionTarget == this) {
            long now = SystemClock.uptimeMillis();
            this.dispatchTouchEvent(MotionEvent.obtain((long)now, (long)now, (int)3, (float)0.0f, (float)0.0f, (int)0));
            parent.mMotionTarget = null;
        }
        this.onDetachFromRoot();
        this.mParent = null;
    }

    public void clearComponents() {
        this.mComponents = null;
    }

    public int getComponentCount() {
        return this.mComponents == null ? 0 : this.mComponents.size();
    }

    public GLView getComponent(int index) {
        if (this.mComponents == null) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return this.mComponents.get(index);
    }

    public void addComponent(GLView component) {
        if (this.mComponents == null) {
            this.mComponents = new ArrayList();
        }
        this.mComponents.add(component);
        component.onAddToParent(this);
    }

    public boolean removeComponent(GLView component) {
        if (this.mComponents == null) {
            return false;
        }
        if (this.mComponents.remove(component)) {
            component.onRemoveFromParent(this);
            return true;
        }
        return false;
    }

    public Rect bounds() {
        return this.mBounds;
    }

    public int getWidth() {
        return this.mBounds.right - this.mBounds.left;
    }

    public int getHeight() {
        return this.mBounds.bottom - this.mBounds.top;
    }

    public GLRootView getGLRootView() {
        return this.mRootView;
    }

    public void setOnTouchListener(OnTouchListener listener) {
        this.mOnTouchListener = listener;
    }

    public void invalidate() {
        GLRootView root = this.getGLRootView();
        if (root != null) {
            root.requestRender();
        }
    }

    public void requestLayout() {
        this.mViewFlags |= 4;
        if (this.mParent != null) {
            this.mParent.requestLayout();
        } else {
            GLRootView root = this.getGLRootView();
            if (root != null) {
                root.requestLayoutContentPane();
            }
        }
    }

    protected void render(GLRootView view, GL11 gl) {
        this.renderBackground(view, gl);
        int n = this.getComponentCount();
        for (int i = 0; i < n; ++i) {
            GLView component = this.getComponent(i);
            if (component.getVisibility() != 0 && component.mAnimation == null) continue;
            this.renderChild(view, gl, component);
        }
    }

    protected void renderBackground(GLRootView view, GL11 gl) {
    }

    protected void renderChild(GLRootView root, GL11 gl, GLView component) {
        int xoffset = component.mBounds.left - this.mScrollX;
        int yoffset = component.mBounds.top - this.mScrollY;
        Transformation transform = root.getTransformation();
        Matrix matrix = transform.getMatrix();
        matrix.preTranslate((float)xoffset, (float)yoffset);
        Animation anim2 = component.mAnimation;
        if (anim2 != null) {
            Transformation temp;
            long now = root.currentAnimationTimeMillis();
            if (!anim2.getTransformation(now, temp = root.obtainTransformation())) {
                component.mAnimation = null;
            }
            this.invalidate();
            root.pushTransform();
            transform.compose(temp);
            root.freeTransformation(temp);
        }
        component.render(root, gl);
        if (anim2 != null) {
            root.popTransform();
        }
        matrix.preTranslate((float)(-xoffset), (float)(-yoffset));
    }

    protected boolean onTouch(MotionEvent event) {
        if (this.mOnTouchListener != null) {
            return this.mOnTouchListener.onTouch(this, event);
        }
        return false;
    }

    private boolean dispatchTouchEvent(MotionEvent event, int x, int y, GLView component, boolean checkBounds) {
        Rect rect = component.mBounds;
        int left = rect.left;
        int top = rect.top;
        if (!checkBounds || rect.contains(x, y)) {
            event.offsetLocation((float)(-left), (float)(-top));
            if (component.dispatchTouchEvent(event)) {
                event.offsetLocation((float)left, (float)top);
                return true;
            }
            event.offsetLocation((float)left, (float)top);
        }
        return false;
    }

    protected boolean dispatchTouchEvent(MotionEvent event) {
        int x = (int)event.getX();
        int y = (int)event.getY();
        int action = event.getAction();
        if (this.mMotionTarget != null) {
            if (action == 0) {
                MotionEvent cancel = MotionEvent.obtain((MotionEvent)event);
                cancel.setAction(3);
                this.mMotionTarget = null;
            } else {
                this.dispatchTouchEvent(event, x, y, this.mMotionTarget, false);
                if (action == 3 || action == 1) {
                    this.mMotionTarget = null;
                }
                return true;
            }
        }
        if (action == 0) {
            int n = this.getComponentCount();
            for (int i = 0; i < n; ++i) {
                GLView component = this.getComponent(i);
                if (component.getVisibility() != 0 || !this.dispatchTouchEvent(event, x, y, component, true)) continue;
                this.mMotionTarget = component;
                return true;
            }
        }
        return this.onTouch(event);
    }

    public Rect getPaddings() {
        return this.mPaddings;
    }

    public void setPaddings(Rect paddings) {
        this.mPaddings.set(paddings);
    }

    public void setPaddings(int left, int top, int right, int bottom) {
        this.mPaddings.set(left, top, right, bottom);
    }

    public void layout(int left, int top, int right, int bottom) {
        boolean sizeChanged = this.setBounds(left, top, right, bottom);
        if (sizeChanged) {
            this.mViewFlags &= 0xFFFFFFFB;
            this.onLayout(true, left, top, right, bottom);
        } else if ((this.mViewFlags & 4) != 0) {
            this.mViewFlags &= 0xFFFFFFFB;
            this.onLayout(false, left, top, right, bottom);
        }
    }

    public void measure(int widthSpec, int heightSpec) {
        if (widthSpec == this.mLastWidthSpec && heightSpec == this.mLastHeightSpec && (this.mViewFlags & 4) == 0) {
            return;
        }
        this.mLastWidthSpec = widthSpec;
        this.mLastHeightSpec = heightSpec;
        this.mViewFlags &= 0xFFFFFFFD;
        this.onMeasure(widthSpec, heightSpec);
        if ((this.mViewFlags & 2) == 0) {
            throw new IllegalStateException(this.getClass().getName() + " should call setMeasuredSize() in onMeasure()");
        }
    }

    protected void onMeasure(int widthSpec, int heightSpec) {
    }

    protected void setMeasuredSize(int width, int height) {
        this.mViewFlags |= 2;
        this.mMeasuredWidth = width;
        this.mMeasuredHeight = height;
    }

    public int getMeasuredWidth() {
        return this.mMeasuredWidth;
    }

    public int getMeasuredHeight() {
        return this.mMeasuredHeight;
    }

    protected void onLayout(boolean changeSize, int left, int top, int right, int bottom) {
    }

    public boolean getBoundsOf(GLView descendant, Rect out) {
        int xoffset = 0;
        int yoffset = 0;
        GLView view = descendant;
        while (view != this) {
            if (view == null) {
                return false;
            }
            Rect bounds = view.mBounds;
            xoffset += bounds.left;
            yoffset += bounds.top;
            view = view.mParent;
        }
        out.set(xoffset, yoffset, xoffset + descendant.getWidth(), yoffset + descendant.getHeight());
        return true;
    }

    protected void onVisibilityChanged(int visibility) {
        int n = this.getComponentCount();
        for (int i = 0; i < n; ++i) {
            GLView child = this.getComponent(i);
            if (child.getVisibility() != 0) continue;
            child.onVisibilityChanged(visibility);
        }
    }

    protected void onAttachToRoot(GLRootView root) {
        this.mRootView = root;
        int n = this.getComponentCount();
        for (int i = 0; i < n; ++i) {
            this.getComponent(i).onAttachToRoot(root);
        }
    }

    protected void onDetachFromRoot() {
        int n = this.getComponentCount();
        for (int i = 0; i < n; ++i) {
            this.getComponent(i).onDetachFromRoot();
        }
        this.mRootView = null;
    }

    public static interface OnTouchListener {
        public boolean onTouch(GLView var1, MotionEvent var2);
    }
}

