/*
 * Decompiled with CFR 0.152.
 */
package com.android.camera.ui;

import android.app.Activity;
import android.content.Context;
import android.graphics.Color;
import android.graphics.Matrix;
import android.opengl.GLSurfaceView;
import android.opengl.GLU;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.MotionEvent;
import android.view.animation.Animation;
import android.view.animation.Transformation;
import com.android.camera.Util;
import com.android.camera.ui.BasicTexture;
import com.android.camera.ui.CameraEGLConfigChooser;
import com.android.camera.ui.GLOutOfMemoryException;
import com.android.camera.ui.GLView;
import com.android.camera.ui.NinePatchChunk;
import com.android.camera.ui.NinePatchTexture;
import com.android.camera.ui.RawTexture;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Stack;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;
import javax.microedition.khronos.opengles.GL11;
import javax.microedition.khronos.opengles.GL11Ext;

public class GLRootView
extends GLSurfaceView
implements GLSurfaceView.Renderer {
    private static final String TAG = "GLRootView";
    private final boolean ENABLE_FPS_TEST = false;
    private int mFrameCount = 0;
    private long mFrameCountingStart = 0L;
    private static final int VERTEX_BUFFER_SIZE = 32;
    private static final int INDEX_BUFFER_SIZE = 22;
    private static final int FLAG_INITIALIZED = 1;
    private static final int FLAG_NEED_LAYOUT = 2;
    private static boolean mTexture2DEnabled;
    private static float sPixelDensity;
    private GL11 mGL;
    private GLView mContentView;
    private DisplayMetrics mDisplayMetrics;
    private final ArrayList<Animation> mAnimations = new ArrayList();
    private final Stack<Transformation> mFreeTransform = new Stack();
    private final Transformation mTransformation = new Transformation();
    private final Stack<Transformation> mTransformStack = new Stack();
    private float mLastAlpha = this.mTransformation.getAlpha();
    private final float[] mMatrixValues = new float[16];
    private final float[] mUvBuffer = new float[32];
    private final float[] mXyBuffer = new float[32];
    private final byte[] mIndexBuffer = new byte[22];
    private int[] mNinePatchX = new int[4];
    private int[] mNinePatchY = new int[4];
    private float[] mNinePatchU = new float[4];
    private float[] mNinePatchV = new float[4];
    private ByteBuffer mXyPointer;
    private ByteBuffer mUvPointer;
    private ByteBuffer mIndexPointer;
    private int mFlags = 2;
    private long mAnimationTime;
    private CameraEGLConfigChooser mEglConfigChooser = new CameraEGLConfigChooser();

    public GLRootView(Context context) {
        this(context, null);
    }

    public GLRootView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initialize();
    }

    void registerLaunchedAnimation(Animation animation) {
        this.mAnimations.add(animation);
    }

    public long currentAnimationTimeMillis() {
        return this.mAnimationTime;
    }

    public static synchronized float dpToPixel(Context context, float dp) {
        if (sPixelDensity < 0.0f) {
            DisplayMetrics metrics = new DisplayMetrics();
            ((Activity)context).getWindowManager().getDefaultDisplay().getMetrics(metrics);
            sPixelDensity = metrics.density;
        }
        return sPixelDensity * dp;
    }

    public static int dpToPixel(Context context, int dp) {
        return (int)(GLRootView.dpToPixel(context, (float)dp) + 0.5f);
    }

    public Transformation obtainTransformation() {
        if (!this.mFreeTransform.isEmpty()) {
            Transformation t = this.mFreeTransform.pop();
            t.clear();
            return t;
        }
        return new Transformation();
    }

    public void freeTransformation(Transformation freeTransformation) {
        this.mFreeTransform.push(freeTransformation);
    }

    public Transformation getTransformation() {
        return this.mTransformation;
    }

    public Transformation pushTransform() {
        Transformation trans = this.obtainTransformation();
        trans.set(this.mTransformation);
        this.mTransformStack.push(trans);
        return this.mTransformation;
    }

    public void popTransform() {
        Transformation trans = this.mTransformStack.pop();
        this.mTransformation.set(trans);
        this.freeTransformation(trans);
    }

    public CameraEGLConfigChooser getEGLConfigChooser() {
        return this.mEglConfigChooser;
    }

    private static ByteBuffer allocateDirectNativeOrderBuffer(int size) {
        return ByteBuffer.allocateDirect(size).order(ByteOrder.nativeOrder());
    }

    private void initialize() {
        this.mFlags |= 1;
        this.setEGLConfigChooser(this.mEglConfigChooser);
        this.getHolder().setFormat(-3);
        this.setZOrderOnTop(true);
        this.setRenderer(this);
        int size = 128;
        this.mXyPointer = GLRootView.allocateDirectNativeOrderBuffer(size);
        this.mUvPointer = GLRootView.allocateDirectNativeOrderBuffer(size);
        this.mIndexPointer = GLRootView.allocateDirectNativeOrderBuffer(22);
    }

    public void setContentPane(GLView content) {
        this.mContentView = content;
        content.onAttachToRoot(this);
        content.onAddToParent(null);
        this.requestLayoutContentPane();
    }

    public GLView getContentPane() {
        return this.mContentView;
    }

    void handleLowMemory() {
    }

    public synchronized void requestLayoutContentPane() {
        if (this.mContentView == null || (this.mFlags & 2) != 0) {
            return;
        }
        if ((this.mFlags & 1) == 0) {
            return;
        }
        this.mFlags |= 2;
        this.requestRender();
    }

    private synchronized void layoutContentPane() {
        this.mFlags &= 0xFFFFFFFD;
        int width = this.getWidth();
        int height = this.getHeight();
        Log.v((String)TAG, (String)("layout content pane " + width + "x" + height));
        if (this.mContentView != null && width != 0 && height != 0) {
            this.mContentView.layout(0, 0, width, height);
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        if (changed) {
            this.requestLayoutContentPane();
        }
    }

    public void onSurfaceCreated(GL10 gl1, EGLConfig config) {
        GL11 gl = (GL11)gl1;
        if (this.mGL != null) {
            Log.i((String)TAG, (String)("GLObject has changed from " + this.mGL + " to " + gl));
        }
        this.mGL = gl;
        this.setRenderMode(0);
        gl.glDisable(2896);
        gl.glEnable(3042);
        gl.glEnable(3089);
        gl.glEnable(2960);
        gl.glEnableClientState(32884);
        gl.glEnableClientState(32888);
        gl.glEnable(3553);
        mTexture2DEnabled = true;
        gl.glTexEnvf(8960, 8704, 7681.0f);
        gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        gl.glClearStencil(0);
        gl.glVertexPointer(2, 5126, 0, (Buffer)this.mXyPointer);
        gl.glTexCoordPointer(2, 5126, 0, (Buffer)this.mUvPointer);
    }

    public void onSurfaceChanged(GL10 gl1, int width, int height) {
        GL11 gl;
        Log.v((String)TAG, (String)("onSurfaceChanged: " + width + "x" + height + ", gl10: " + gl1.toString()));
        this.mGL = gl = (GL11)gl1;
        gl.glViewport(0, 0, width, height);
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        GLU.gluOrtho2D((GL10)gl, (float)0.0f, (float)width, (float)0.0f, (float)height);
        Matrix matrix = this.mTransformation.getMatrix();
        matrix.reset();
        matrix.preTranslate(0.0f, (float)this.getHeight());
        matrix.preScale(1.0f, -1.0f);
    }

    private void setAlphaValue(float alpha) {
        if (this.mLastAlpha == alpha) {
            return;
        }
        GL11 gl = this.mGL;
        this.mLastAlpha = alpha;
        if (alpha >= 0.95f) {
            gl.glTexEnvf(8960, 8704, 7681.0f);
        } else {
            gl.glTexEnvf(8960, 8704, 8448.0f);
            gl.glColor4f(alpha, alpha, alpha, alpha);
        }
    }

    public void drawRect(int x, int y, int width, int height) {
        float[] matrix = this.mMatrixValues;
        this.mTransformation.getMatrix().getValues(matrix);
        this.drawRect(x, y, width, height, matrix);
    }

    private static void putRectangle(float x, float y, float width, float height, float[] buffer, ByteBuffer pointer) {
        buffer[0] = x;
        buffer[1] = y;
        buffer[2] = x + width;
        buffer[3] = y;
        buffer[4] = x;
        buffer[5] = y + height;
        buffer[6] = x + width;
        buffer[7] = y + height;
        pointer.asFloatBuffer().put(buffer, 0, 8).position(0);
    }

    private void drawRect(int x, int y, int width, int height, float[] matrix) {
        GL11 gl = this.mGL;
        gl.glPushMatrix();
        gl.glMultMatrixf(GLRootView.toGLMatrix(matrix), 0);
        GLRootView.putRectangle(x, y, width, height, this.mXyBuffer, this.mXyPointer);
        gl.glDrawArrays(5, 0, 4);
        gl.glPopMatrix();
    }

    public void drawNinePatch(NinePatchTexture tex, int x, int y, int width, int height) {
        NinePatchChunk chunk = tex.getNinePatchChunk();
        if (chunk.mDivX.length != 2 || chunk.mDivY.length != 2) {
            throw new RuntimeException("unsupported nine patch");
        }
        if (!tex.bind(this, this.mGL)) {
            throw new RuntimeException("cannot bind" + tex.toString());
        }
        if (width <= 0 || height <= 0) {
            return;
        }
        int[] divX = this.mNinePatchX;
        int[] divY = this.mNinePatchY;
        float[] divU = this.mNinePatchU;
        float[] divV = this.mNinePatchV;
        int nx = this.stretch(divX, divU, chunk.mDivX, tex.getWidth(), width);
        int ny = this.stretch(divY, divV, chunk.mDivY, tex.getHeight(), height);
        this.setAlphaValue(this.mTransformation.getAlpha());
        Matrix matrix = this.mTransformation.getMatrix();
        matrix.getValues(this.mMatrixValues);
        GL11 gl = this.mGL;
        gl.glPushMatrix();
        gl.glMultMatrixf(GLRootView.toGLMatrix(this.mMatrixValues), 0);
        gl.glTranslatef((float)x, (float)y, 0.0f);
        this.drawMesh(divX, divY, divU, divV, nx, ny);
        gl.glPopMatrix();
    }

    private int stretch(int[] x, float[] u, int[] div, int source, int target) {
        int textureSize = Util.nextPowerOf2(source);
        float textureBound = ((float)source - 0.5f) / (float)textureSize;
        int stretch = 0;
        int n = div.length;
        for (int i = 0; i < n; i += 2) {
            stretch += div[i + 1] - div[i];
        }
        float remaining = target - source + stretch;
        int lastX = 0;
        int lastU = 0;
        x[0] = 0;
        u[0] = 0.0f;
        int n2 = div.length;
        for (int i = 0; i < n2; i += 2) {
            x[i + 1] = lastX + (div[i] - lastU);
            u[i + 1] = Math.min((float)div[i] / (float)textureSize, textureBound);
            float partU = div[i + 1] - div[i];
            int partX = (int)(remaining * partU / (float)stretch + 0.5f);
            remaining -= (float)partX;
            stretch = (int)((float)stretch - partU);
            lastX = x[i + 1] + partX;
            lastU = div[i + 1];
            x[i + 2] = lastX;
            u[i + 2] = Math.min((float)lastU / (float)textureSize, textureBound);
        }
        x[div.length + 1] = target;
        u[div.length + 1] = textureBound;
        int last = 0;
        int n3 = div.length + 2;
        for (int i = 1; i < n3; ++i) {
            if (x[last] == x[i]) continue;
            x[++last] = x[i];
            u[last] = u[i];
        }
        return last + 1;
    }

    private void drawMesh(int[] x, int[] y, float[] u, float[] v, int nx, int ny) {
        int pntCount = 0;
        float[] xy = this.mXyBuffer;
        float[] uv = this.mUvBuffer;
        for (int j = 0; j < ny; ++j) {
            for (int i = 0; i < nx; ++i) {
                int xIndex = pntCount++ << 1;
                int yIndex = xIndex + 1;
                xy[xIndex] = x[i];
                xy[yIndex] = y[j];
                uv[xIndex] = u[i];
                uv[yIndex] = v[j];
            }
        }
        this.mUvPointer.asFloatBuffer().put(uv, 0, pntCount << 1).position(0);
        this.mXyPointer.asFloatBuffer().put(xy, 0, pntCount << 1).position(0);
        int idxCount = 1;
        byte[] index = this.mIndexBuffer;
        int i = 0;
        int bound = nx * (ny - 1);
        do {
            --idxCount;
            int j = 0;
            while (j < nx) {
                index[idxCount++] = (byte)i;
                index[idxCount++] = (byte)(i + nx);
                ++j;
                ++i;
            }
            if (i >= bound) break;
            int sum = i + i + nx - 1;
            --idxCount;
            int j2 = 0;
            while (j2 < nx) {
                index[idxCount++] = (byte)(sum - i);
                index[idxCount++] = (byte)(sum - i + nx);
                ++j2;
                ++i;
            }
        } while (i < bound);
        this.mIndexPointer.put(index, 0, idxCount).position(0);
        this.mGL.glDrawElements(5, idxCount, 5121, (Buffer)this.mIndexPointer);
    }

    private float[] mapPoints(Matrix matrix, int x1, int y1, int x2, int y2) {
        float[] point = this.mXyBuffer;
        point[0] = x1;
        point[1] = y1;
        point[2] = x2;
        point[3] = y2;
        matrix.mapPoints(point, 0, point, 0, 4);
        return point;
    }

    public void clipRect(int x, int y, int width, int height) {
        float[] point = this.mapPoints(this.mTransformation.getMatrix(), x, y + height, x + width, y);
        if (point[0] > point[2]) {
            x = (int)point[2];
            width = (int)point[0] - x;
        } else {
            x = (int)point[0];
            width = (int)point[2] - x;
        }
        if (point[1] > point[3]) {
            y = (int)point[3];
            height = (int)point[1] - y;
        } else {
            y = (int)point[1];
            height = (int)point[3] - y;
        }
        this.mGL.glScissor(x, y, width, height);
    }

    public void clearClip() {
        this.mGL.glScissor(0, 0, this.getWidth(), this.getHeight());
    }

    private static float[] toGLMatrix(float[] v) {
        v[15] = v[8];
        v[13] = v[5];
        v[5] = v[4];
        v[4] = v[1];
        v[12] = v[2];
        v[1] = v[3];
        v[3] = v[6];
        v[9] = 0.0f;
        v[8] = 0.0f;
        v[6] = 0.0f;
        v[2] = 0.0f;
        v[10] = 1.0f;
        return v;
    }

    public void drawColor(int x, int y, int width, int height, int color2) {
        float alpha = this.mTransformation.getAlpha();
        GL11 gl = this.mGL;
        if (mTexture2DEnabled) {
            this.mLastAlpha = -1.0f;
            gl.glDisable(3553);
            mTexture2DEnabled = false;
        }
        gl.glColor4f((float)Color.red((int)color2) * (alpha /= 256.0f), (float)Color.green((int)color2) * alpha, (float)Color.blue((int)color2) * alpha, (float)Color.alpha((int)color2) * alpha);
        this.drawRect(x, y, width, height);
    }

    public void drawTexture(BasicTexture texture, int x, int y, int width, int height) {
        this.drawTexture(texture, x, y, width, height, this.mTransformation.getAlpha());
    }

    public void drawTexture(BasicTexture texture, int x, int y, int width, int height, float alpha) {
        if (!mTexture2DEnabled) {
            this.mGL.glEnable(3553);
            mTexture2DEnabled = true;
        }
        if (!texture.bind(this, this.mGL)) {
            throw new RuntimeException("cannot bind" + texture.toString());
        }
        if (width <= 0 || height <= 0) {
            return;
        }
        Matrix matrix = this.mTransformation.getMatrix();
        matrix.getValues(this.mMatrixValues);
        if (GLRootView.isMatrixRotatedOrFlipped(this.mMatrixValues)) {
            GLRootView.putRectangle(0.0f, 0.0f, ((float)texture.mWidth - 0.5f) / (float)texture.mTextureWidth, ((float)texture.mHeight - 0.5f) / (float)texture.mTextureHeight, this.mUvBuffer, this.mUvPointer);
            this.setAlphaValue(alpha);
            this.drawRect(x, y, width, height, this.mMatrixValues);
        } else {
            float[] points = this.mapPoints(matrix, x, y + height, x + width, y);
            x = (int)points[0];
            y = (int)points[1];
            width = (int)points[2] - x;
            height = (int)points[3] - y;
            if (width > 0 && height > 0) {
                this.setAlphaValue(alpha);
                ((GL11Ext)this.mGL).glDrawTexiOES(x, y, 0, width, height);
            }
        }
    }

    private static boolean isMatrixRotatedOrFlipped(float[] matrix) {
        return matrix[1] != 0.0f || matrix[3] != 0.0f || matrix[0] < 0.0f || matrix[4] > 0.0f;
    }

    public synchronized void onDrawFrame(GL10 gl) {
        if ((this.mFlags & 2) != 0) {
            this.layoutContentPane();
        }
        this.clearClip();
        gl.glClear(17408);
        gl.glEnable(3042);
        gl.glBlendFunc(1, 771);
        this.mAnimationTime = SystemClock.uptimeMillis();
        if (this.mContentView != null) {
            this.mContentView.render(this, (GL11)gl);
        }
        long now = SystemClock.uptimeMillis();
        for (Animation animation : this.mAnimations) {
            animation.setStartTime(now);
        }
        this.mAnimations.clear();
    }

    public synchronized boolean dispatchTouchEvent(MotionEvent event) {
        return this.mContentView != null ? this.mContentView.dispatchTouchEvent(event) : false;
    }

    public DisplayMetrics getDisplayMetrics() {
        if (this.mDisplayMetrics == null) {
            this.mDisplayMetrics = new DisplayMetrics();
            ((Activity)this.getContext()).getWindowManager().getDefaultDisplay().getMetrics(this.mDisplayMetrics);
        }
        return this.mDisplayMetrics;
    }

    public void copyTexture2D(RawTexture texture, int x, int y, int width, int height) throws GLOutOfMemoryException {
        Matrix matrix = this.mTransformation.getMatrix();
        matrix.getValues(this.mMatrixValues);
        if (GLRootView.isMatrixRotatedOrFlipped(this.mMatrixValues)) {
            throw new IllegalArgumentException("cannot support rotated matrix");
        }
        float[] points = this.mapPoints(matrix, x, y + height, x + width, y);
        x = (int)points[0];
        y = (int)points[1];
        width = (int)points[2] - x;
        height = (int)points[3] - y;
        GL11 gl = this.mGL;
        int newWidth = Util.nextPowerOf2(width);
        int newHeight = Util.nextPowerOf2(height);
        int glError = 0;
        gl.glBindTexture(3553, texture.getId());
        int[] cropRect = new int[]{0, 0, width, height};
        gl.glTexParameteriv(3553, 35741, cropRect, 0);
        gl.glTexParameteri(3553, 10242, 33071);
        gl.glTexParameteri(3553, 10243, 33071);
        gl.glTexParameterf(3553, 10241, 9729.0f);
        gl.glTexParameterf(3553, 10240, 9729.0f);
        gl.glCopyTexImage2D(3553, 0, 6408, x, y, newWidth, newHeight, 0);
        glError = gl.glGetError();
        if (glError == 1285) {
            throw new GLOutOfMemoryException();
        }
        if (glError != 0) {
            throw new RuntimeException("Texture copy fail, glError " + glError);
        }
        texture.setSize(width, height);
        texture.setTextureSize(newWidth, newHeight);
    }

    static {
        sPixelDensity = -1.0f;
    }
}

