/*
 * Decompiled with CFR 0.152.
 */
package com.android.camera.ui;

import android.content.Context;
import android.graphics.Rect;
import android.view.animation.Transformation;
import com.android.camera.ui.GLRootView;
import com.android.camera.ui.GLView;
import com.android.camera.ui.MeasureHelper;
import com.android.camera.ui.ResourceTexture;
import com.android.camera.ui.StringTexture;
import javax.microedition.khronos.opengles.GL11;

class GLOptionItem
extends GLView {
    private static final int FONT_COLOR = -1;
    private static final float FONT_SIZE = 18.0f;
    private static final int MINIMAL_WIDTH = 120;
    private static final int MINIMAL_HEIGHT = 32;
    private static final int NO_ICON_LEADING_SPACE = 10;
    private static final int TEXT_LEFT_PADDING = 6;
    private static final int TEXT_RIGHT_PADDING = 10;
    private static final float ENABLED_ALPHA = 1.0f;
    private static final float DISABLED_ALPHA = 0.3f;
    private static final int HORIZONTAL_PADDINGS = 4;
    private static final int VERTICAL_PADDINGS = 2;
    private static ResourceTexture sCheckOn;
    private static ResourceTexture sCheckOff;
    private static int sNoIconLeadingSpace;
    private static int sTextLeftPadding;
    private static int sTextRightPadding;
    private static int sMinimalWidth;
    private static int sMinimalHeight;
    private static float sFontSize;
    private static int sHorizontalPaddings;
    private static int sVerticalPaddings;
    private final ResourceTexture mIcon;
    private final StringTexture mText;
    private boolean mEnabled = true;
    private ResourceTexture mCheckBox;

    private static void initializeStaticVariables(Context context) {
        if (sCheckOn != null) {
            return;
        }
        sCheckOn = new ResourceTexture(context, 2130837546);
        sCheckOff = new ResourceTexture(context, 2130837545);
        sNoIconLeadingSpace = GLRootView.dpToPixel(context, 10);
        sTextLeftPadding = GLRootView.dpToPixel(context, 6);
        sTextRightPadding = GLRootView.dpToPixel(context, 10);
        sMinimalWidth = GLRootView.dpToPixel(context, 120);
        sMinimalHeight = GLRootView.dpToPixel(context, 32);
        sHorizontalPaddings = GLRootView.dpToPixel(context, 4);
        sVerticalPaddings = GLRootView.dpToPixel(context, 2);
        sFontSize = GLRootView.dpToPixel(context, 18.0f);
    }

    public GLOptionItem(Context context, int iconId, String title) {
        GLOptionItem.initializeStaticVariables(context);
        this.mIcon = iconId == 0 ? null : new ResourceTexture(context, iconId);
        this.mText = StringTexture.newInstance(title, sFontSize, -1);
        this.mCheckBox = sCheckOff;
        this.setPaddings(sHorizontalPaddings, sVerticalPaddings, sHorizontalPaddings, sVerticalPaddings);
    }

    protected void onMeasure(int widthSpec, int heightSpec) {
        int width = this.mIcon == null ? sNoIconLeadingSpace : this.mIcon.getWidth();
        width += this.mText.getWidth() + this.mCheckBox.getWidth();
        width += sTextRightPadding + sTextLeftPadding;
        int height = Math.max(Math.max(this.mIcon == null ? 0 : this.mIcon.getHeight(), this.mText.getHeight()), this.mCheckBox.getHeight());
        width = Math.max(sMinimalWidth, width);
        height = Math.max(sMinimalHeight, height);
        new MeasureHelper(this).setPreferredContentSize(width, height).measure(widthSpec, heightSpec);
    }

    protected void render(GLRootView root, GL11 gl) {
        Rect p = this.mPaddings;
        int width = this.getWidth() - p.left - p.right;
        int height = this.getHeight() - p.top - p.bottom;
        int xoffset = p.left;
        Transformation trans = root.getTransformation();
        float oldAlpha = trans.getAlpha();
        trans.setAlpha(oldAlpha * (this.mEnabled ? 1.0f : 0.3f));
        ResourceTexture icon = this.mIcon;
        if (icon != null) {
            icon.draw(root, xoffset, p.top + (height - icon.getHeight()) / 2);
            xoffset += icon.getWidth();
        } else {
            xoffset += sNoIconLeadingSpace;
        }
        StringTexture title = this.mText;
        int yoffset = p.top + (height - title.getHeight()) / 2;
        title.draw(root, xoffset += sTextLeftPadding, yoffset);
        ResourceTexture checkbox = this.mCheckBox;
        yoffset = p.top + (height - checkbox.getHeight()) / 2;
        checkbox.draw(root, width - checkbox.getWidth(), yoffset);
        trans.setAlpha(oldAlpha);
    }

    public void setChecked(boolean checked) {
        this.mCheckBox = checked ? sCheckOn : sCheckOff;
        this.invalidate();
    }

    public void setEnabled(boolean enabled) {
        if (this.mEnabled == enabled) {
            return;
        }
        this.mEnabled = enabled;
        this.invalidate();
    }

    static {
        sHorizontalPaddings = -1;
    }
}

