/*
 * Decompiled with CFR 0.152.
 */
package com.android.camera.ui;

import android.content.Context;
import android.graphics.Rect;
import com.android.camera.ui.ColorTexture;
import com.android.camera.ui.GLRootView;
import com.android.camera.ui.GLView;
import com.android.camera.ui.MeasureHelper;
import com.android.camera.ui.StringTexture;
import com.android.camera.ui.Texture;
import javax.microedition.khronos.opengles.GL11;

class GLOptionHeader
extends GLView {
    private static final int FONT_COLOR = -6842473;
    private static final float FONT_SIZE = 12.0f;
    private static final int HORIZONTAL_PADDINGS = 4;
    private static final int VERTICAL_PADDINGS = 2;
    private static final int COLOR_OPTION_HEADER = -13948117;
    private static int sHorizontalPaddings = -1;
    private static int sVerticalPaddings;
    private final StringTexture mTitle;
    private Texture mBackground;

    private static void initializeStaticVariables(Context context) {
        if (sHorizontalPaddings >= 0) {
            return;
        }
        sHorizontalPaddings = GLRootView.dpToPixel(context, 4);
        sVerticalPaddings = GLRootView.dpToPixel(context, 2);
    }

    public GLOptionHeader(Context context, String title) {
        GLOptionHeader.initializeStaticVariables(context);
        float fontSize = GLRootView.dpToPixel(context, 12.0f);
        this.mTitle = StringTexture.newInstance(title, fontSize, -6842473);
        this.setBackground(new ColorTexture(-13948117));
        this.setPaddings(sHorizontalPaddings, sVerticalPaddings, sHorizontalPaddings, sVerticalPaddings);
    }

    public void setBackground(Texture background) {
        if (this.mBackground == background) {
            return;
        }
        this.mBackground = background;
        this.invalidate();
    }

    protected void onMeasure(int widthSpec, int heightSpec) {
        new MeasureHelper(this).setPreferredContentSize(this.mTitle.getWidth(), this.mTitle.getHeight()).measure(widthSpec, heightSpec);
    }

    protected void render(GLRootView root, GL11 gl) {
        if (this.mBackground != null) {
            this.mBackground.draw(root, 0, 0, this.getWidth(), this.getHeight());
        }
        Rect p = this.mPaddings;
        this.mTitle.draw(root, p.left, p.top);
    }
}

