/*
 * Decompiled with CFR 0.152.
 */
package com.android.camera.ui;

import android.content.Context;
import android.graphics.Rect;
import android.os.Handler;
import android.os.Message;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.Transformation;
import android.widget.Scroller;
import com.android.camera.Util;
import com.android.camera.ui.GLRootView;
import com.android.camera.ui.GLView;
import com.android.camera.ui.MeasureHelper;
import com.android.camera.ui.NinePatchTexture;
import com.android.camera.ui.Texture;
import javax.microedition.khronos.opengles.GL11;

class GLListView
extends GLView {
    private static final String TAG = "GLListView";
    private static final int INDEX_NONE = -1;
    private static final int SCROLL_BAR_TIMEOUT = 2500;
    private static final int HIDE_SCROLL_BAR = 1;
    private Model mModel;
    private Handler mHandler;
    private int mHighlightIndex = -1;
    private GLView mHighlightView;
    private Texture mHighLight;
    private NinePatchTexture mScrollbar;
    private int mVisibleStart = 0;
    private int mVisibleEnd = 0;
    private boolean mHasMeasured = false;
    private boolean mScrollBarVisible = false;
    private Animation mScrollBarAnimation;
    private OnItemSelectedListener mOnItemSelectedListener;
    private GestureDetector mGestureDetector;
    private final Scroller mScroller;
    private boolean mScrollable;
    private boolean mIsPressed = false;

    public GLListView(Context context) {
        this.mScroller = new Scroller(context);
        this.mHandler = new Handler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleMessage(Message msg) {
                GLRootView root = GLListView.this.getGLRootView();
                if (root != null) {
                    GLRootView gLRootView = root;
                    synchronized (gLRootView) {
                        this.handleMessageLocked(msg);
                    }
                } else {
                    this.handleMessageLocked(msg);
                }
            }

            private void handleMessageLocked(Message msg) {
                switch (msg.what) {
                    case 1: {
                        GLListView.this.setScrollBarVisible(false);
                    }
                }
            }
        };
        this.mGestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)new MyGestureListener(), this.mHandler);
    }

    protected void onVisibilityChanged(int visibility) {
        super.onVisibilityChanged(visibility);
        if (visibility == 0 && this.mScrollHeight > this.getHeight()) {
            this.setScrollBarVisible(true);
            this.mHandler.sendEmptyMessageDelayed(1, 2500L);
        }
    }

    private void setScrollBarVisible(boolean visible) {
        if (this.mScrollBarVisible == visible || this.mScrollbar == null) {
            return;
        }
        this.mScrollBarVisible = visible;
        if (!visible) {
            this.mScrollBarAnimation = new AlphaAnimation(1.0f, 0.0f);
            this.mScrollBarAnimation.setDuration(300L);
            this.mScrollBarAnimation.start();
        } else {
            this.mScrollBarAnimation = null;
        }
        this.invalidate();
    }

    public void setHighLight(Texture highLight) {
        this.mHighLight = highLight;
    }

    public void setDataModel(Model model) {
        this.mModel = model;
        this.mScrollY = 0;
        this.requestLayout();
    }

    public void setOnItemSelectedListener(OnItemSelectedListener l) {
        this.mOnItemSelectedListener = l;
    }

    private boolean drawWithAnimation(GLRootView root, Texture texture, int x, int y, int w, int h, Animation anim2) {
        long now = root.currentAnimationTimeMillis();
        Transformation temp = root.obtainTransformation();
        boolean more = anim2.getTransformation(now, temp);
        Transformation transformation = root.pushTransform();
        transformation.compose(temp);
        texture.draw(root, x, y, w, h);
        this.invalidate();
        root.popTransform();
        return more;
    }

    protected void render(GLRootView root, GL11 gl) {
        root.clipRect(0, 0, this.getWidth(), this.getHeight());
        if (this.mHighlightIndex != -1) {
            GLView view = this.mModel.getView(this.mHighlightIndex);
            Rect bounds = view.bounds();
            if (this.mHighLight != null) {
                int width = bounds.width();
                int height = bounds.height();
                this.mHighLight.draw(root, bounds.left - this.mScrollX, bounds.top - this.mScrollY, width, height);
            }
        }
        super.render(root, gl);
        root.clearClip();
        if (this.mScrollBarAnimation != null || this.mScrollBarVisible) {
            int width = this.mScrollbar.getWidth();
            int height = this.getHeight() * this.getHeight() / this.mScrollHeight;
            int yoffset = this.mScrollY * this.getHeight() / this.mScrollHeight;
            if (this.mScrollBarAnimation != null) {
                if (!this.drawWithAnimation(root, this.mScrollbar, this.getWidth() - width, yoffset, width, height, this.mScrollBarAnimation)) {
                    this.mScrollBarAnimation = null;
                }
            } else {
                this.mScrollbar.draw(root, this.getWidth() - width, yoffset, width, height);
            }
        }
        if (this.mScroller.computeScrollOffset()) {
            this.setScrollPosition(this.mScroller.getCurrY(), false);
        }
    }

    protected void onMeasure(int widthSpec, int heightSpec) {
        int height = 0;
        int maxWidth = 0;
        int n = this.mModel.size();
        for (int i = 0; i < n; ++i) {
            GLView view = this.mModel.getView(i);
            view.measure(widthSpec, 0);
            height += view.getMeasuredHeight();
            maxWidth = Math.max(maxWidth, view.getMeasuredWidth());
        }
        this.mScrollHeight = height;
        this.mHasMeasured = true;
        new MeasureHelper(this).setPreferredContentSize(maxWidth, height).measure(widthSpec, heightSpec);
    }

    public int getComponentCount() {
        return this.mVisibleEnd - this.mVisibleStart;
    }

    public GLView getComponent(int index) {
        if (index < 0 || index >= this.mVisibleEnd - this.mVisibleStart) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return this.mModel.getView(this.mVisibleStart + index);
    }

    public void requestLayout() {
        this.mHasMeasured = false;
        super.requestLayout();
    }

    protected void onLayout(boolean change, int left, int top, int right, int bottom) {
        if (!this.mHasMeasured || this.mMeasuredWidth != right - left) {
            this.measure(View.MeasureSpec.makeMeasureSpec((int)(right - left), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)(bottom - top), (int)0x40000000));
        }
        this.mScrollable = this.mScrollHeight > bottom - top;
        int width = right - left;
        int yoffset = 0;
        int n = this.mModel.size();
        for (int i = 0; i < n; ++i) {
            GLView item = this.mModel.getView(i);
            item.onAddToParent(this);
            int nextOffset = yoffset + item.getMeasuredHeight();
            item.layout(0, yoffset, width, nextOffset);
            yoffset = nextOffset;
        }
        this.setScrollPosition(this.mScrollY, true);
    }

    private void setScrollPosition(int position, boolean force) {
        int height = this.getHeight();
        position = Util.clamp(position, 0, this.mScrollHeight - height);
        if (!force && position == this.mScrollY) {
            return;
        }
        this.mScrollY = position;
        int n = this.mModel.size();
        int start = 0;
        int end = 0;
        for (start = 0; start < n && position >= this.mModel.getView((int)start).mBounds.bottom; ++start) {
        }
        int bottom = position + height;
        for (end = start; end < n && bottom > this.mModel.getView((int)end).mBounds.top; ++end) {
        }
        this.setVisibleRange(start, end);
        this.invalidate();
    }

    private void setVisibleRange(int start, int end) {
        if (start == this.mVisibleStart && end == this.mVisibleEnd) {
            return;
        }
        this.mVisibleStart = start;
        this.mVisibleEnd = end;
    }

    protected boolean dispatchTouchEvent(MotionEvent event) {
        return this.onTouch(event);
    }

    protected boolean onTouch(MotionEvent event) {
        this.mGestureDetector.onTouchEvent(event);
        switch (event.getAction()) {
            case 0: {
                this.mIsPressed = true;
                this.mHandler.removeMessages(1);
                this.setScrollBarVisible(this.mScrollHeight > this.getHeight());
            }
            case 2: {
                if (this.mScrollable) break;
                this.findAndSetHighlightItem((int)event.getY());
                break;
            }
            case 1: {
                this.mIsPressed = false;
                if (this.mScrollBarVisible) {
                    this.mHandler.removeMessages(1);
                    this.mHandler.sendEmptyMessageDelayed(1, 2500L);
                }
                if (!this.mScrollable && this.mOnItemSelectedListener != null && this.mHighlightView != null) {
                    this.mOnItemSelectedListener.onItemSelected(this.mHighlightView, this.mHighlightIndex);
                }
            }
            case 3: 
            case 4: {
                this.setHighlightItem(null, -1);
            }
        }
        return true;
    }

    private void findAndSetHighlightItem(int y) {
        int position = y + this.mScrollY;
        int n = this.mVisibleEnd;
        for (int i = this.mVisibleStart; i < n; ++i) {
            GLView child = this.mModel.getView(i);
            if (child.mBounds.bottom <= position) continue;
            if (!this.mModel.isSelectable(i)) break;
            this.setHighlightItem(child, i);
            return;
        }
        this.setHighlightItem(null, -1);
    }

    private void setHighlightItem(GLView view, int index) {
        if (index == this.mHighlightIndex) {
            return;
        }
        this.mHighlightIndex = index;
        this.mHighlightView = view;
        if (this.mHighLight != null) {
            this.invalidate();
        }
    }

    public void setScroller(NinePatchTexture scrollbar) {
        this.mScrollbar = scrollbar;
        this.requestLayout();
    }

    private class MyGestureListener
    extends GestureDetector.SimpleOnGestureListener {
        private MyGestureListener() {
        }

        public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
            if (!GLListView.this.mScrollable) {
                return false;
            }
            GLListView.this.mScroller.fling(0, GLListView.this.mScrollY, 0, -((int)velocityY), 0, 0, 0, GLListView.this.mScrollHeight - GLListView.this.getHeight());
            GLListView.this.invalidate();
            return true;
        }

        public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
            if (!GLListView.this.mScrollable) {
                return false;
            }
            GLListView.this.setHighlightItem(null, -1);
            GLListView.this.setScrollPosition(GLListView.this.mScrollY + (int)distanceY, false);
            return true;
        }

        public void onShowPress(MotionEvent e) {
            if (!GLListView.this.mScrollable || !GLListView.this.mIsPressed) {
                return;
            }
            GLListView.this.findAndSetHighlightItem((int)e.getY());
        }

        public boolean onSingleTapUp(MotionEvent e) {
            if (!GLListView.this.mScrollable) {
                return false;
            }
            GLListView.this.findAndSetHighlightItem((int)e.getY());
            if (GLListView.this.mOnItemSelectedListener != null && GLListView.this.mHighlightView != null) {
                GLListView.this.mOnItemSelectedListener.onItemSelected(GLListView.this.mHighlightView, GLListView.this.mHighlightIndex);
            }
            GLListView.this.setHighlightItem(null, -1);
            return true;
        }
    }

    public static interface OnItemSelectedListener {
        public void onItemSelected(GLView var1, int var2);
    }

    public static interface Model {
        public int size();

        public GLView getView(int var1);

        public boolean isSelectable(int var1);
    }
}

