/*
 * Decompiled with CFR 0.152.
 */
package com.android.camera.ui;

import android.graphics.Bitmap;
import android.opengl.GLUtils;
import com.android.camera.Util;
import com.android.camera.ui.BasicTexture;
import com.android.camera.ui.GLOutOfMemoryException;
import com.android.camera.ui.GLRootView;
import javax.microedition.khronos.opengles.GL11;

abstract class BitmapTexture
extends BasicTexture {
    private static final String TAG = "Texture";

    protected BitmapTexture() {
        super(null, 0, 0);
    }

    public int getWidth() {
        if (this.mWidth == -1) {
            this.getBitmap();
        }
        return this.mWidth;
    }

    public int getHeight() {
        if (this.mWidth == -1) {
            this.getBitmap();
        }
        return this.mHeight;
    }

    protected abstract Bitmap getBitmap();

    protected abstract void freeBitmap(Bitmap var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uploadToGL(GL11 gl) throws GLOutOfMemoryException {
        int[] textureId;
        Bitmap bitmap = this.getBitmap();
        int glError = 0;
        if (bitmap != null) {
            textureId = new int[1];
            try {
                int width = bitmap.getWidth();
                int height = bitmap.getHeight();
                int[] cropRect = new int[]{0, height, width, -height};
                gl.glGenTextures(1, textureId, 0);
                gl.glBindTexture(3553, textureId[0]);
                gl.glTexParameteriv(3553, 35741, cropRect, 0);
                gl.glTexParameteri(3553, 10242, 33071);
                gl.glTexParameteri(3553, 10243, 33071);
                gl.glTexParameterf(3553, 10241, 9729.0f);
                gl.glTexParameterf(3553, 10240, 9729.0f);
                int widthExt = Util.nextPowerOf2(width);
                int heightExt = Util.nextPowerOf2(height);
                int format = GLUtils.getInternalFormat((Bitmap)bitmap);
                int type = GLUtils.getType((Bitmap)bitmap);
                this.mTextureWidth = widthExt;
                this.mTextureHeight = heightExt;
                gl.glTexImage2D(3553, 0, format, widthExt, heightExt, 0, format, type, null);
                GLUtils.texSubImage2D((int)3553, (int)0, (int)0, (int)0, (Bitmap)bitmap, (int)format, (int)type);
            }
            finally {
                this.freeBitmap(bitmap);
            }
            if (glError == 1285) {
                throw new GLOutOfMemoryException();
            }
            if (glError != 0) {
                this.mId = 0;
                this.mState = 0;
                throw new RuntimeException("Texture upload fail, glError " + glError);
            }
        } else {
            this.mState = -1;
            throw new RuntimeException("Texture load fail, no bitmap");
        }
        this.mGL = gl;
        this.mId = textureId[0];
        this.mState = 1;
    }

    protected boolean bind(GLRootView root, GL11 gl) {
        if (this.mState == 0 || this.mGL != gl) {
            this.mState = 0;
            try {
                this.uploadToGL(gl);
            }
            catch (GLOutOfMemoryException e) {
                root.handleLowMemory();
                return false;
            }
        } else {
            gl.glBindTexture(3553, this.getId());
        }
        return true;
    }
}

