/*
 * Decompiled with CFR 0.152.
 */
package com.android.camera.ui;

import android.content.Context;
import com.android.camera.IconListPreference;
import com.android.camera.Util;
import com.android.camera.ui.AbstractIndicator;
import com.android.camera.ui.ColorTexture;
import com.android.camera.ui.GLListView;
import com.android.camera.ui.GLView;
import com.android.camera.ui.NinePatchTexture;
import com.android.camera.ui.PreferenceAdapter;
import com.android.camera.ui.ResourceTexture;

class BasicIndicator
extends AbstractIndicator {
    private static final int COLOR_OPTION_ITEM_HIGHLIGHT = -15198184;
    private final ResourceTexture[] mIcon;
    private final IconListPreference mPreference;
    protected int mIndex;
    private GLListView mPopupContent;
    private PreferenceAdapter mModel;
    private String mOverride;

    public BasicIndicator(Context context, IconListPreference preference) {
        super(context);
        this.mPreference = preference;
        this.mIcon = new ResourceTexture[preference.getLargeIconIds().length];
        this.mIndex = preference.findIndexOfValue(preference.getValue());
    }

    private void updateContent(String override, boolean reloadValue) {
        if (!reloadValue && Util.equals(this.mOverride, override)) {
            return;
        }
        IconListPreference pref = this.mPreference;
        this.mOverride = override;
        int index = pref.findIndexOfValue(override == null ? pref.getValue() : override);
        if (this.mIndex != index) {
            this.mIndex = index;
            this.invalidate();
        }
    }

    public void overrideSettings(String key, String settings) {
        IconListPreference pref = this.mPreference;
        if (!pref.getKey().equals(key)) {
            return;
        }
        this.updateContent(settings, false);
    }

    public void reloadPreferences() {
        if (this.mModel != null) {
            this.mModel.reload();
        }
        this.updateContent(null, true);
    }

    public GLView getPopupContent() {
        if (this.mPopupContent == null) {
            Context context = this.getGLRootView().getContext();
            this.mPopupContent = new GLListView(context);
            this.mPopupContent.setHighLight(new ColorTexture(-15198184));
            this.mPopupContent.setScroller(new NinePatchTexture(context, 2130837575));
            this.mModel = new PreferenceAdapter(context, this.mPreference);
            this.mPopupContent.setOnItemSelectedListener(new MyListener(this.mModel));
            this.mPopupContent.setDataModel(this.mModel);
        }
        this.mModel.overrideSettings(this.mOverride);
        return this.mPopupContent;
    }

    protected void onPreferenceChanged(int newIndex) {
        if (newIndex == this.mIndex) {
            return;
        }
        this.mIndex = newIndex;
        this.invalidate();
    }

    protected ResourceTexture getIcon() {
        int index = this.mIndex;
        if (this.mIcon[index] == null) {
            Context context = this.getGLRootView().getContext();
            this.mIcon[index] = new ResourceTexture(context, this.mPreference.getLargeIconIds()[index]);
        }
        return this.mIcon[index];
    }

    private class MyListener
    implements GLListView.OnItemSelectedListener {
        private final PreferenceAdapter mAdapter;

        public MyListener(PreferenceAdapter adapter) {
            this.mAdapter = adapter;
        }

        public void onItemSelected(GLView view, int position) {
            this.mAdapter.onItemSelected(view, position);
            BasicIndicator.this.onPreferenceChanged(position - 1);
        }
    }
}

