/*
 * Decompiled with CFR 0.152.
 */
package com.android.camera.ui;

import android.content.Context;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.Transformation;
import com.android.camera.ui.BitmapTexture;
import com.android.camera.ui.GLRootView;
import com.android.camera.ui.GLView;
import com.android.camera.ui.MeasureHelper;
import javax.microedition.khronos.opengles.GL11;

abstract class AbstractIndicator
extends GLView {
    private static final int DEFAULT_PADDING = 3;
    private int mOrientation = 0;

    protected abstract BitmapTexture getIcon();

    public AbstractIndicator(Context context) {
        int padding = GLRootView.dpToPixel(context, 3);
        this.setPaddings(padding, 0, padding, 0);
    }

    protected void onMeasure(int widthSpec, int heightSpec) {
        BitmapTexture icon = this.getIcon();
        new MeasureHelper(this).setPreferredContentSize(icon.getWidth(), icon.getHeight()).measure(widthSpec, heightSpec);
    }

    protected void render(GLRootView root, GL11 gl) {
        BitmapTexture icon = this.getIcon();
        if (icon != null) {
            Rect p = this.mPaddings;
            int width = this.getWidth() - p.left - p.right;
            int height = this.getHeight() - p.top - p.bottom;
            if (this.mOrientation != 0) {
                Transformation trans = root.pushTransform();
                Matrix matrix = trans.getMatrix();
                matrix.preTranslate((float)(p.left + width / 2), (float)(p.top + height / 2));
                matrix.preRotate((float)(-this.mOrientation));
                icon.draw(root, -icon.getWidth() / 2, -icon.getHeight() / 2);
                root.popTransform();
            } else {
                icon.draw(root, p.left + (width - icon.getWidth()) / 2, p.top + (height - icon.getHeight()) / 2);
            }
        }
    }

    public void setOrientation(int orientation) {
        if (orientation % 90 != 0) {
            throw new IllegalArgumentException();
        }
        if ((orientation %= 360) < 0) {
            orientation += 360;
        }
        if (this.mOrientation == orientation) {
            return;
        }
        this.mOrientation = orientation;
        if (this.getGLRootView() != null) {
            AlphaAnimation anim2 = new AlphaAnimation(0.2f, 1.0f);
            anim2.setDuration(200L);
            this.startAnimation((Animation)anim2);
        }
    }

    public abstract GLView getPopupContent();

    public abstract void overrideSettings(String var1, String var2);

    public abstract void reloadPreferences();
}

