/*
 * Decompiled with CFR 0.152.
 */
package com.android.camera.gallery;

import android.content.ContentResolver;
import android.database.Cursor;
import android.net.Uri;
import android.provider.MediaStore;
import com.android.camera.gallery.BaseImage;
import com.android.camera.gallery.BaseImageList;
import com.android.camera.gallery.IImageList;
import com.android.camera.gallery.Image;

public class ImageList
extends BaseImageList
implements IImageList {
    private static final String TAG = "ImageList";
    private static final String[] ACCEPTABLE_IMAGE_TYPES = new String[]{"image/jpeg", "image/png", "image/gif"};
    private static final String WHERE_CLAUSE = "(mime_type in (?, ?, ?))";
    private static final String WHERE_CLAUSE_WITH_BUCKET_ID = "(mime_type in (?, ?, ?)) AND bucket_id = ?";
    static final String[] IMAGE_PROJECTION = new String[]{"_id", "datetaken", "mini_thumb_magic", "orientation", "date_modified"};
    private static final int INDEX_ID = 0;
    private static final int INDEX_DATE_TAKEN = 1;
    private static final int INDEX_MINI_THUMB_MAGIC = 2;
    private static final int INDEX_ORIENTATION = 3;
    private static final int INDEX_DATE_MODIFIED = 4;

    public ImageList(ContentResolver resolver, Uri imageUri, int sort, String bucketId) {
        super(resolver, imageUri, sort, bucketId);
    }

    protected String whereClause() {
        return this.mBucketId == null ? WHERE_CLAUSE : WHERE_CLAUSE_WITH_BUCKET_ID;
    }

    protected String[] whereClauseArgs() {
        if (this.mBucketId != null) {
            int count = ACCEPTABLE_IMAGE_TYPES.length;
            String[] result = new String[count + 1];
            System.arraycopy(ACCEPTABLE_IMAGE_TYPES, 0, result, 0, count);
            result[count] = this.mBucketId;
            return result;
        }
        return ACCEPTABLE_IMAGE_TYPES;
    }

    protected Cursor createCursor() {
        Cursor c = MediaStore.Images.Media.query((ContentResolver)this.mContentResolver, (Uri)this.mBaseUri, (String[])IMAGE_PROJECTION, (String)this.whereClause(), (String[])this.whereClauseArgs(), (String)this.sortOrder());
        return c;
    }

    protected BaseImage loadImageFromCursor(Cursor cursor) {
        long id2 = cursor.getLong(0);
        long dateTaken = cursor.getLong(1);
        if (dateTaken == 0L) {
            dateTaken = cursor.getLong(4) * 1000L;
        }
        long miniThumbMagic = cursor.getLong(2);
        int orientation = cursor.getInt(3);
        return new Image(this.mContentResolver, id2, this.contentUri(id2), miniThumbMagic, dateTaken, orientation);
    }
}

