/*
 * Decompiled with CFR 0.152.
 */
package com.android.camera.gallery;

import android.content.ContentResolver;
import android.graphics.Bitmap;
import android.net.Uri;
import android.util.Log;
import com.android.camera.BitmapManager;
import com.android.camera.Util;
import com.android.camera.gallery.IImage;
import com.android.camera.gallery.Image;

public abstract class BaseImage
implements IImage {
    private static final String TAG = "BaseImage";
    protected ContentResolver mContentResolver;
    protected Uri mUri;
    protected long mId;
    private final long mDateTaken;

    protected BaseImage(ContentResolver cr, long id2, Uri uri, long miniThumbMagic, long dateTaken) {
        this.mContentResolver = cr;
        this.mId = id2;
        this.mUri = uri;
        this.mDateTaken = dateTaken;
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof Image)) {
            return false;
        }
        return this.mUri.equals((Object)((Image)other).mUri);
    }

    public int hashCode() {
        return this.mUri.hashCode();
    }

    public Uri fullSizeImageUri() {
        return this.mUri;
    }

    public long getDateTaken() {
        return this.mDateTaken;
    }

    public int getDegreesRotated() {
        return 0;
    }

    public Bitmap miniThumbBitmap() {
        Bitmap b = null;
        try {
            long id2 = this.mId;
            b = BitmapManager.instance().getThumbnail(this.mContentResolver, id2, 3, null, false);
        }
        catch (Throwable ex) {
            Log.e((String)TAG, (String)"miniThumbBitmap got exception", (Throwable)ex);
            return null;
        }
        if (b != null) {
            b = Util.rotate(b, this.getDegreesRotated());
        }
        return b;
    }

    public String toString() {
        return this.mUri.toString();
    }
}

