/*
 * Decompiled with CFR 0.152.
 */
package com.android.camera;

import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.hardware.Camera;
import android.media.CamcorderProfile;
import android.media.MediaRecorder;
import android.media.ThumbnailUtils;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.os.Message;
import android.os.ParcelFileDescriptor;
import android.os.StatFs;
import android.os.SystemClock;
import android.provider.Settings;
import android.util.Log;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.OrientationEventListener;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;
import com.android.camera.CameraHardwareException;
import com.android.camera.CameraHolder;
import com.android.camera.CameraSettings;
import com.android.camera.ComboPreferences;
import com.android.camera.ImageManager;
import com.android.camera.MenuHelper;
import com.android.camera.NoSearchActivity;
import com.android.camera.OnScreenHint;
import com.android.camera.PreferenceGroup;
import com.android.camera.PreviewFrameLayout;
import com.android.camera.RotateImageView;
import com.android.camera.ShutterButton;
import com.android.camera.Switcher;
import com.android.camera.ThumbnailController;
import com.android.camera.Util;
import com.android.camera.gallery.IImage;
import com.android.camera.gallery.IImageList;
import com.android.camera.ui.CamcorderHeadUpDisplay;
import com.android.camera.ui.GLRootView;
import com.android.camera.ui.HeadUpDisplay;
import com.android.camera.ui.RotateRecordingTime;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VideoCamera
extends NoSearchActivity
implements View.OnClickListener,
ShutterButton.OnShutterButtonListener,
SurfaceHolder.Callback,
MediaRecorder.OnErrorListener,
MediaRecorder.OnInfoListener,
Switcher.OnSwitchListener,
PreviewFrameLayout.OnSizeChangedListener {
    private static final String TAG = "videocamera";
    private static final int CLEAR_SCREEN_DELAY = 4;
    private static final int UPDATE_RECORD_TIME = 5;
    private static final int ENABLE_SHUTTER_BUTTON = 6;
    private static final int SCREEN_DELAY = 120000;
    private static final float DEFAULT_CAMERA_BRIGHTNESS = 0.7f;
    private static final long NO_STORAGE_ERROR = -1L;
    private static final long CANNOT_STAT_ERROR = -2L;
    private static final long LOW_STORAGE_THRESHOLD = 524288L;
    private static final int STORAGE_STATUS_OK = 0;
    private static final int STORAGE_STATUS_LOW = 1;
    private static final int STORAGE_STATUS_NONE = 2;
    private static final int STORAGE_STATUS_FAIL = 3;
    private static final boolean SWITCH_CAMERA = true;
    private static final boolean SWITCH_VIDEO = false;
    private static final long SHUTTER_BUTTON_TIMEOUT = 500L;
    private static final String EXTRA_QUICK_CAPTURE = "android.intent.extra.quickCapture";
    private ComboPreferences mPreferences;
    private PreviewFrameLayout mPreviewFrameLayout;
    private SurfaceView mVideoPreview;
    private SurfaceHolder mSurfaceHolder = null;
    private ImageView mVideoFrame;
    private GLRootView mGLRootView;
    private CamcorderHeadUpDisplay mHeadUpDisplay;
    private boolean mIsVideoCaptureIntent;
    private boolean mQuickCapture;
    private ImageView mLastPictureButton;
    private ThumbnailController mThumbController;
    private boolean mStartPreviewFail = false;
    private int mStorageStatus = 0;
    private MediaRecorder mMediaRecorder;
    private boolean mMediaRecorderRecording = false;
    private long mRecordingStartTime;
    private String mVideoFilename;
    private ParcelFileDescriptor mVideoFileDescriptor;
    private String mCurrentVideoFilename;
    private Uri mCurrentVideoUri;
    private ContentValues mCurrentVideoValues;
    private CamcorderProfile mProfile;
    private int mMaxVideoDurationInMs;
    boolean mPausing = false;
    boolean mPreviewing = false;
    private ContentResolver mContentResolver;
    private ShutterButton mShutterButton;
    private RotateRecordingTime mRecordingTimeRect;
    private TextView mRecordingTimeView;
    private Switcher mSwitcher;
    private boolean mRecordingTimeCountsDown = false;
    private final ArrayList<MenuItem> mGalleryItems = new ArrayList();
    private final Handler mHandler = new MainHandler();
    private Camera.Parameters mParameters;
    private int mNumberOfCameras;
    private int mCameraId;
    private MyOrientationEventListener mOrientationListener;
    private int mOrientation = -1;
    private int mOrientationCompensation = 0;
    private int mOrientationHint;
    private BroadcastReceiver mReceiver = null;
    private OnScreenHint mStorageHint;
    private Camera mCameraDevice;

    private String createName(long dateTaken) {
        Date date = new Date(dateTaken);
        SimpleDateFormat dateFormat = new SimpleDateFormat(this.getString(2131296359));
        return dateFormat.format(date);
    }

    private void showCameraErrorAndFinish() {
        Resources ress = this.getResources();
        Util.showFatalErrorAndFinish(this, ress.getString(2131296256), ress.getString(2131296257));
    }

    private boolean restartPreview() {
        try {
            this.startPreview();
        }
        catch (CameraHardwareException e) {
            this.showCameraErrorAndFinish();
            return false;
        }
        return true;
    }

    public void onCreate(Bundle icicle) {
        super.onCreate(icicle);
        Window win = this.getWindow();
        int mode = Settings.System.getInt((ContentResolver)this.getContentResolver(), (String)"screen_brightness_mode", (int)0);
        if (mode == 1) {
            WindowManager.LayoutParams winParams = win.getAttributes();
            winParams.screenBrightness = 0.7f;
            win.setAttributes(winParams);
        }
        this.mPreferences = new ComboPreferences((Context)this);
        CameraSettings.upgradeGlobalPreferences(this.mPreferences.getGlobal());
        this.mCameraId = CameraSettings.readPreferredCameraId(this.mPreferences);
        this.mPreferences.setLocalId((Context)this, this.mCameraId);
        CameraSettings.upgradeLocalPreferences(this.mPreferences.getLocal());
        this.mNumberOfCameras = CameraHolder.instance().getNumberOfCameras();
        this.readVideoPreferences();
        Thread startPreviewThread = new Thread(new Runnable(){

            public void run() {
                try {
                    VideoCamera.this.mStartPreviewFail = false;
                    VideoCamera.this.startPreview();
                }
                catch (CameraHardwareException e) {
                    if ("eng".equals(Build.TYPE)) {
                        throw new RuntimeException(e);
                    }
                    VideoCamera.this.mStartPreviewFail = true;
                }
            }
        });
        startPreviewThread.start();
        this.mContentResolver = this.getContentResolver();
        this.requestWindowFeature(2);
        this.setContentView(2130903044);
        this.mPreviewFrameLayout = (PreviewFrameLayout)this.findViewById(2131427335);
        this.mPreviewFrameLayout.setOnSizeChangedListener(this);
        this.resizeForPreviewAspectRatio();
        this.mVideoPreview = (SurfaceView)this.findViewById(2131427337);
        this.mVideoFrame = (ImageView)this.findViewById(2131427346);
        SurfaceHolder holder = this.mVideoPreview.getHolder();
        holder.addCallback((SurfaceHolder.Callback)this);
        holder.setType(3);
        this.mIsVideoCaptureIntent = this.isVideoCaptureIntent();
        this.mQuickCapture = this.getIntent().getBooleanExtra(EXTRA_QUICK_CAPTURE, false);
        this.mRecordingTimeView = (TextView)this.findViewById(2131427348);
        this.mRecordingTimeRect = (RotateRecordingTime)this.findViewById(2131427347);
        ViewGroup rootView = (ViewGroup)this.findViewById(2131427345);
        LayoutInflater inflater = this.getLayoutInflater();
        if (!this.mIsVideoCaptureIntent) {
            View controlBar = inflater.inflate(2130903042, rootView);
            this.mLastPictureButton = (ImageView)controlBar.findViewById(2131427339);
            this.mThumbController = new ThumbnailController(this.getResources(), this.mLastPictureButton, this.mContentResolver);
            this.mLastPictureButton.setOnClickListener((View.OnClickListener)this);
            this.mThumbController.loadData(ImageManager.getLastVideoThumbPath());
            this.mSwitcher = (Switcher)this.findViewById(2131427342);
            this.mSwitcher.setOnSwitchListener(this);
            this.mSwitcher.addTouchView(this.findViewById(2131427340));
        } else {
            View controlBar = inflater.inflate(2130903040, rootView);
            controlBar.findViewById(2131427329).setOnClickListener((View.OnClickListener)this);
            ImageView retake = (ImageView)controlBar.findViewById(2131427330);
            retake.setOnClickListener((View.OnClickListener)this);
            retake.setImageResource(2130837520);
            controlBar.findViewById(2131427331).setOnClickListener((View.OnClickListener)this);
            controlBar.findViewById(2131427333).setOnClickListener((View.OnClickListener)this);
        }
        this.mShutterButton = (ShutterButton)this.findViewById(2131427332);
        this.mShutterButton.setImageResource(2130837521);
        this.mShutterButton.setOnShutterButtonListener(this);
        this.mShutterButton.requestFocus();
        this.mOrientationListener = new MyOrientationEventListener((Context)this);
        try {
            startPreviewThread.join();
            if (this.mStartPreviewFail) {
                this.showCameraErrorAndFinish();
                return;
            }
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        this.mHeadUpDisplay = new CamcorderHeadUpDisplay((Context)this);
        this.mHeadUpDisplay.setListener(new MyHeadUpDisplayListener());
        this.initializeHeadUpDisplay();
    }

    private void changeHeadUpDisplayState() {
        Configuration config = this.getResources().getConfiguration();
        if (config.orientation == 2 && !this.mPausing && this.mGLRootView == null) {
            this.attachHeadUpDisplay();
        } else if (this.mGLRootView != null) {
            this.detachHeadUpDisplay();
        }
    }

    private void initializeHeadUpDisplay() {
        CameraSettings settings = new CameraSettings(this, this.mParameters, CameraHolder.instance().getCameraInfo());
        PreferenceGroup group = settings.getPreferenceGroup(2131034113);
        if (this.mIsVideoCaptureIntent) {
            group = this.filterPreferenceScreenByIntent(group);
        }
        this.mHeadUpDisplay.initialize((Context)this, group, this.mOrientationCompensation);
    }

    private void attachHeadUpDisplay() {
        this.mHeadUpDisplay.setOrientation(this.mOrientationCompensation);
        FrameLayout frame = (FrameLayout)this.findViewById(2131427336);
        this.mGLRootView = new GLRootView((Context)this);
        frame.addView((View)this.mGLRootView);
        this.mGLRootView.setContentPane(this.mHeadUpDisplay);
    }

    private void detachHeadUpDisplay() {
        this.mHeadUpDisplay.collapse();
        ((ViewGroup)this.mGLRootView.getParent()).removeView((View)this.mGLRootView);
        this.mGLRootView = null;
    }

    public static int roundOrientation(int orientation) {
        return (orientation + 45) / 90 * 90 % 360;
    }

    private void setOrientationIndicator(int degree) {
        ((RotateImageView)this.findViewById(2131427339)).setDegree(degree);
        ((RotateImageView)this.findViewById(2131427343)).setDegree(degree);
        ((RotateImageView)this.findViewById(2131427341)).setDegree(degree);
    }

    protected void onStart() {
        super.onStart();
        if (!this.mIsVideoCaptureIntent) {
            this.mSwitcher.setSwitch(false);
        }
    }

    private void startPlayVideoActivity() {
        Intent intent = new Intent("android.intent.action.VIEW", this.mCurrentVideoUri);
        try {
            this.startActivity(intent);
        }
        catch (ActivityNotFoundException ex) {
            Log.e((String)TAG, (String)("Couldn't view video " + this.mCurrentVideoUri), (Throwable)ex);
        }
    }

    public void onClick(View v) {
        switch (v.getId()) {
            case 2131427330: {
                this.deleteCurrentVideo();
                this.hideAlert();
                break;
            }
            case 2131427331: {
                this.startPlayVideoActivity();
                break;
            }
            case 2131427333: {
                this.doReturnToCaller(true);
                break;
            }
            case 2131427329: {
                this.stopVideoRecordingAndReturn(false);
                break;
            }
            case 2131427339: {
                if (this.mMediaRecorderRecording) break;
                this.viewLastVideo();
            }
        }
    }

    @Override
    public void onShutterButtonFocus(ShutterButton button, boolean pressed) {
    }

    private void onStopVideoRecording(boolean valid) {
        if (this.mIsVideoCaptureIntent) {
            if (this.mQuickCapture) {
                this.stopVideoRecordingAndReturn(valid);
            } else {
                this.stopVideoRecordingAndShowAlert();
            }
        } else {
            this.stopVideoRecordingAndGetThumbnail();
        }
    }

    @Override
    public void onShutterButtonClick(ShutterButton button) {
        switch (button.getId()) {
            case 2131427332: {
                if (this.mHeadUpDisplay.collapse()) {
                    return;
                }
                if (this.mMediaRecorderRecording) {
                    this.onStopVideoRecording(true);
                } else {
                    this.startVideoRecording();
                }
                this.mShutterButton.setEnabled(false);
                this.mHandler.sendEmptyMessageDelayed(6, 500L);
            }
        }
    }

    private void updateAndShowStorageHint(boolean mayHaveSd) {
        this.mStorageStatus = this.getStorageStatus(mayHaveSd);
        this.showStorageHint();
    }

    private void showStorageHint() {
        String errorMessage = null;
        switch (this.mStorageStatus) {
            case 2: {
                errorMessage = this.getString(2131296263);
                break;
            }
            case 1: {
                errorMessage = this.getString(2131296357);
                break;
            }
            case 3: {
                errorMessage = this.getString(2131296266);
            }
        }
        if (errorMessage != null) {
            if (this.mStorageHint == null) {
                this.mStorageHint = OnScreenHint.makeText((Context)this, errorMessage);
            } else {
                this.mStorageHint.setText(errorMessage);
            }
            this.mStorageHint.show();
        } else if (this.mStorageHint != null) {
            this.mStorageHint.cancel();
            this.mStorageHint = null;
        }
    }

    private int getStorageStatus(boolean mayHaveSd) {
        long remaining;
        long l = remaining = mayHaveSd ? VideoCamera.getAvailableStorage() : -1L;
        if (remaining == -1L) {
            return 2;
        }
        if (remaining == -2L) {
            return 3;
        }
        return remaining < 524288L ? 1 : 0;
    }

    private void readVideoPreferences() {
        String quality = this.mPreferences.getString("pref_video_quality_key", "high");
        boolean videoQualityHigh = CameraSettings.getVideoQuality(quality);
        Intent intent = this.getIntent();
        if (intent.hasExtra("android.intent.extra.videoQuality")) {
            int extraVideoQuality = intent.getIntExtra("android.intent.extra.videoQuality", 0);
            boolean bl = videoQualityHigh = extraVideoQuality > 0;
        }
        if (intent.hasExtra("android.intent.extra.durationLimit")) {
            int seconds = intent.getIntExtra("android.intent.extra.durationLimit", 0);
            this.mMaxVideoDurationInMs = 1000 * seconds;
        } else {
            this.mMaxVideoDurationInMs = CameraSettings.getVidoeDurationInMillis(quality);
        }
        this.mProfile = CamcorderProfile.get((int)this.mCameraId, (int)(videoQualityHigh ? 1 : 0));
    }

    private void resizeForPreviewAspectRatio() {
        this.mPreviewFrameLayout.setAspectRatio((double)this.mProfile.videoFrameWidth / (double)this.mProfile.videoFrameHeight);
    }

    protected void onResume() {
        super.onResume();
        this.mPausing = false;
        this.mOrientationListener.enable();
        this.mVideoPreview.setVisibility(0);
        this.readVideoPreferences();
        this.resizeForPreviewAspectRatio();
        if (!(this.mPreviewing || this.mStartPreviewFail || this.restartPreview())) {
            return;
        }
        this.keepScreenOnAwhile();
        IntentFilter intentFilter = new IntentFilter("android.intent.action.MEDIA_MOUNTED");
        intentFilter.addAction("android.intent.action.MEDIA_EJECT");
        intentFilter.addAction("android.intent.action.MEDIA_UNMOUNTED");
        intentFilter.addAction("android.intent.action.MEDIA_SCANNER_STARTED");
        intentFilter.addAction("android.intent.action.MEDIA_SCANNER_FINISHED");
        intentFilter.addDataScheme("file");
        this.mReceiver = new MyBroadcastReceiver();
        this.registerReceiver(this.mReceiver, intentFilter);
        this.mStorageStatus = this.getStorageStatus(true);
        this.mHandler.postDelayed(new Runnable(){

            public void run() {
                VideoCamera.this.showStorageHint();
            }
        }, 200L);
        this.changeHeadUpDisplayState();
        this.updateThumbnailButton();
    }

    private void setPreviewDisplay(SurfaceHolder holder) {
        try {
            this.mCameraDevice.setPreviewDisplay(holder);
        }
        catch (Throwable ex) {
            this.closeCamera();
            throw new RuntimeException("setPreviewDisplay failed", ex);
        }
    }

    private void startPreview() throws CameraHardwareException {
        Log.v((String)TAG, (String)"startPreview");
        if (this.mCameraDevice == null) {
            this.mCameraDevice = CameraHolder.instance().open(this.mCameraId);
        }
        if (this.mPreviewing) {
            this.mCameraDevice.stopPreview();
            this.mPreviewing = false;
        }
        this.setPreviewDisplay(this.mSurfaceHolder);
        Util.setCameraDisplayOrientation(this, this.mCameraId, this.mCameraDevice);
        this.setCameraParameters();
        try {
            this.mCameraDevice.startPreview();
            this.mPreviewing = true;
        }
        catch (Throwable ex) {
            this.closeCamera();
            throw new RuntimeException("startPreview failed", ex);
        }
    }

    private void closeCamera() {
        Log.v((String)TAG, (String)"closeCamera");
        if (this.mCameraDevice == null) {
            Log.d((String)TAG, (String)"already stopped.");
            return;
        }
        this.mCameraDevice.lock();
        CameraHolder.instance().release();
        this.mCameraDevice = null;
        this.mPreviewing = false;
    }

    protected void onPause() {
        super.onPause();
        this.mPausing = true;
        this.changeHeadUpDisplayState();
        this.mVideoPreview.setVisibility(4);
        if (this.mMediaRecorderRecording) {
            if (this.mIsVideoCaptureIntent) {
                this.stopVideoRecording();
                this.showAlert();
            } else {
                this.stopVideoRecordingAndGetThumbnail();
            }
        } else {
            this.stopVideoRecording();
        }
        this.closeCamera();
        if (this.mReceiver != null) {
            this.unregisterReceiver(this.mReceiver);
            this.mReceiver = null;
        }
        this.resetScreenOn();
        if (!this.mIsVideoCaptureIntent) {
            this.mThumbController.storeData(ImageManager.getLastVideoThumbPath());
        }
        if (this.mStorageHint != null) {
            this.mStorageHint.cancel();
            this.mStorageHint = null;
        }
        this.mOrientationListener.disable();
    }

    public void onUserInteraction() {
        super.onUserInteraction();
        if (!this.mMediaRecorderRecording) {
            this.keepScreenOnAwhile();
        }
    }

    public void onBackPressed() {
        if (this.mPausing) {
            return;
        }
        if (this.mMediaRecorderRecording) {
            this.onStopVideoRecording(false);
        } else if (this.mHeadUpDisplay == null || !this.mHeadUpDisplay.collapse()) {
            super.onBackPressed();
        }
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (this.mPausing) {
            return true;
        }
        switch (keyCode) {
            case 27: {
                if (event.getRepeatCount() != 0) break;
                this.mShutterButton.performClick();
                return true;
            }
            case 23: {
                if (event.getRepeatCount() != 0) break;
                this.mShutterButton.performClick();
                return true;
            }
            case 82: {
                if (!this.mMediaRecorderRecording) break;
                this.onStopVideoRecording(true);
                return true;
            }
        }
        return super.onKeyDown(keyCode, event);
    }

    public boolean onKeyUp(int keyCode, KeyEvent event) {
        switch (keyCode) {
            case 27: {
                this.mShutterButton.setPressed(false);
                return true;
            }
        }
        return super.onKeyUp(keyCode, event);
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int w, int h) {
        if (holder.getSurface() == null) {
            Log.d((String)TAG, (String)"holder.getSurface() == null");
            return;
        }
        this.mSurfaceHolder = holder;
        if (this.mPausing) {
            return;
        }
        if (this.mCameraDevice == null) {
            return;
        }
        if (holder.isCreating()) {
            this.setPreviewDisplay(holder);
        } else {
            this.stopVideoRecording();
            this.restartPreview();
        }
    }

    public void surfaceCreated(SurfaceHolder holder) {
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        this.mSurfaceHolder = null;
    }

    private void gotoGallery() {
        MenuHelper.gotoCameraVideoGallery(this);
    }

    public boolean onCreateOptionsMenu(Menu menu) {
        super.onCreateOptionsMenu(menu);
        if (this.mIsVideoCaptureIntent) {
            return false;
        }
        this.addBaseMenuItems(menu);
        return true;
    }

    private boolean isVideoCaptureIntent() {
        String action = this.getIntent().getAction();
        return "android.media.action.VIDEO_CAPTURE".equals(action);
    }

    private void doReturnToCaller(boolean valid) {
        int resultCode;
        Intent resultIntent = new Intent();
        if (valid) {
            resultCode = -1;
            resultIntent.setData(this.mCurrentVideoUri);
        } else {
            resultCode = 0;
        }
        this.setResult(resultCode, resultIntent);
        this.finish();
    }

    private static long getAvailableStorage() {
        try {
            if (!ImageManager.hasStorage()) {
                return -1L;
            }
            String storageDirectory = Environment.getExternalStorageDirectory().toString();
            StatFs stat = new StatFs(storageDirectory);
            return (long)stat.getAvailableBlocks() * (long)stat.getBlockSize();
        }
        catch (Exception ex) {
            Log.e((String)TAG, (String)"Fail to access sdcard", (Throwable)ex);
            return -2L;
        }
    }

    private void cleanupEmptyFile() {
        File f;
        if (this.mVideoFilename != null && (f = new File(this.mVideoFilename)).length() == 0L && f.delete()) {
            Log.v((String)TAG, (String)("Empty video file deleted: " + this.mVideoFilename));
            this.mVideoFilename = null;
        }
    }

    private void initializeRecorder() {
        Log.v((String)TAG, (String)"initializeRecorder");
        if (this.mCameraDevice == null) {
            return;
        }
        if (this.mSurfaceHolder == null) {
            Log.v((String)TAG, (String)"Surface holder is null. Wait for surface changed.");
            return;
        }
        Intent intent = this.getIntent();
        Bundle myExtras = intent.getExtras();
        long requestedSizeLimit = 0L;
        if (this.mIsVideoCaptureIntent && myExtras != null) {
            Uri saveUri = (Uri)myExtras.getParcelable("output");
            if (saveUri != null) {
                try {
                    this.mVideoFileDescriptor = this.mContentResolver.openFileDescriptor(saveUri, "rw");
                    this.mCurrentVideoUri = saveUri;
                }
                catch (FileNotFoundException ex) {
                    Log.e((String)TAG, (String)ex.toString());
                }
            }
            requestedSizeLimit = myExtras.getLong("android.intent.extra.sizeLimit");
        }
        this.mMediaRecorder = new MediaRecorder();
        this.mCameraDevice.unlock();
        this.mMediaRecorder.setCamera(this.mCameraDevice);
        this.mMediaRecorder.setAudioSource(5);
        this.mMediaRecorder.setVideoSource(1);
        this.mMediaRecorder.setProfile(this.mProfile);
        this.mMediaRecorder.setMaxDuration(this.mMaxVideoDurationInMs);
        if (this.mStorageStatus != 0) {
            this.mMediaRecorder.setOutputFile("/dev/null");
        } else if (this.mVideoFileDescriptor != null) {
            this.mMediaRecorder.setOutputFile(this.mVideoFileDescriptor.getFileDescriptor());
            try {
                this.mVideoFileDescriptor.close();
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)"Fail to close fd", (Throwable)e);
            }
        } else {
            this.createVideoPath();
            this.mMediaRecorder.setOutputFile(this.mVideoFilename);
        }
        this.mMediaRecorder.setPreviewDisplay(this.mSurfaceHolder.getSurface());
        long maxFileSize = VideoCamera.getAvailableStorage() - 131072L;
        if (requestedSizeLimit > 0L && requestedSizeLimit < maxFileSize) {
            maxFileSize = requestedSizeLimit;
        }
        try {
            this.mMediaRecorder.setMaxFileSize(maxFileSize);
        }
        catch (RuntimeException exception) {
            // empty catch block
        }
        int rotation = 0;
        if (this.mOrientation != -1) {
            Camera.CameraInfo info = CameraHolder.instance().getCameraInfo()[this.mCameraId];
            rotation = info.facing == 1 ? (info.orientation - this.mOrientation + 360) % 360 : (info.orientation + this.mOrientation) % 360;
        }
        this.mMediaRecorder.setOrientationHint(rotation);
        this.mOrientationHint = rotation;
        try {
            this.mMediaRecorder.prepare();
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)("prepare failed for " + this.mVideoFilename), (Throwable)e);
            this.releaseMediaRecorder();
            throw new RuntimeException(e);
        }
        this.mMediaRecorder.setOnErrorListener((MediaRecorder.OnErrorListener)this);
        this.mMediaRecorder.setOnInfoListener((MediaRecorder.OnInfoListener)this);
    }

    private void releaseMediaRecorder() {
        Log.v((String)TAG, (String)"Releasing media recorder.");
        if (this.mMediaRecorder != null) {
            this.cleanupEmptyFile();
            this.mMediaRecorder.reset();
            this.mMediaRecorder.release();
            this.mMediaRecorder = null;
        }
        if (this.mCameraDevice != null) {
            this.mCameraDevice.lock();
        }
    }

    private void createVideoPath() {
        long dateTaken = System.currentTimeMillis();
        String title = this.createName(dateTaken);
        String filename = title + ".3gp";
        String cameraDirPath = ImageManager.CAMERA_IMAGE_BUCKET_NAME;
        String filePath = cameraDirPath + "/" + filename;
        File cameraDir = new File(cameraDirPath);
        cameraDir.mkdirs();
        ContentValues values = new ContentValues(7);
        values.put("title", title);
        values.put("_display_name", filename);
        values.put("datetaken", Long.valueOf(dateTaken));
        values.put("mime_type", "video/3gpp");
        values.put("_data", filePath);
        this.mVideoFilename = filePath;
        Log.v((String)TAG, (String)("Current camera video filename: " + this.mVideoFilename));
        this.mCurrentVideoValues = values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerVideo() {
        if (this.mVideoFileDescriptor == null) {
            Uri videoTable = Uri.parse((String)"content://media/external/video/media");
            this.mCurrentVideoValues.put("_size", Long.valueOf(new File(this.mCurrentVideoFilename).length()));
            try {
                this.mCurrentVideoUri = this.mContentResolver.insert(videoTable, this.mCurrentVideoValues);
            }
            catch (Exception e) {
                this.mCurrentVideoUri = null;
                this.mCurrentVideoFilename = null;
            }
            finally {
                Log.v((String)TAG, (String)("Current video URI: " + this.mCurrentVideoUri));
            }
        }
        this.mCurrentVideoValues = null;
    }

    private void deleteCurrentVideo() {
        if (this.mCurrentVideoFilename != null) {
            this.deleteVideoFile(this.mCurrentVideoFilename);
            this.mCurrentVideoFilename = null;
        }
        if (this.mCurrentVideoUri != null) {
            this.mContentResolver.delete(this.mCurrentVideoUri, null, null);
            this.mCurrentVideoUri = null;
        }
        this.updateAndShowStorageHint(true);
    }

    private void deleteVideoFile(String fileName) {
        Log.v((String)TAG, (String)("Deleting video " + fileName));
        File f = new File(fileName);
        if (!f.delete()) {
            Log.v((String)TAG, (String)("Could not delete " + fileName));
        }
    }

    private void addBaseMenuItems(Menu menu) {
        MenuHelper.addSwitchModeMenuItem(menu, false, new Runnable(){

            public void run() {
                VideoCamera.this.switchToCameraMode();
            }
        });
        MenuItem gallery = menu.add(0, 0, 2, 2131296273).setOnMenuItemClickListener(new MenuItem.OnMenuItemClickListener(){

            public boolean onMenuItemClick(MenuItem item) {
                VideoCamera.this.gotoGallery();
                return true;
            }
        });
        gallery.setIcon(17301567);
        this.mGalleryItems.add(gallery);
        if (this.mNumberOfCameras > 1) {
            menu.add(0, 0, 3, 2131296274).setOnMenuItemClickListener(new MenuItem.OnMenuItemClickListener(){

                public boolean onMenuItemClick(MenuItem item) {
                    VideoCamera.this.switchCameraId((VideoCamera.this.mCameraId + 1) % VideoCamera.this.mNumberOfCameras);
                    return true;
                }
            }).setIcon(17301559);
        }
    }

    private void switchCameraId(int cameraId) {
        if (this.mPausing) {
            return;
        }
        this.mCameraId = cameraId;
        CameraSettings.writePreferredCameraId(this.mPreferences, cameraId);
        if (this.mMediaRecorderRecording) {
            if (this.mIsVideoCaptureIntent) {
                this.stopVideoRecording();
                this.showAlert();
            } else {
                this.stopVideoRecordingAndGetThumbnail();
            }
        } else {
            this.stopVideoRecording();
        }
        this.closeCamera();
        this.mPreferences.setLocalId((Context)this, this.mCameraId);
        CameraSettings.upgradeLocalPreferences(this.mPreferences.getLocal());
        this.readVideoPreferences();
        this.resizeForPreviewAspectRatio();
        this.restartPreview();
        this.initializeHeadUpDisplay();
    }

    private PreferenceGroup filterPreferenceScreenByIntent(PreferenceGroup screen) {
        Intent intent = this.getIntent();
        if (intent.hasExtra("android.intent.extra.videoQuality")) {
            CameraSettings.removePreferenceFromScreen(screen, "pref_video_quality_key");
        }
        if (intent.hasExtra("android.intent.extra.durationLimit")) {
            CameraSettings.removePreferenceFromScreen(screen, "pref_video_quality_key");
        }
        return screen;
    }

    public void onError(MediaRecorder mr, int what, int extra) {
        if (what == 1) {
            this.stopVideoRecording();
            this.updateAndShowStorageHint(true);
        }
    }

    public void onInfo(MediaRecorder mr, int what, int extra) {
        if (what == 800) {
            if (this.mMediaRecorderRecording) {
                this.onStopVideoRecording(true);
            }
        } else if (what == 801) {
            if (this.mMediaRecorderRecording) {
                this.onStopVideoRecording(true);
            }
            Toast.makeText((Context)this, (int)2131296360, (int)1).show();
        }
    }

    private void pauseAudioPlayback() {
        Intent i = new Intent("com.android.music.musicservicecommand");
        i.putExtra("command", "pause");
        this.sendBroadcast(i);
    }

    private void startVideoRecording() {
        Log.v((String)TAG, (String)"startVideoRecording");
        if (this.mStorageStatus != 0) {
            Log.v((String)TAG, (String)"Storage issue, ignore the start request");
            return;
        }
        this.initializeRecorder();
        if (this.mMediaRecorder == null) {
            Log.e((String)TAG, (String)"Fail to initialize media recorder");
            return;
        }
        this.pauseAudioPlayback();
        try {
            this.mMediaRecorder.start();
        }
        catch (RuntimeException e) {
            Log.e((String)TAG, (String)"Could not start media recorder. ", (Throwable)e);
            this.releaseMediaRecorder();
            return;
        }
        this.mHeadUpDisplay.setEnabled(false);
        this.mMediaRecorderRecording = true;
        this.mRecordingStartTime = SystemClock.uptimeMillis();
        this.updateRecordingIndicator(false);
        this.mRecordingTimeRect.setOrientation(this.mOrientationCompensation);
        this.mRecordingTimeView.setText((CharSequence)"");
        this.mRecordingTimeView.setVisibility(0);
        this.updateRecordingTime();
        this.keepScreenOn();
    }

    private void updateRecordingIndicator(boolean showRecording) {
        int drawableId = showRecording ? 2130837521 : 2130837522;
        Drawable drawable2 = this.getResources().getDrawable(drawableId);
        this.mShutterButton.setImageDrawable(drawable2);
    }

    private void stopVideoRecordingAndGetThumbnail() {
        this.stopVideoRecording();
        this.acquireVideoThumb();
    }

    private void stopVideoRecordingAndReturn(boolean valid) {
        this.stopVideoRecording();
        this.doReturnToCaller(valid);
    }

    private void stopVideoRecordingAndShowAlert() {
        this.stopVideoRecording();
        this.showAlert();
    }

    private void showAlert() {
        int[] pickIds;
        VideoCamera.fadeOut(this.findViewById(2131427332));
        if (this.mCurrentVideoFilename != null) {
            Bitmap src = ThumbnailUtils.createVideoThumbnail((String)this.mCurrentVideoFilename, (int)1);
            Camera.CameraInfo[] info = CameraHolder.instance().getCameraInfo();
            src = info[this.mCameraId].facing == 0 ? Util.rotateAndMirror(src, -this.mOrientationHint, false) : Util.rotateAndMirror(src, -this.mOrientationHint, true);
            this.mVideoFrame.setImageBitmap(src);
            this.mVideoFrame.setVisibility(0);
        }
        for (int id2 : pickIds = new int[]{2131427330, 2131427333, 2131427331}) {
            View button = this.findViewById(id2);
            VideoCamera.fadeIn((View)button.getParent());
        }
    }

    private void hideAlert() {
        int[] pickIds;
        this.mVideoFrame.setVisibility(4);
        VideoCamera.fadeIn(this.findViewById(2131427332));
        for (int id2 : pickIds = new int[]{2131427330, 2131427333, 2131427331}) {
            View button = this.findViewById(id2);
            VideoCamera.fadeOut((View)button.getParent());
        }
    }

    private static void fadeIn(View view) {
        view.setVisibility(0);
        AlphaAnimation animation = new AlphaAnimation(0.0f, 1.0f);
        animation.setDuration(500L);
        view.startAnimation((Animation)animation);
    }

    private static void fadeOut(View view) {
        view.setVisibility(4);
        AlphaAnimation animation = new AlphaAnimation(1.0f, 0.0f);
        animation.setDuration(500L);
        view.startAnimation((Animation)animation);
    }

    private boolean isAlertVisible() {
        return this.mVideoFrame.getVisibility() == 0;
    }

    private void viewLastVideo() {
        Intent intent = null;
        if (this.mThumbController.isUriValid()) {
            intent = new Intent("com.cooliris.media.action.REVIEW", this.mThumbController.getUri());
            try {
                this.startActivity(intent);
            }
            catch (ActivityNotFoundException ex) {
                try {
                    intent = new Intent("android.intent.action.VIEW", this.mThumbController.getUri());
                    this.startActivity(intent);
                }
                catch (ActivityNotFoundException e) {
                    Log.e((String)TAG, (String)"review video fail", (Throwable)e);
                }
            }
        } else {
            Log.e((String)TAG, (String)"Can't view last video.");
        }
    }

    private void stopVideoRecording() {
        Log.v((String)TAG, (String)"stopVideoRecording");
        if (this.mMediaRecorderRecording) {
            boolean needToRegisterRecording = false;
            this.mMediaRecorder.setOnErrorListener(null);
            this.mMediaRecorder.setOnInfoListener(null);
            try {
                this.mMediaRecorder.stop();
                this.mCurrentVideoFilename = this.mVideoFilename;
                Log.v((String)TAG, (String)("Setting current video filename: " + this.mCurrentVideoFilename));
                needToRegisterRecording = true;
            }
            catch (RuntimeException e) {
                Log.e((String)TAG, (String)("stop fail: " + e.getMessage()));
                this.deleteVideoFile(this.mVideoFilename);
            }
            this.mMediaRecorderRecording = false;
            this.mHeadUpDisplay.setEnabled(true);
            this.updateRecordingIndicator(true);
            this.mRecordingTimeView.setVisibility(8);
            this.keepScreenOnAwhile();
            if (needToRegisterRecording && this.mStorageStatus == 0) {
                this.registerVideo();
            }
            this.mVideoFilename = null;
            this.mVideoFileDescriptor = null;
        }
        this.releaseMediaRecorder();
    }

    private void resetScreenOn() {
        this.mHandler.removeMessages(4);
        this.getWindow().clearFlags(128);
    }

    private void keepScreenOnAwhile() {
        this.mHandler.removeMessages(4);
        this.getWindow().addFlags(128);
        this.mHandler.sendEmptyMessageDelayed(4, 120000L);
    }

    private void keepScreenOn() {
        this.mHandler.removeMessages(4);
        this.getWindow().addFlags(128);
    }

    private void acquireVideoThumb() {
        Bitmap videoFrame = ThumbnailUtils.createVideoThumbnail((String)this.mCurrentVideoFilename, (int)1);
        this.mThumbController.setData(this.mCurrentVideoUri, videoFrame);
        this.mThumbController.updateDisplayIfNeeded();
    }

    private static ImageManager.DataLocation dataLocation() {
        return ImageManager.DataLocation.EXTERNAL;
    }

    private void updateThumbnailButton() {
        if (!this.mIsVideoCaptureIntent) {
            if (!this.mThumbController.isUriValid()) {
                this.updateLastVideo();
            }
            this.mThumbController.updateDisplayIfNeeded();
        }
    }

    private void updateLastVideo() {
        IImageList list = ImageManager.makeImageList(this.mContentResolver, VideoCamera.dataLocation(), 4, 1, ImageManager.CAMERA_IMAGE_BUCKET_ID);
        int count = list.getCount();
        if (count > 0) {
            IImage image = list.getImageAt(count - 1);
            Uri uri = image.fullSizeImageUri();
            this.mThumbController.setData(uri, image.miniThumbBitmap());
        } else {
            this.mThumbController.setData(null, null);
        }
        list.close();
    }

    private void updateRecordingTime() {
        String minutesString;
        long seconds;
        if (!this.mMediaRecorderRecording) {
            return;
        }
        long now = SystemClock.uptimeMillis();
        long delta = now - this.mRecordingStartTime;
        boolean countdownRemainingTime = this.mMaxVideoDurationInMs != 0 && delta >= (long)(this.mMaxVideoDurationInMs - 60000);
        long next_update_delay = 1000L - delta % 1000L;
        if (countdownRemainingTime) {
            delta = Math.max(0L, (long)this.mMaxVideoDurationInMs - delta);
            seconds = (delta + 999L) / 1000L;
        } else {
            seconds = delta / 1000L;
        }
        long minutes = seconds / 60L;
        long hours = minutes / 60L;
        long remainderMinutes = minutes - hours * 60L;
        long remainderSeconds = seconds - minutes * 60L;
        String secondsString = Long.toString(remainderSeconds);
        if (secondsString.length() < 2) {
            secondsString = "0" + secondsString;
        }
        if ((minutesString = Long.toString(remainderMinutes)).length() < 2) {
            minutesString = "0" + minutesString;
        }
        String text = minutesString + ":" + secondsString;
        if (hours > 0L) {
            String hoursString = Long.toString(hours);
            if (hoursString.length() < 2) {
                hoursString = "0" + hoursString;
            }
            text = hoursString + ":" + text;
        }
        this.mRecordingTimeView.setText((CharSequence)text);
        if (this.mRecordingTimeCountsDown != countdownRemainingTime) {
            this.mRecordingTimeCountsDown = countdownRemainingTime;
            int color2 = this.getResources().getColor(countdownRemainingTime ? 2131165185 : 0x7F070000);
            this.mRecordingTimeView.setTextColor(color2);
        }
        this.mHandler.sendEmptyMessageDelayed(5, next_update_delay);
    }

    private static boolean isSupported(String value, List<String> supported) {
        return supported == null ? false : supported.indexOf(value) >= 0;
    }

    private void setCameraParameters() {
        this.mParameters = this.mCameraDevice.getParameters();
        this.mParameters.setPreviewSize(this.mProfile.videoFrameWidth, this.mProfile.videoFrameHeight);
        this.mParameters.setPreviewFrameRate(this.mProfile.videoFrameRate);
        String flashMode = this.mPreferences.getString("pref_camera_video_flashmode_key", this.getString(2131296314));
        List supportedFlash = this.mParameters.getSupportedFlashModes();
        if (VideoCamera.isSupported(flashMode, supportedFlash)) {
            this.mParameters.setFlashMode(flashMode);
        } else {
            flashMode = this.mParameters.getFlashMode();
            if (flashMode == null) {
                flashMode = this.getString(2131296309);
            }
        }
        String whiteBalance = this.mPreferences.getString("pref_camera_whitebalance_key", this.getString(2131296315));
        if (VideoCamera.isSupported(whiteBalance, this.mParameters.getSupportedWhiteBalance())) {
            this.mParameters.setWhiteBalance(whiteBalance);
        } else {
            whiteBalance = this.mParameters.getWhiteBalance();
            if (whiteBalance == null) {
                whiteBalance = "auto";
            }
        }
        String colorEffect = this.mPreferences.getString("pref_camera_coloreffect_key", this.getString(2131296322));
        if (VideoCamera.isSupported(colorEffect, this.mParameters.getSupportedColorEffects())) {
            this.mParameters.setColorEffect(colorEffect);
        }
        this.mCameraDevice.setParameters(this.mParameters);
        this.mParameters = this.mCameraDevice.getParameters();
    }

    private boolean switchToCameraMode() {
        if (this.isFinishing() || this.mMediaRecorderRecording) {
            return false;
        }
        MenuHelper.gotoCameraMode(this);
        this.finish();
        return true;
    }

    @Override
    public boolean onSwitchChanged(Switcher source, boolean onOff) {
        if (onOff) {
            return this.switchToCameraMode();
        }
        return true;
    }

    public void onConfigurationChanged(Configuration config) {
        super.onConfigurationChanged(config);
        this.changeHeadUpDisplayState();
    }

    private void resetCameraParameters() {
        Camera.Size size = this.mParameters.getPreviewSize();
        if (size.width != this.mProfile.videoFrameWidth || size.height != this.mProfile.videoFrameHeight) {
            this.closeCamera();
            this.resizeForPreviewAspectRatio();
            this.restartPreview();
        } else {
            this.setCameraParameters();
        }
    }

    @Override
    public void onSizeChanged() {
    }

    private void onRestorePreferencesClicked() {
        Runnable runnable = new Runnable(){

            public void run() {
                VideoCamera.this.mHeadUpDisplay.restorePreferences(VideoCamera.this.mParameters);
            }
        };
        MenuHelper.confirmAction((Context)this, this.getString(2131296267), this.getString(2131296268), runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onSharedPreferencesChanged() {
        if (this.mPausing) {
            return;
        }
        ComboPreferences comboPreferences = this.mPreferences;
        synchronized (comboPreferences) {
            this.readVideoPreferences();
            if (this.mCameraDevice == null) {
                return;
            }
            int cameraId = CameraSettings.readPreferredCameraId(this.mPreferences);
            if (this.mCameraId != cameraId) {
                this.switchCameraId(cameraId);
            } else {
                this.resetCameraParameters();
            }
        }
    }

    private class MyHeadUpDisplayListener
    implements HeadUpDisplay.Listener {
        private MyHeadUpDisplayListener() {
        }

        public void onSharedPreferencesChanged() {
            VideoCamera.this.mHandler.post(new Runnable(){

                public void run() {
                    VideoCamera.this.onSharedPreferencesChanged();
                }
            });
        }

        public void onRestorePreferencesClicked() {
            VideoCamera.this.mHandler.post(new Runnable(){

                public void run() {
                    VideoCamera.this.onRestorePreferencesClicked();
                }
            });
        }

        public void onPopupWindowVisibilityChanged(int visibility) {
        }
    }

    private class MyOrientationEventListener
    extends OrientationEventListener {
        public MyOrientationEventListener(Context context) {
            super(context);
        }

        public void onOrientationChanged(int orientation) {
            if (VideoCamera.this.mMediaRecorderRecording) {
                return;
            }
            if (orientation == -1) {
                return;
            }
            VideoCamera.this.mOrientation = VideoCamera.roundOrientation(orientation);
            int orientationCompensation = VideoCamera.this.mOrientation + Util.getDisplayRotation(VideoCamera.this);
            if (VideoCamera.this.mOrientationCompensation != orientationCompensation) {
                VideoCamera.this.mOrientationCompensation = orientationCompensation;
                if (!VideoCamera.this.mIsVideoCaptureIntent) {
                    VideoCamera.this.setOrientationIndicator(VideoCamera.this.mOrientationCompensation);
                }
                VideoCamera.this.mHeadUpDisplay.setOrientation(VideoCamera.this.mOrientationCompensation);
            }
        }
    }

    private class MyBroadcastReceiver
    extends BroadcastReceiver {
        private MyBroadcastReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (action.equals("android.intent.action.MEDIA_EJECT")) {
                VideoCamera.this.updateAndShowStorageHint(false);
                VideoCamera.this.stopVideoRecording();
            } else if (action.equals("android.intent.action.MEDIA_MOUNTED")) {
                VideoCamera.this.updateAndShowStorageHint(true);
                VideoCamera.this.updateThumbnailButton();
            } else if (!action.equals("android.intent.action.MEDIA_UNMOUNTED")) {
                if (action.equals("android.intent.action.MEDIA_SCANNER_STARTED")) {
                    Toast.makeText((Context)VideoCamera.this, (CharSequence)VideoCamera.this.getResources().getString(2131296262), (int)5000);
                } else if (action.equals("android.intent.action.MEDIA_SCANNER_FINISHED")) {
                    VideoCamera.this.updateAndShowStorageHint(true);
                }
            }
        }
    }

    private class MainHandler
    extends Handler {
        private MainHandler() {
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 6: {
                    VideoCamera.this.mShutterButton.setEnabled(true);
                    break;
                }
                case 4: {
                    VideoCamera.this.getWindow().clearFlags(128);
                    break;
                }
                case 5: {
                    VideoCamera.this.updateRecordingTime();
                    break;
                }
                default: {
                    Log.v((String)VideoCamera.TAG, (String)("Unhandled message: " + msg.what));
                }
            }
        }
    }
}

