/*
 * Decompiled with CFR 0.152.
 */
package com.android.camera;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.hardware.Camera;
import android.util.Log;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.TranslateAnimation;
import java.io.Closeable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    private static final String TAG = "Util";
    public static final int DIRECTION_LEFT = 0;
    public static final int DIRECTION_RIGHT = 1;
    public static final int DIRECTION_UP = 2;
    public static final int DIRECTION_DOWN = 3;
    public static final String REVIEW_ACTION = "com.cooliris.media.action.REVIEW";

    private Util() {
    }

    public static Bitmap rotate(Bitmap b, int degrees) {
        return Util.rotateAndMirror(b, degrees, false);
    }

    public static Bitmap rotateAndMirror(Bitmap b, int degrees, boolean mirror) {
        if ((degrees != 0 || mirror) && b != null) {
            Matrix m = new Matrix();
            m.setRotate((float)degrees, (float)b.getWidth() / 2.0f, (float)b.getHeight() / 2.0f);
            if (mirror) {
                m.postScale(-1.0f, 1.0f);
                degrees = (degrees + 360) % 360;
                if (degrees == 0 || degrees == 180) {
                    m.postTranslate((float)b.getWidth(), 0.0f);
                } else if (degrees == 90 || degrees == 270) {
                    m.postTranslate((float)b.getHeight(), 0.0f);
                } else {
                    throw new IllegalArgumentException("Invalid degrees=" + degrees);
                }
            }
            try {
                Bitmap b2 = Bitmap.createBitmap((Bitmap)b, (int)0, (int)0, (int)b.getWidth(), (int)b.getHeight(), (Matrix)m, (boolean)true);
                if (b != b2) {
                    b.recycle();
                    b = b2;
                }
            }
            catch (OutOfMemoryError ex) {
                // empty catch block
            }
        }
        return b;
    }

    public static int computeSampleSize(BitmapFactory.Options options, int minSideLength, int maxNumOfPixels) {
        int roundedSize;
        int initialSize = Util.computeInitialSampleSize(options, minSideLength, maxNumOfPixels);
        if (initialSize <= 8) {
            for (roundedSize = 1; roundedSize < initialSize; roundedSize <<= 1) {
            }
        } else {
            roundedSize = (initialSize + 7) / 8 * 8;
        }
        return roundedSize;
    }

    private static int computeInitialSampleSize(BitmapFactory.Options options, int minSideLength, int maxNumOfPixels) {
        int upperBound;
        double w = options.outWidth;
        double h = options.outHeight;
        int lowerBound = maxNumOfPixels == -1 ? 1 : (int)Math.ceil(Math.sqrt(w * h / (double)maxNumOfPixels));
        int n = upperBound = minSideLength == -1 ? 128 : (int)Math.min(Math.floor(w / (double)minSideLength), Math.floor(h / (double)minSideLength));
        if (upperBound < lowerBound) {
            return lowerBound;
        }
        if (maxNumOfPixels == -1 && minSideLength == -1) {
            return 1;
        }
        if (minSideLength == -1) {
            return lowerBound;
        }
        return upperBound;
    }

    public static <T> int indexOf(T[] array2, T s) {
        for (int i = 0; i < array2.length; ++i) {
            if (!array2[i].equals(s)) continue;
            return i;
        }
        return -1;
    }

    public static void closeSilently(Closeable c) {
        if (c == null) {
            return;
        }
        try {
            c.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static Bitmap makeBitmap(byte[] jpegData, int maxNumOfPixels) {
        try {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeByteArray((byte[])jpegData, (int)0, (int)jpegData.length, (BitmapFactory.Options)options);
            if (options.mCancel || options.outWidth == -1 || options.outHeight == -1) {
                return null;
            }
            options.inSampleSize = Util.computeSampleSize(options, -1, maxNumOfPixels);
            options.inJustDecodeBounds = false;
            options.inDither = false;
            options.inPreferredConfig = Bitmap.Config.ARGB_8888;
            return BitmapFactory.decodeByteArray((byte[])jpegData, (int)0, (int)jpegData.length, (BitmapFactory.Options)options);
        }
        catch (OutOfMemoryError ex) {
            Log.e((String)TAG, (String)"Got oom exception ", (Throwable)ex);
            return null;
        }
    }

    public static void Assert(boolean cond) {
        if (!cond) {
            throw new AssertionError();
        }
    }

    public static void showFatalErrorAndFinish(final Activity activity, String title, String message) {
        DialogInterface.OnClickListener buttonListener = new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                activity.finish();
            }
        };
        new AlertDialog.Builder((Context)activity).setCancelable(false).setIcon(17301543).setTitle((CharSequence)title).setMessage((CharSequence)message).setNeutralButton(2131296356, buttonListener).show();
    }

    public static Animation slideOut(View view, int to) {
        TranslateAnimation anim2;
        view.setVisibility(4);
        switch (to) {
            case 0: {
                anim2 = new TranslateAnimation(0.0f, (float)(-view.getWidth()), 0.0f, 0.0f);
                break;
            }
            case 1: {
                anim2 = new TranslateAnimation(0.0f, (float)view.getWidth(), 0.0f, 0.0f);
                break;
            }
            case 2: {
                anim2 = new TranslateAnimation(0.0f, 0.0f, 0.0f, (float)(-view.getHeight()));
                break;
            }
            case 3: {
                anim2 = new TranslateAnimation(0.0f, 0.0f, 0.0f, (float)view.getHeight());
                break;
            }
            default: {
                throw new IllegalArgumentException(Integer.toString(to));
            }
        }
        anim2.setDuration(500L);
        view.startAnimation((Animation)anim2);
        return anim2;
    }

    public static Animation slideIn(View view, int from) {
        TranslateAnimation anim2;
        view.setVisibility(0);
        switch (from) {
            case 0: {
                anim2 = new TranslateAnimation((float)(-view.getWidth()), 0.0f, 0.0f, 0.0f);
                break;
            }
            case 1: {
                anim2 = new TranslateAnimation((float)view.getWidth(), 0.0f, 0.0f, 0.0f);
                break;
            }
            case 2: {
                anim2 = new TranslateAnimation(0.0f, 0.0f, (float)(-view.getHeight()), 0.0f);
                break;
            }
            case 3: {
                anim2 = new TranslateAnimation(0.0f, 0.0f, (float)view.getHeight(), 0.0f);
                break;
            }
            default: {
                throw new IllegalArgumentException(Integer.toString(from));
            }
        }
        anim2.setDuration(500L);
        view.startAnimation((Animation)anim2);
        return anim2;
    }

    public static <T> T checkNotNull(T object) {
        if (object == null) {
            throw new NullPointerException();
        }
        return object;
    }

    public static boolean equals(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    public static boolean isPowerOf2(int n) {
        return (n & -n) == n;
    }

    public static int nextPowerOf2(int n) {
        --n;
        n |= n >>> 16;
        n |= n >>> 8;
        n |= n >>> 4;
        n |= n >>> 2;
        n |= n >>> 1;
        return n + 1;
    }

    public static float distance(float x, float y, float sx, float sy) {
        float dx = x - sx;
        float dy = y - sy;
        return (float)Math.sqrt(dx * dx + dy * dy);
    }

    public static int clamp(int x, int min, int max) {
        if (x > max) {
            return max;
        }
        if (x < min) {
            return min;
        }
        return x;
    }

    public static int getDisplayRotation(Activity activity) {
        int rotation = activity.getWindowManager().getDefaultDisplay().getRotation();
        switch (rotation) {
            case 0: {
                return 0;
            }
            case 1: {
                return 90;
            }
            case 2: {
                return 180;
            }
            case 3: {
                return 270;
            }
        }
        return 0;
    }

    public static void setCameraDisplayOrientation(Activity activity, int cameraId, Camera camera) {
        int result;
        Camera.CameraInfo info = new Camera.CameraInfo();
        Camera.getCameraInfo((int)cameraId, (Camera.CameraInfo)info);
        int degrees = Util.getDisplayRotation(activity);
        if (info.facing == 1) {
            result = (info.orientation + degrees) % 360;
            result = (360 - result) % 360;
        } else {
            result = (info.orientation - degrees + 360) % 360;
        }
        camera.setDisplayOrientation(result);
    }
}

