/*
 * Decompiled with CFR 0.152.
 */
package com.android.camera;

import android.content.ContentResolver;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.TransitionDrawable;
import android.media.ThumbnailUtils;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import android.util.Log;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.android.camera.MenuHelper;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ThumbnailController {
    private static final String TAG = "ThumbnailController";
    private final ContentResolver mContentResolver;
    private Uri mUri;
    private Bitmap mThumb;
    private final ImageView mButton;
    private Drawable[] mThumbs;
    private TransitionDrawable mThumbTransition;
    private boolean mShouldAnimateThumb;
    private final Resources mResources;
    private static final int BUFSIZE = 4096;

    public ThumbnailController(Resources resources, ImageView button, ContentResolver contentResolver) {
        this.mResources = resources;
        this.mButton = button;
        this.mContentResolver = contentResolver;
    }

    public void setData(Uri uri, Bitmap original) {
        if (uri == null || original == null) {
            uri = null;
            original = null;
        }
        this.mUri = uri;
        this.updateThumb(original);
    }

    public Uri getUri() {
        return this.mUri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean storeData(String filePath) {
        if (this.mUri == null) {
            return false;
        }
        FileOutputStream f = null;
        BufferedOutputStream b = null;
        DataOutputStream d = null;
        try {
            f = new FileOutputStream(filePath);
            b = new BufferedOutputStream(f, 4096);
            d = new DataOutputStream(b);
            d.writeUTF(this.mUri.toString());
            this.mThumb.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)d);
            d.close();
        }
        catch (IOException e) {
            boolean bl;
            try {
                bl = false;
            }
            catch (Throwable throwable) {
                MenuHelper.closeSilently(f);
                MenuHelper.closeSilently(b);
                MenuHelper.closeSilently(d);
                throw throwable;
            }
            MenuHelper.closeSilently(f);
            MenuHelper.closeSilently(b);
            MenuHelper.closeSilently(d);
            return bl;
        }
        MenuHelper.closeSilently(f);
        MenuHelper.closeSilently(b);
        MenuHelper.closeSilently(d);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadData(String filePath) {
        FileInputStream f = null;
        BufferedInputStream b = null;
        DataInputStream d = null;
        try {
            f = new FileInputStream(filePath);
            b = new BufferedInputStream(f, 4096);
            d = new DataInputStream(b);
            Uri uri = Uri.parse((String)d.readUTF());
            Bitmap thumb = BitmapFactory.decodeStream((InputStream)d);
            this.setData(uri, thumb);
            d.close();
        }
        catch (IOException e) {
            boolean bl;
            try {
                bl = false;
            }
            catch (Throwable throwable) {
                MenuHelper.closeSilently(f);
                MenuHelper.closeSilently(b);
                MenuHelper.closeSilently(d);
                throw throwable;
            }
            MenuHelper.closeSilently(f);
            MenuHelper.closeSilently(b);
            MenuHelper.closeSilently(d);
            return bl;
        }
        MenuHelper.closeSilently(f);
        MenuHelper.closeSilently(b);
        MenuHelper.closeSilently(d);
        return true;
    }

    public void updateDisplayIfNeeded() {
        if (this.mUri == null) {
            this.mButton.setImageDrawable(null);
            return;
        }
        if (this.mShouldAnimateThumb) {
            this.mThumbTransition.startTransition(500);
            this.mShouldAnimateThumb = false;
        }
    }

    private void updateThumb(Bitmap original) {
        Drawable drawable2;
        if (original == null) {
            this.mThumb = null;
            this.mThumbs = null;
            return;
        }
        ViewGroup.LayoutParams param = this.mButton.getLayoutParams();
        int miniThumbWidth = param.width - this.mButton.getPaddingLeft() - this.mButton.getPaddingRight();
        int miniThumbHeight = param.height - this.mButton.getPaddingTop() - this.mButton.getPaddingBottom();
        this.mThumb = ThumbnailUtils.extractThumbnail((Bitmap)original, (int)miniThumbWidth, (int)miniThumbHeight);
        if (this.mThumbs == null) {
            this.mThumbs = new Drawable[2];
            this.mThumbs[1] = new BitmapDrawable(this.mResources, this.mThumb);
            drawable2 = this.mThumbs[1];
            this.mShouldAnimateThumb = false;
        } else {
            this.mThumbs[0] = this.mThumbs[1];
            this.mThumbs[1] = new BitmapDrawable(this.mResources, this.mThumb);
            this.mThumbTransition = new TransitionDrawable(this.mThumbs);
            drawable2 = this.mThumbTransition;
            this.mShouldAnimateThumb = true;
        }
        this.mButton.setImageDrawable(drawable2);
    }

    public boolean isUriValid() {
        if (this.mUri == null) {
            return false;
        }
        try {
            ParcelFileDescriptor pfd = this.mContentResolver.openFileDescriptor(this.mUri, "r");
            if (pfd == null) {
                Log.e((String)TAG, (String)"Fail to open URI.");
                return false;
            }
            pfd.close();
        }
        catch (IOException ex) {
            return false;
        }
        return true;
    }
}

