/*
 * Decompiled with CFR 0.152.
 */
package com.android.camera;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.AnimationUtils;
import android.widget.ImageView;

public class Switcher
extends ImageView
implements View.OnTouchListener {
    private static final String TAG = "Switcher";
    private static final int ANIMATION_SPEED = 200;
    private static final long NO_ANIMATION = -1L;
    private boolean mSwitch = false;
    private int mPosition = 0;
    private long mAnimationStartTime = -1L;
    private int mAnimationStartPosition;
    private OnSwitchListener mListener;

    public Switcher(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public void setSwitch(boolean onOff) {
        if (this.mSwitch == onOff) {
            return;
        }
        this.mSwitch = onOff;
        this.invalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryToSetSwitch(boolean onOff) {
        try {
            if (this.mSwitch == onOff) {
                return;
            }
            if (this.mListener != null && !this.mListener.onSwitchChanged(this, onOff)) {
                return;
            }
            this.mSwitch = onOff;
        }
        finally {
            this.startParkingAnimation();
        }
    }

    public void setOnSwitchListener(OnSwitchListener listener) {
        this.mListener = listener;
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.isEnabled()) {
            return false;
        }
        int available = this.getHeight() - this.getPaddingTop() - this.getPaddingBottom() - this.getDrawable().getIntrinsicHeight();
        switch (event.getAction()) {
            case 0: {
                this.mAnimationStartTime = -1L;
                this.setPressed(true);
                this.trackTouchEvent(event);
                break;
            }
            case 2: {
                this.trackTouchEvent(event);
                break;
            }
            case 1: {
                this.trackTouchEvent(event);
                this.tryToSetSwitch(this.mPosition >= available / 2);
                this.setPressed(false);
                break;
            }
            case 3: {
                this.tryToSetSwitch(this.mSwitch);
                this.setPressed(false);
            }
        }
        return true;
    }

    private void startParkingAnimation() {
        this.mAnimationStartTime = AnimationUtils.currentAnimationTimeMillis();
        this.mAnimationStartPosition = this.mPosition;
    }

    private void trackTouchEvent(MotionEvent event) {
        Drawable drawable2 = this.getDrawable();
        int drawableHeight = drawable2.getIntrinsicHeight();
        int height = this.getHeight();
        int available = height - this.getPaddingTop() - this.getPaddingBottom() - drawableHeight;
        int x = (int)event.getY();
        this.mPosition = x - this.getPaddingTop() - drawableHeight / 2;
        if (this.mPosition < 0) {
            this.mPosition = 0;
        }
        if (this.mPosition > available) {
            this.mPosition = available;
        }
        this.invalidate();
    }

    protected void onDraw(Canvas canvas) {
        Drawable drawable2 = this.getDrawable();
        int drawableHeight = drawable2.getIntrinsicHeight();
        int drawableWidth = drawable2.getIntrinsicWidth();
        if (drawableWidth == 0 || drawableHeight == 0) {
            return;
        }
        int available = this.getHeight() - this.getPaddingTop() - this.getPaddingBottom() - drawableHeight;
        if (this.mAnimationStartTime != -1L) {
            boolean done;
            long time = AnimationUtils.currentAnimationTimeMillis();
            int deltaTime = (int)(time - this.mAnimationStartTime);
            this.mPosition = this.mAnimationStartPosition + 200 * (this.mSwitch ? deltaTime : -deltaTime) / 1000;
            if (this.mPosition < 0) {
                this.mPosition = 0;
            }
            if (this.mPosition > available) {
                this.mPosition = available;
            }
            boolean bl = done = this.mPosition == (this.mSwitch ? available : 0);
            if (!done) {
                this.invalidate();
            } else {
                this.mAnimationStartTime = -1L;
            }
        } else if (!this.isPressed()) {
            this.mPosition = this.mSwitch ? available : 0;
        }
        int offsetTop = this.getPaddingTop() + this.mPosition;
        int offsetLeft = (this.getWidth() - drawableWidth - this.getPaddingLeft() - this.getPaddingRight()) / 2;
        int saveCount = canvas.getSaveCount();
        canvas.save();
        canvas.translate((float)offsetLeft, (float)offsetTop);
        drawable2.draw(canvas);
        canvas.restoreToCount(saveCount);
    }

    public void addTouchView(View v) {
        v.setOnTouchListener((View.OnTouchListener)this);
    }

    public boolean onTouch(View v, MotionEvent event) {
        this.onTouchEvent(event);
        return true;
    }

    public static interface OnSwitchListener {
        public boolean onSwitchChanged(Switcher var1, boolean var2);
    }
}

