/*
 * Decompiled with CFR 0.152.
 */
package com.android.camera;

import android.content.Context;
import android.util.AttributeSet;
import android.widget.ImageView;

public class ShutterButton
extends ImageView {
    private OnShutterButtonListener mListener;
    private boolean mOldPressed;

    public ShutterButton(Context context) {
        super(context);
    }

    public ShutterButton(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public ShutterButton(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public void setOnShutterButtonListener(OnShutterButtonListener listener) {
        this.mListener = listener;
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        final boolean pressed = this.isPressed();
        if (pressed != this.mOldPressed) {
            if (!pressed) {
                this.post(new Runnable(){

                    public void run() {
                        ShutterButton.this.callShutterButtonFocus(pressed);
                    }
                });
            } else {
                this.callShutterButtonFocus(pressed);
            }
            this.mOldPressed = pressed;
        }
    }

    private void callShutterButtonFocus(boolean pressed) {
        if (this.mListener != null) {
            this.mListener.onShutterButtonFocus(this, pressed);
        }
    }

    public boolean performClick() {
        boolean result = super.performClick();
        if (this.mListener != null) {
            this.mListener.onShutterButtonClick(this);
        }
        return result;
    }

    public static interface OnShutterButtonListener {
        public void onShutterButtonFocus(ShutterButton var1, boolean var2);

        public void onShutterButtonClick(ShutterButton var1);
    }
}

