/*
 * Decompiled with CFR 0.152.
 */
package com.android.camera;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.animation.AnimationUtils;
import android.widget.ImageView;

public class RotateImageView
extends ImageView {
    private static final String TAG = "RotateImageView";
    private static final int ANIMATION_SPEED = 180;
    private int mCurrentDegree = 0;
    private int mStartDegree = 0;
    private int mTargetDegree = 0;
    private boolean mClockwise = false;
    private long mAnimationStartTime = 0L;
    private long mAnimationEndTime = 0L;

    public RotateImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public void setDegree(int degree) {
        int n = degree = degree >= 0 ? degree % 360 : degree % 360 + 360;
        if (degree == this.mTargetDegree) {
            return;
        }
        this.mTargetDegree = degree;
        this.mStartDegree = this.mCurrentDegree;
        this.mAnimationStartTime = AnimationUtils.currentAnimationTimeMillis();
        int diff = this.mTargetDegree - this.mCurrentDegree;
        diff = diff >= 0 ? diff : 360 + diff;
        diff = diff > 180 ? diff - 360 : diff;
        this.mClockwise = diff >= 0;
        this.mAnimationEndTime = this.mAnimationStartTime + (long)(Math.abs(diff) * 1000 / 180);
        this.invalidate();
    }

    protected void onDraw(Canvas canvas) {
        Drawable drawable2 = this.getDrawable();
        if (drawable2 == null) {
            return;
        }
        Rect bounds = drawable2.getBounds();
        int w = bounds.right - bounds.left;
        int h = bounds.bottom - bounds.top;
        if (w == 0 || h == 0) {
            return;
        }
        if (this.mCurrentDegree != this.mTargetDegree) {
            long time = AnimationUtils.currentAnimationTimeMillis();
            if (time < this.mAnimationEndTime) {
                int deltaTime = (int)(time - this.mAnimationStartTime);
                int degree = this.mStartDegree + 180 * (this.mClockwise ? deltaTime : -deltaTime) / 1000;
                this.mCurrentDegree = degree = degree >= 0 ? degree % 360 : degree % 360 + 360;
                this.invalidate();
            } else {
                this.mCurrentDegree = this.mTargetDegree;
            }
        }
        int left = this.getPaddingLeft();
        int top = this.getPaddingTop();
        int right = this.getPaddingRight();
        int bottom = this.getPaddingBottom();
        int width = this.getWidth() - left - right;
        int height = this.getHeight() - top - bottom;
        int saveCount = canvas.getSaveCount();
        canvas.translate((float)(left + width / 2), (float)(top + height / 2));
        canvas.rotate((float)(-this.mCurrentDegree));
        canvas.translate((float)(-w / 2), (float)(-h / 2));
        drawable2.draw(canvas);
        canvas.restoreToCount(saveCount);
    }
}

