/*
 * Decompiled with CFR 0.152.
 */
package com.android.camera;

import android.content.Context;
import android.os.Handler;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.TextView;

public class OnScreenHint {
    static final String TAG = "OnScreenHint";
    static final boolean LOCAL_LOGV = false;
    int mGravity = 81;
    int mX;
    int mY;
    float mHorizontalMargin;
    float mVerticalMargin;
    View mView;
    View mNextView;
    private final WindowManager.LayoutParams mParams = new WindowManager.LayoutParams();
    private final WindowManager mWM;
    private final Handler mHandler = new Handler();
    private final Runnable mShow = new Runnable(){

        public void run() {
            OnScreenHint.this.handleShow();
        }
    };
    private final Runnable mHide = new Runnable(){

        public void run() {
            OnScreenHint.this.handleHide();
        }
    };

    public OnScreenHint(Context context) {
        this.mWM = (WindowManager)context.getSystemService("window");
        this.mY = context.getResources().getDimensionPixelSize(2131230720);
        this.mParams.height = -2;
        this.mParams.width = -2;
        this.mParams.flags = 24;
        this.mParams.format = -3;
        this.mParams.windowAnimations = 2131361794;
        this.mParams.type = 1000;
        this.mParams.setTitle((CharSequence)TAG);
    }

    public void show() {
        if (this.mNextView == null) {
            throw new RuntimeException("setView must have been called");
        }
        this.mHandler.post(this.mShow);
    }

    public void cancel() {
        this.mHandler.post(this.mHide);
    }

    public static OnScreenHint makeText(Context context, CharSequence text) {
        OnScreenHint result = new OnScreenHint(context);
        LayoutInflater inflate = (LayoutInflater)context.getSystemService("layout_inflater");
        View v = inflate.inflate(2130903043, null);
        TextView tv = (TextView)v.findViewById(2131427344);
        tv.setText(text);
        result.mNextView = v;
        return result;
    }

    public void setText(CharSequence s) {
        if (this.mNextView == null) {
            throw new RuntimeException("This OnScreenHint was not created with OnScreenHint.makeText()");
        }
        TextView tv = (TextView)this.mNextView.findViewById(2131427344);
        if (tv == null) {
            throw new RuntimeException("This OnScreenHint was not created with OnScreenHint.makeText()");
        }
        tv.setText(s);
    }

    private synchronized void handleShow() {
        if (this.mView != this.mNextView) {
            int gravity;
            this.handleHide();
            this.mView = this.mNextView;
            this.mParams.gravity = gravity = this.mGravity;
            if ((gravity & 7) == 7) {
                this.mParams.horizontalWeight = 1.0f;
            }
            if ((gravity & 0x70) == 112) {
                this.mParams.verticalWeight = 1.0f;
            }
            this.mParams.x = this.mX;
            this.mParams.y = this.mY;
            this.mParams.verticalMargin = this.mVerticalMargin;
            this.mParams.horizontalMargin = this.mHorizontalMargin;
            if (this.mView.getParent() != null) {
                this.mWM.removeView(this.mView);
            }
            this.mWM.addView(this.mView, (ViewGroup.LayoutParams)this.mParams);
        }
    }

    private synchronized void handleHide() {
        if (this.mView != null) {
            if (this.mView.getParent() != null) {
                this.mWM.removeView(this.mView);
            }
            this.mView = null;
        }
    }
}

