/*
 * Decompiled with CFR 0.152.
 */
package com.android.camera;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.os.Environment;
import android.os.StatFs;
import android.provider.MediaStore;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import com.android.camera.CameraHolder;
import com.android.camera.ImageManager;
import java.io.Closeable;

public class MenuHelper {
    private static final String TAG = "MenuHelper";
    public static final int INCLUDE_ALL = -1;
    public static final int INCLUDE_VIEWPLAY_MENU = 1;
    public static final int INCLUDE_SHARE_MENU = 2;
    public static final int INCLUDE_SET_MENU = 4;
    public static final int INCLUDE_CROP_MENU = 8;
    public static final int INCLUDE_DELETE_MENU = 16;
    public static final int INCLUDE_ROTATE_MENU = 32;
    public static final int INCLUDE_DETAILS_MENU = 64;
    public static final int INCLUDE_SHOWMAP_MENU = 128;
    public static final int MENU_IMAGE_SHARE = 1;
    public static final int MENU_IMAGE_SHOWMAP = 2;
    public static final int POSITION_SWITCH_CAMERA_MODE = 1;
    public static final int POSITION_GOTO_GALLERY = 2;
    public static final int POSITION_SWITCH_CAMERA_ID = 3;
    public static final int NO_STORAGE_ERROR = -1;
    public static final int CANNOT_STAT_ERROR = -2;
    public static final String EMPTY_STRING = "";
    public static final String JPEG_MIME_TYPE = "image/jpeg";
    public static final float INVALID_LATLNG = 255.0f;
    public static final int RESULT_COMMON_MENU_CROP = 490;
    private static final int NO_ANIMATION = 0;
    private static final String CAMERA_CLASS = "com.android.camera.Camera";
    private static final String VIDEO_CAMERA_CLASS = "com.android.camera.VideoCamera";

    public static void closeSilently(Closeable c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void confirmAction(Context context, String title, String message, final Runnable action) {
        DialogInterface.OnClickListener listener = new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                switch (which) {
                    case -1: {
                        if (action == null) break;
                        action.run();
                    }
                }
            }
        };
        new AlertDialog.Builder(context).setIcon(17301543).setTitle((CharSequence)title).setMessage((CharSequence)message).setPositiveButton(17039370, listener).setNegativeButton(0x1040000, listener).create().show();
    }

    static void addSwitchModeMenuItem(Menu menu, boolean switchToVideo, final Runnable r) {
        int labelId = switchToVideo ? 2131296363 : 2131296362;
        int iconId = switchToVideo ? 2130837536 : 17301559;
        MenuItem item = menu.add(0, 0, 1, labelId).setOnMenuItemClickListener(new MenuItem.OnMenuItemClickListener(){

            public boolean onMenuItemClick(MenuItem item) {
                r.run();
                return true;
            }
        });
        item.setIcon(iconId);
    }

    private static void startCameraActivity(Activity activity, String action, String className) {
        Intent intent = new Intent(action);
        intent.addFlags(0x4000000);
        intent.addFlags(0x2000000);
        intent.setClassName(activity.getPackageName(), className);
        CameraHolder.instance().keep();
        try {
            activity.startActivity(intent);
        }
        catch (ActivityNotFoundException e) {
            intent.setComponent(null);
            activity.startActivity(intent);
        }
        activity.overridePendingTransition(0, 0);
    }

    public static void gotoVideoMode(Activity activity) {
        MenuHelper.startCameraActivity(activity, "android.media.action.VIDEO_CAMERA", VIDEO_CAMERA_CLASS);
    }

    public static void gotoCameraMode(Activity activity) {
        MenuHelper.startCameraActivity(activity, "android.media.action.STILL_IMAGE_CAMERA", CAMERA_CLASS);
    }

    public static void gotoCameraImageGallery(Activity activity) {
        MenuHelper.gotoGallery(activity, 2131296260, 1);
    }

    public static void gotoCameraVideoGallery(Activity activity) {
        MenuHelper.gotoGallery(activity, 2131296261, 4);
    }

    private static void gotoGallery(Activity activity, int windowTitleId, int mediaTypes) {
        Uri target = MediaStore.Images.Media.EXTERNAL_CONTENT_URI.buildUpon().appendQueryParameter("bucketId", ImageManager.CAMERA_IMAGE_BUCKET_ID).build();
        Intent intent = new Intent("android.intent.action.VIEW", target);
        intent.addFlags(0x4000000);
        intent.putExtra("windowTitle", activity.getString(windowTitleId));
        intent.putExtra("mediaTypes", mediaTypes);
        try {
            activity.startActivity(intent);
        }
        catch (ActivityNotFoundException e) {
            Log.e((String)TAG, (String)"Could not start gallery activity", (Throwable)e);
        }
    }

    public static int calculatePicturesRemaining() {
        try {
            if (!ImageManager.hasStorage()) {
                return -1;
            }
            String storageDirectory = Environment.getExternalStorageDirectory().toString();
            StatFs stat = new StatFs(storageDirectory);
            int PICTURE_BYTES = 1500000;
            float remaining = (float)stat.getAvailableBlocks() * (float)stat.getBlockSize() / 1500000.0f;
            return (int)remaining;
        }
        catch (Exception ex) {
            Log.e((String)TAG, (String)"Fail to access sdcard", (Throwable)ex);
            return -2;
        }
    }
}

