/*
 * Decompiled with CFR 0.152.
 */
package com.android.camera;

import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;
import android.hardware.Camera;
import android.media.CamcorderProfile;
import android.util.Log;
import com.android.camera.CameraPreference;
import com.android.camera.ComboPreferences;
import com.android.camera.IconListPreference;
import com.android.camera.ListPreference;
import com.android.camera.PreferenceGroup;
import com.android.camera.PreferenceInflater;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CameraSettings {
    private static final int NOT_FOUND = -1;
    public static final String KEY_VERSION = "pref_version_key";
    public static final String KEY_LOCAL_VERSION = "pref_local_version_key";
    public static final String KEY_RECORD_LOCATION = "pref_camera_recordlocation_key";
    public static final String KEY_VIDEO_QUALITY = "pref_video_quality_key";
    public static final String KEY_PICTURE_SIZE = "pref_camera_picturesize_key";
    public static final String KEY_JPEG_QUALITY = "pref_camera_jpegquality_key";
    public static final String KEY_FOCUS_MODE = "pref_camera_focusmode_key";
    public static final String KEY_FLASH_MODE = "pref_camera_flashmode_key";
    public static final String KEY_VIDEOCAMERA_FLASH_MODE = "pref_camera_video_flashmode_key";
    public static final String KEY_COLOR_EFFECT = "pref_camera_coloreffect_key";
    public static final String KEY_WHITE_BALANCE = "pref_camera_whitebalance_key";
    public static final String KEY_SCENE_MODE = "pref_camera_scenemode_key";
    public static final String KEY_EXPOSURE = "pref_camera_exposure_key";
    public static final String KEY_CAMERA_ID = "pref_camera_id_key";
    private static final String VIDEO_QUALITY_HIGH = "high";
    private static final String VIDEO_QUALITY_MMS = "mms";
    private static final String VIDEO_QUALITY_YOUTUBE = "youtube";
    public static final String EXPOSURE_DEFAULT_VALUE = "0";
    public static final int CURRENT_VERSION = 4;
    public static final int CURRENT_LOCAL_VERSION = 1;
    private static final int MMS_VIDEO_DURATION = CamcorderProfile.get((int)0).duration;
    private static final int YOUTUBE_VIDEO_DURATION = 600;
    private static final int DEFAULT_VIDEO_DURATION = 1800;
    public static final String DEFAULT_VIDEO_QUALITY_VALUE = "high";
    public static final int DEFAULT_VIDEO_DURATION_VALUE = -1;
    private static final String TAG = "CameraSettings";
    private final Context mContext;
    private final Camera.Parameters mParameters;
    private final Camera.CameraInfo[] mCameraInfo;

    public CameraSettings(Activity activity, Camera.Parameters parameters, Camera.CameraInfo[] cameraInfo) {
        this.mContext = activity;
        this.mParameters = parameters;
        this.mCameraInfo = cameraInfo;
    }

    public PreferenceGroup getPreferenceGroup(int preferenceRes) {
        PreferenceInflater inflater = new PreferenceInflater(this.mContext);
        PreferenceGroup group = (PreferenceGroup)inflater.inflate(preferenceRes);
        this.initPreference(group);
        return group;
    }

    public static void initialCameraPictureSize(Context context, Camera.Parameters parameters) {
        List supported = parameters.getSupportedPictureSizes();
        if (supported == null) {
            return;
        }
        for (String candidate : context.getResources().getStringArray(2131099652)) {
            if (!CameraSettings.setCameraPictureSize(candidate, supported, parameters)) continue;
            SharedPreferences.Editor editor = ComboPreferences.get(context).edit();
            editor.putString(KEY_PICTURE_SIZE, candidate);
            editor.apply();
            return;
        }
        Log.e((String)TAG, (String)"No supported picture size found");
    }

    public static void removePreferenceFromScreen(PreferenceGroup group, String key) {
        CameraSettings.removePreference(group, key);
    }

    public static boolean setCameraPictureSize(String candidate, List<Camera.Size> supported, Camera.Parameters parameters) {
        int index = candidate.indexOf(120);
        if (index == -1) {
            return false;
        }
        int width = Integer.parseInt(candidate.substring(0, index));
        int height = Integer.parseInt(candidate.substring(index + 1));
        for (Camera.Size size : supported) {
            if (size.width != width || size.height != height) continue;
            parameters.setPictureSize(width, height);
            return true;
        }
        return false;
    }

    private void initPreference(PreferenceGroup group) {
        ListPreference videoQuality = group.findPreference(KEY_VIDEO_QUALITY);
        ListPreference pictureSize = group.findPreference(KEY_PICTURE_SIZE);
        ListPreference whiteBalance = group.findPreference(KEY_WHITE_BALANCE);
        ListPreference colorEffect = group.findPreference(KEY_COLOR_EFFECT);
        ListPreference sceneMode = group.findPreference(KEY_SCENE_MODE);
        ListPreference flashMode = group.findPreference(KEY_FLASH_MODE);
        ListPreference focusMode = group.findPreference(KEY_FOCUS_MODE);
        ListPreference exposure = group.findPreference(KEY_EXPOSURE);
        IconListPreference cameraId = (IconListPreference)group.findPreference(KEY_CAMERA_ID);
        ListPreference videoFlashMode = group.findPreference(KEY_VIDEOCAMERA_FLASH_MODE);
        if (videoQuality != null) {
            CharSequence[] entries = videoQuality.getEntries();
            CharSequence[] values = videoQuality.getEntryValues();
            for (int i = 0; i < entries.length; ++i) {
                if (!VIDEO_QUALITY_MMS.equals(values[i])) continue;
                entries[i] = ((Object)entries[i]).toString().replace("30", Integer.toString(MMS_VIDEO_DURATION));
                break;
            }
        }
        if (pictureSize != null) {
            this.filterUnsupportedOptions(group, pictureSize, CameraSettings.sizeListToStringList(this.mParameters.getSupportedPictureSizes()));
        }
        if (whiteBalance != null) {
            this.filterUnsupportedOptions(group, whiteBalance, this.mParameters.getSupportedWhiteBalance());
        }
        if (colorEffect != null) {
            this.filterUnsupportedOptions(group, colorEffect, this.mParameters.getSupportedColorEffects());
        }
        if (sceneMode != null) {
            this.filterUnsupportedOptions(group, sceneMode, this.mParameters.getSupportedSceneModes());
        }
        if (flashMode != null) {
            this.filterUnsupportedOptions(group, flashMode, this.mParameters.getSupportedFlashModes());
        }
        if (focusMode != null) {
            this.filterUnsupportedOptions(group, focusMode, this.mParameters.getSupportedFocusModes());
        }
        if (videoFlashMode != null) {
            this.filterUnsupportedOptions(group, videoFlashMode, this.mParameters.getSupportedFlashModes());
        }
        if (exposure != null) {
            this.buildExposureCompensation(group, exposure);
        }
        if (cameraId != null) {
            this.buildCameraId(group, cameraId);
        }
    }

    private void buildExposureCompensation(PreferenceGroup group, ListPreference exposure) {
        int max = this.mParameters.getMaxExposureCompensation();
        int min = this.mParameters.getMinExposureCompensation();
        if (max == 0 && min == 0) {
            CameraSettings.removePreference(group, exposure.getKey());
            return;
        }
        float step = this.mParameters.getExposureCompensationStep();
        int maxValue = (int)Math.floor((float)max * step);
        int minValue = (int)Math.ceil((float)min * step);
        CharSequence[] entries = new CharSequence[maxValue - minValue + 1];
        CharSequence[] entryValues = new CharSequence[maxValue - minValue + 1];
        for (int i = minValue; i <= maxValue; ++i) {
            entryValues[maxValue - i] = Integer.toString(Math.round((float)i / step));
            StringBuilder builder = new StringBuilder();
            if (i > 0) {
                builder.append('+');
            }
            entries[maxValue - i] = builder.append(i).toString();
        }
        exposure.setEntries(entries);
        exposure.setEntryValues(entryValues);
    }

    private void buildCameraId(PreferenceGroup group, IconListPreference cameraId) {
        int numOfCameras = this.mCameraInfo.length;
        if (numOfCameras < 2) {
            CameraSettings.removePreference(group, cameraId.getKey());
            return;
        }
        CharSequence[] entries = new CharSequence[numOfCameras];
        CharSequence[] entryValues = new CharSequence[numOfCameras];
        int[] iconIds = new int[numOfCameras];
        int[] largeIconIds = new int[numOfCameras];
        for (int i = 0; i < numOfCameras; ++i) {
            entryValues[i] = Integer.toString(i);
            if (this.mCameraInfo[i].facing == 1) {
                entries[i] = this.mContext.getString(2131296278);
                iconIds[i] = 2130837539;
                largeIconIds[i] = 2130837554;
                continue;
            }
            entries[i] = this.mContext.getString(2131296277);
            iconIds[i] = 2130837538;
            largeIconIds[i] = 2130837553;
        }
        cameraId.setEntries(entries);
        cameraId.setEntryValues(entryValues);
        cameraId.setIconIds(iconIds);
        cameraId.setLargeIconIds(largeIconIds);
    }

    private static boolean removePreference(PreferenceGroup group, String key) {
        int n = group.size();
        for (int i = 0; i < n; ++i) {
            CameraPreference child = group.get(i);
            if (child instanceof PreferenceGroup && CameraSettings.removePreference((PreferenceGroup)child, key)) {
                return true;
            }
            if (!(child instanceof ListPreference) || !((ListPreference)child).getKey().equals(key)) continue;
            group.removePreference(i);
            return true;
        }
        return false;
    }

    private void filterUnsupportedOptions(PreferenceGroup group, ListPreference pref, List<String> supported) {
        CharSequence[] allEntries = pref.getEntries();
        if (supported == null || supported.size() <= 1) {
            CameraSettings.removePreference(group, pref.getKey());
            return;
        }
        pref.filterUnsupported(supported);
        if (pref.getEntries().length <= 1) {
            CameraSettings.removePreference(group, pref.getKey());
            return;
        }
        String value = pref.getValue();
        if (pref.findIndexOfValue(value) == -1) {
            pref.setValueIndex(0);
        }
    }

    private static List<String> sizeListToStringList(List<Camera.Size> sizes) {
        ArrayList<String> list = new ArrayList<String>();
        for (Camera.Size size : sizes) {
            list.add(String.format("%dx%d", size.width, size.height));
        }
        return list;
    }

    public static void upgradeLocalPreferences(SharedPreferences pref) {
        int version;
        try {
            version = pref.getInt(KEY_LOCAL_VERSION, 0);
        }
        catch (Exception ex) {
            version = 0;
        }
        if (version == 1) {
            return;
        }
        SharedPreferences.Editor editor = pref.edit();
        editor.putInt(KEY_LOCAL_VERSION, 1);
        editor.apply();
    }

    public static void upgradeGlobalPreferences(SharedPreferences pref) {
        int version;
        try {
            version = pref.getInt(KEY_VERSION, 0);
        }
        catch (Exception ex) {
            version = 0;
        }
        if (version == 4) {
            return;
        }
        SharedPreferences.Editor editor = pref.edit();
        if (version == 0) {
            version = 1;
        }
        if (version == 1) {
            String quality = pref.getString(KEY_JPEG_QUALITY, "85");
            quality = quality.equals("65") ? "normal" : (quality.equals("75") ? "fine" : "superfine");
            editor.putString(KEY_JPEG_QUALITY, quality);
            version = 2;
        }
        if (version == 2) {
            editor.putString(KEY_RECORD_LOCATION, pref.getBoolean(KEY_RECORD_LOCATION, false) ? "on" : "none");
            version = 3;
        }
        if (version == 3) {
            editor.remove("pref_camera_videoquality_key");
            editor.remove("pref_camera_video_duration_key");
        }
        editor.putInt(KEY_VERSION, 4);
        editor.apply();
    }

    public static void upgradeAllPreferences(ComboPreferences pref) {
        CameraSettings.upgradeGlobalPreferences(pref.getGlobal());
        CameraSettings.upgradeLocalPreferences(pref.getLocal());
    }

    public static boolean getVideoQuality(String quality) {
        return VIDEO_QUALITY_YOUTUBE.equals(quality) || "high".equals(quality);
    }

    public static int getVidoeDurationInMillis(String quality) {
        if (VIDEO_QUALITY_MMS.equals(quality)) {
            return MMS_VIDEO_DURATION * 1000;
        }
        if (VIDEO_QUALITY_YOUTUBE.equals(quality)) {
            return 600000;
        }
        return 1800000;
    }

    public static int readPreferredCameraId(SharedPreferences pref) {
        return Integer.parseInt(pref.getString(KEY_CAMERA_ID, EXPOSURE_DEFAULT_VALUE));
    }

    public static void writePreferredCameraId(SharedPreferences pref, int cameraId) {
        SharedPreferences.Editor editor = pref.edit();
        editor.putString(KEY_CAMERA_ID, Integer.toString(cameraId));
        editor.apply();
    }
}

