/*
 * Decompiled with CFR 0.152.
 */
package com.android.camera;

import android.hardware.Camera;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import com.android.camera.CameraHardwareException;
import com.android.camera.Util;
import java.io.IOException;

public class CameraHolder {
    private static final String TAG = "CameraHolder";
    private Camera mCameraDevice;
    private long mKeepBeforeTime = 0L;
    private final Handler mHandler;
    private int mUsers = 0;
    private int mNumberOfCameras;
    private int mCameraId = -1;
    private Camera.CameraInfo[] mInfo;
    private Camera.Parameters mParameters;
    private static CameraHolder sHolder;
    private static final int RELEASE_CAMERA = 1;

    public static synchronized CameraHolder instance() {
        if (sHolder == null) {
            sHolder = new CameraHolder();
        }
        return sHolder;
    }

    private CameraHolder() {
        HandlerThread ht = new HandlerThread(TAG);
        ht.start();
        this.mHandler = new MyHandler(ht.getLooper());
        this.mNumberOfCameras = Camera.getNumberOfCameras();
        this.mInfo = new Camera.CameraInfo[this.mNumberOfCameras];
        for (int i = 0; i < this.mNumberOfCameras; ++i) {
            this.mInfo[i] = new Camera.CameraInfo();
            Camera.getCameraInfo((int)i, (Camera.CameraInfo)this.mInfo[i]);
        }
    }

    public int getNumberOfCameras() {
        return this.mNumberOfCameras;
    }

    public Camera.CameraInfo[] getCameraInfo() {
        return this.mInfo;
    }

    public synchronized Camera open(int cameraId) throws CameraHardwareException {
        Util.Assert(this.mUsers == 0);
        if (this.mCameraDevice != null && this.mCameraId != cameraId) {
            this.mCameraDevice.release();
            this.mCameraDevice = null;
            this.mCameraId = -1;
        }
        if (this.mCameraDevice == null) {
            try {
                Log.v((String)TAG, (String)("open camera " + cameraId));
                this.mCameraDevice = Camera.open((int)cameraId);
                this.mCameraId = cameraId;
            }
            catch (RuntimeException e) {
                Log.e((String)TAG, (String)"fail to connect Camera", (Throwable)e);
                throw new CameraHardwareException(e);
            }
            this.mParameters = this.mCameraDevice.getParameters();
        } else {
            try {
                this.mCameraDevice.reconnect();
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)"reconnect failed.");
                throw new CameraHardwareException(e);
            }
            this.mCameraDevice.setParameters(this.mParameters);
        }
        ++this.mUsers;
        this.mHandler.removeMessages(1);
        this.mKeepBeforeTime = 0L;
        return this.mCameraDevice;
    }

    public synchronized Camera tryOpen(int cameraId) {
        try {
            return this.mUsers == 0 ? this.open(cameraId) : null;
        }
        catch (CameraHardwareException e) {
            if ("eng".equals(Build.TYPE)) {
                throw new RuntimeException(e);
            }
            return null;
        }
    }

    public synchronized void release() {
        Util.Assert(this.mUsers == 1);
        --this.mUsers;
        this.mCameraDevice.stopPreview();
        this.releaseCamera();
    }

    private synchronized void releaseCamera() {
        Util.Assert(this.mUsers == 0);
        Util.Assert(this.mCameraDevice != null);
        long now = System.currentTimeMillis();
        if (now < this.mKeepBeforeTime) {
            this.mHandler.sendEmptyMessageDelayed(1, this.mKeepBeforeTime - now);
            return;
        }
        this.mCameraDevice.release();
        this.mCameraDevice = null;
        this.mCameraId = -1;
    }

    public synchronized void keep() {
        Util.Assert(this.mUsers == 1 || this.mUsers == 0);
        this.mKeepBeforeTime = System.currentTimeMillis() + 3000L;
    }

    private class MyHandler
    extends Handler {
        MyHandler(Looper looper) {
            super(looper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    CameraHolder cameraHolder = CameraHolder.this;
                    synchronized (cameraHolder) {
                        if (CameraHolder.this.mUsers == 0) {
                            CameraHolder.this.releaseCamera();
                        }
                        break;
                    }
                }
            }
        }
    }
}

