/*
 * Decompiled with CFR 0.152.
 */
package com.android.camera;

import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.ContentProviderClient;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.hardware.Camera;
import android.location.Location;
import android.location.LocationManager;
import android.media.ToneGenerator;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.MessageQueue;
import android.os.Parcelable;
import android.provider.Settings;
import android.util.Log;
import android.view.Display;
import android.view.GestureDetector;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.OrientationEventListener;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.ImageView;
import com.android.camera.CameraHardwareException;
import com.android.camera.CameraHolder;
import com.android.camera.CameraSettings;
import com.android.camera.ComboPreferences;
import com.android.camera.FocusRectangle;
import com.android.camera.ImageManager;
import com.android.camera.JpegEncodingQualityMappings;
import com.android.camera.MenuHelper;
import com.android.camera.NoSearchActivity;
import com.android.camera.OnScreenHint;
import com.android.camera.PreviewFrameLayout;
import com.android.camera.RecordLocationPreference;
import com.android.camera.RotateImageView;
import com.android.camera.ShutterButton;
import com.android.camera.Switcher;
import com.android.camera.ThumbnailController;
import com.android.camera.Util;
import com.android.camera.gallery.IImage;
import com.android.camera.gallery.IImageList;
import com.android.camera.ui.CameraHeadUpDisplay;
import com.android.camera.ui.GLRootView;
import com.android.camera.ui.HeadUpDisplay;
import com.android.camera.ui.ZoomControllerListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Camera
extends NoSearchActivity
implements View.OnClickListener,
ShutterButton.OnShutterButtonListener,
SurfaceHolder.Callback,
Switcher.OnSwitchListener {
    private static final String TAG = "camera";
    private static final int CROP_MSG = 1;
    private static final int FIRST_TIME_INIT = 2;
    private static final int RESTART_PREVIEW = 3;
    private static final int CLEAR_SCREEN_DELAY = 4;
    private static final int SET_CAMERA_PARAMETERS_WHEN_IDLE = 5;
    private static final int UPDATE_PARAM_INITIALIZE = 1;
    private static final int UPDATE_PARAM_ZOOM = 2;
    private static final int UPDATE_PARAM_PREFERENCE = 4;
    private static final int UPDATE_PARAM_ALL = -1;
    private int mUpdateSet;
    private static final float DEFAULT_CAMERA_BRIGHTNESS = 0.7f;
    private static final int SCREEN_DELAY = 120000;
    private static final int FOCUS_BEEP_VOLUME = 100;
    private static final int ZOOM_STOPPED = 0;
    private static final int ZOOM_START = 1;
    private static final int ZOOM_STOPPING = 2;
    private int mZoomState = 0;
    private boolean mSmoothZoomSupported = false;
    private int mZoomValue;
    private int mZoomMax;
    private int mTargetZoomValue;
    private Camera.Parameters mParameters;
    private Camera.Parameters mInitialParams;
    private MyOrientationEventListener mOrientationListener;
    private int mOrientation = -1;
    private int mOrientationCompensation = 0;
    private ComboPreferences mPreferences;
    private static final int IDLE = 1;
    private static final int SNAPSHOT_IN_PROGRESS = 2;
    private static final boolean SWITCH_CAMERA = true;
    private static final boolean SWITCH_VIDEO = false;
    private int mStatus = 1;
    private static final String sTempCropFilename = "crop-temp";
    private android.hardware.Camera mCameraDevice;
    private ContentProviderClient mMediaProviderClient;
    private SurfaceView mSurfaceView;
    private SurfaceHolder mSurfaceHolder = null;
    private ShutterButton mShutterButton;
    private FocusRectangle mFocusRectangle;
    private ToneGenerator mFocusToneGenerator;
    private GestureDetector mGestureDetector;
    private Switcher mSwitcher;
    private boolean mStartPreviewFail = false;
    private GLRootView mGLRootView;
    private ImageView mLastPictureButton;
    private ThumbnailController mThumbController;
    private String mCropValue;
    private Uri mSaveUri;
    private ImageCapture mImageCapture = null;
    private boolean mPreviewing;
    private boolean mPausing;
    private boolean mFirstTimeInitialized;
    private boolean mIsImageCaptureIntent;
    private boolean mRecordLocation;
    private static final int FOCUS_NOT_STARTED = 0;
    private static final int FOCUSING = 1;
    private static final int FOCUSING_SNAP_ON_FINISH = 2;
    private static final int FOCUS_SUCCESS = 3;
    private static final int FOCUS_FAIL = 4;
    private int mFocusState = 0;
    private ContentResolver mContentResolver;
    private boolean mDidRegister = false;
    private final ArrayList<MenuItem> mGalleryItems = new ArrayList();
    private LocationManager mLocationManager = null;
    private final ShutterCallback mShutterCallback = new ShutterCallback();
    private final PostViewPictureCallback mPostViewPictureCallback = new PostViewPictureCallback();
    private final RawPictureCallback mRawPictureCallback = new RawPictureCallback();
    private final AutoFocusCallback mAutoFocusCallback = new AutoFocusCallback();
    private final ZoomListener mZoomListener = new ZoomListener();
    private final ErrorCallback mErrorCallback = new ErrorCallback();
    private long mFocusStartTime;
    private long mFocusCallbackTime;
    private long mCaptureStartTime;
    private long mShutterCallbackTime;
    private long mPostViewPictureCallbackTime;
    private long mRawPictureCallbackTime;
    private long mJpegPictureCallbackTime;
    private int mPicturesRemaining;
    public long mAutoFocusTime;
    public long mShutterLag;
    public long mShutterToPictureDisplayedTime;
    public long mPictureDisplayedToJpegCallbackTime;
    public long mJpegCallbackFinishTime;
    public static boolean mMediaServerDied = false;
    private String mFocusMode;
    private String mSceneMode;
    private final Handler mHandler = new MainHandler();
    private CameraHeadUpDisplay mHeadUpDisplay;
    private int mNumberOfCameras;
    private int mCameraId;
    LocationListener[] mLocationListeners = new LocationListener[]{new LocationListener("gps"), new LocationListener("network")};
    private final BroadcastReceiver mReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (action.equals("android.intent.action.MEDIA_MOUNTED") || action.equals("android.intent.action.MEDIA_UNMOUNTED") || action.equals("android.intent.action.MEDIA_CHECKING")) {
                Camera.this.checkStorage();
            } else if (action.equals("android.intent.action.MEDIA_SCANNER_FINISHED")) {
                Camera.this.checkStorage();
                if (!Camera.this.mIsImageCaptureIntent) {
                    Camera.this.updateThumbnailButton();
                }
            }
        }
    };
    private OnScreenHint mStorageHint;

    private void resetExposureCompensation() {
        String value = this.mPreferences.getString("pref_camera_exposure_key", "0");
        if (!"0".equals(value)) {
            SharedPreferences.Editor editor = this.mPreferences.edit();
            editor.putString("pref_camera_exposure_key", "0");
            editor.apply();
            if (this.mHeadUpDisplay != null) {
                this.mHeadUpDisplay.reloadPreferences();
            }
        }
    }

    private void keepMediaProviderInstance() {
        if (this.mMediaProviderClient == null) {
            this.mMediaProviderClient = this.getContentResolver().acquireContentProviderClient("media");
        }
    }

    private void initializeFirstTime() {
        if (this.mFirstTimeInitialized) {
            return;
        }
        this.mOrientationListener = new MyOrientationEventListener((Context)this);
        this.mOrientationListener.enable();
        this.mLocationManager = (LocationManager)this.getSystemService("location");
        this.mRecordLocation = RecordLocationPreference.get(this.mPreferences, this.getContentResolver());
        if (this.mRecordLocation) {
            this.startReceivingLocationUpdates();
        }
        this.keepMediaProviderInstance();
        this.checkStorage();
        this.mContentResolver = this.getContentResolver();
        if (!this.mIsImageCaptureIntent) {
            this.findViewById(2131427342).setOnClickListener((View.OnClickListener)this);
            this.mLastPictureButton = (ImageView)this.findViewById(2131427339);
            this.mLastPictureButton.setOnClickListener((View.OnClickListener)this);
            this.mThumbController = new ThumbnailController(this.getResources(), this.mLastPictureButton, this.mContentResolver);
            this.mThumbController.loadData(ImageManager.getLastImageThumbPath());
            this.updateThumbnailButton();
        }
        this.mShutterButton = (ShutterButton)this.findViewById(2131427332);
        this.mShutterButton.setOnShutterButtonListener(this);
        this.mShutterButton.setVisibility(0);
        this.mFocusRectangle = (FocusRectangle)this.findViewById(2131427338);
        this.updateFocusIndicator();
        this.initializeScreenBrightness();
        this.installIntentFilter();
        this.initializeFocusTone();
        this.initializeZoom();
        this.mHeadUpDisplay = new CameraHeadUpDisplay((Context)this);
        this.mHeadUpDisplay.setListener(new MyHeadUpDisplayListener());
        this.initializeHeadUpDisplay();
        this.mFirstTimeInitialized = true;
        this.changeHeadUpDisplayState();
        this.addIdleHandler();
    }

    private void addIdleHandler() {
        MessageQueue queue = Looper.myQueue();
        queue.addIdleHandler(new MessageQueue.IdleHandler(){

            public boolean queueIdle() {
                ImageManager.ensureOSXCompatibleFolder();
                return false;
            }
        });
    }

    private void updateThumbnailButton() {
        if (!this.mThumbController.isUriValid() && this.mPicturesRemaining >= 0) {
            this.updateLastImage();
        }
        this.mThumbController.updateDisplayIfNeeded();
    }

    private void initializeSecondTime() {
        this.mOrientationListener.enable();
        this.mRecordLocation = RecordLocationPreference.get(this.mPreferences, this.getContentResolver());
        if (this.mRecordLocation) {
            this.startReceivingLocationUpdates();
        }
        this.installIntentFilter();
        this.initializeFocusTone();
        this.initializeZoom();
        this.changeHeadUpDisplayState();
        this.keepMediaProviderInstance();
        this.checkStorage();
        if (!this.mIsImageCaptureIntent) {
            this.updateThumbnailButton();
        }
    }

    private void initializeZoom() {
        if (!this.mParameters.isZoomSupported()) {
            return;
        }
        this.mZoomMax = this.mParameters.getMaxZoom();
        this.mSmoothZoomSupported = this.mParameters.isSmoothZoomSupported();
        this.mGestureDetector = new GestureDetector((Context)this, (GestureDetector.OnGestureListener)new ZoomGestureListener());
        this.mCameraDevice.setZoomChangeListener((Camera.OnZoomChangeListener)this.mZoomListener);
    }

    private void onZoomValueChanged(int index) {
        if (this.mSmoothZoomSupported) {
            if (this.mTargetZoomValue != index && this.mZoomState != 0) {
                this.mTargetZoomValue = index;
                if (this.mZoomState == 1) {
                    this.mZoomState = 2;
                    this.mCameraDevice.stopSmoothZoom();
                }
            } else if (this.mZoomState == 0 && this.mZoomValue != index) {
                this.mTargetZoomValue = index;
                this.mCameraDevice.startSmoothZoom(index);
                this.mZoomState = 1;
            }
        } else {
            this.mZoomValue = index;
            this.setCameraParametersWhenIdle(2);
        }
    }

    private float[] getZoomRatios() {
        if (!this.mParameters.isZoomSupported()) {
            return null;
        }
        List zoomRatios = this.mParameters.getZoomRatios();
        float[] result = new float[zoomRatios.size()];
        int n = result.length;
        for (int i = 0; i < n; ++i) {
            result[i] = (float)((Integer)zoomRatios.get(i)).intValue() / 100.0f;
        }
        return result;
    }

    public boolean dispatchTouchEvent(MotionEvent m) {
        if (!super.dispatchTouchEvent(m) && this.mGestureDetector != null) {
            return this.mGestureDetector.onTouchEvent(m);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean saveDataToFile(String filePath, byte[] data) {
        FileOutputStream f = null;
        try {
            f = new FileOutputStream(filePath);
            f.write(data);
        }
        catch (IOException e) {
            boolean bl;
            try {
                bl = false;
            }
            catch (Throwable throwable) {
                MenuHelper.closeSilently(f);
                throw throwable;
            }
            MenuHelper.closeSilently(f);
            return bl;
        }
        MenuHelper.closeSilently(f);
        return true;
    }

    private void setLastPictureThumb(byte[] data, int degree, Uri uri) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inSampleSize = 16;
        Bitmap lastPictureThumb = BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length, (BitmapFactory.Options)options);
        lastPictureThumb = Util.rotate(lastPictureThumb, degree);
        this.mThumbController.setData(uri, lastPictureThumb);
    }

    private String createName(long dateTaken) {
        Date date = new Date(dateTaken);
        SimpleDateFormat dateFormat = new SimpleDateFormat(this.getString(2131296358));
        return dateFormat.format(date);
    }

    public void onCreate(Bundle icicle) {
        super.onCreate(icicle);
        this.setContentView(2130903041);
        this.mSurfaceView = (SurfaceView)this.findViewById(2131427337);
        this.mPreferences = new ComboPreferences((Context)this);
        CameraSettings.upgradeGlobalPreferences(this.mPreferences.getGlobal());
        this.mCameraId = CameraSettings.readPreferredCameraId(this.mPreferences);
        this.mPreferences.setLocalId((Context)this, this.mCameraId);
        CameraSettings.upgradeLocalPreferences(this.mPreferences.getLocal());
        this.mNumberOfCameras = CameraHolder.instance().getNumberOfCameras();
        this.resetExposureCompensation();
        Thread startPreviewThread = new Thread(new Runnable(){

            public void run() {
                try {
                    Camera.this.mStartPreviewFail = false;
                    Camera.this.startPreview();
                }
                catch (CameraHardwareException e) {
                    if ("eng".equals(Build.TYPE)) {
                        throw new RuntimeException(e);
                    }
                    Camera.this.mStartPreviewFail = true;
                }
            }
        });
        startPreviewThread.start();
        SurfaceHolder holder = this.mSurfaceView.getHolder();
        holder.addCallback((SurfaceHolder.Callback)this);
        holder.setType(3);
        this.mIsImageCaptureIntent = this.isImageCaptureIntent();
        if (this.mIsImageCaptureIntent) {
            this.setupCaptureParams();
        }
        LayoutInflater inflater = this.getLayoutInflater();
        ViewGroup rootView = (ViewGroup)this.findViewById(2131427334);
        if (this.mIsImageCaptureIntent) {
            View controlBar = inflater.inflate(2130903040, rootView);
            controlBar.findViewById(2131427329).setOnClickListener((View.OnClickListener)this);
            controlBar.findViewById(2131427330).setOnClickListener((View.OnClickListener)this);
            controlBar.findViewById(2131427333).setOnClickListener((View.OnClickListener)this);
        } else {
            inflater.inflate(2130903042, rootView);
            this.mSwitcher = (Switcher)this.findViewById(2131427342);
            this.mSwitcher.setOnSwitchListener(this);
            this.mSwitcher.addTouchView(this.findViewById(2131427340));
        }
        try {
            startPreviewThread.join();
            if (this.mStartPreviewFail) {
                this.showCameraErrorAndFinish();
                return;
            }
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
    }

    private void changeHeadUpDisplayState() {
        Configuration config = this.getResources().getConfiguration();
        if (config.orientation == 2 && !this.mPausing && this.mFirstTimeInitialized) {
            if (this.mGLRootView == null) {
                this.attachHeadUpDisplay();
            }
        } else if (this.mGLRootView != null) {
            this.detachHeadUpDisplay();
        }
    }

    private void overrideHudSettings(String flashMode, String whiteBalance, String focusMode) {
        this.mHeadUpDisplay.overrideSettings("pref_camera_flashmode_key", flashMode, "pref_camera_whitebalance_key", whiteBalance, "pref_camera_focusmode_key", focusMode);
    }

    private void updateSceneModeInHud() {
        if (!"auto".equals(this.mSceneMode)) {
            this.overrideHudSettings(this.mParameters.getFlashMode(), this.mParameters.getWhiteBalance(), this.mParameters.getFocusMode());
        } else {
            this.overrideHudSettings(null, null, null);
        }
    }

    private void initializeHeadUpDisplay() {
        CameraSettings settings = new CameraSettings(this, this.mInitialParams, CameraHolder.instance().getCameraInfo());
        this.mHeadUpDisplay.initialize((Context)this, settings.getPreferenceGroup(2131034112), this.getZoomRatios(), this.mOrientationCompensation);
        if (this.mParameters.isZoomSupported()) {
            this.mHeadUpDisplay.setZoomListener(new ZoomControllerListener(){

                public void onZoomChanged(int index, float ratio, boolean isMoving) {
                    Camera.this.onZoomValueChanged(index);
                }
            });
        }
        this.updateSceneModeInHud();
    }

    private void attachHeadUpDisplay() {
        this.mHeadUpDisplay.setOrientation(this.mOrientationCompensation);
        if (this.mParameters.isZoomSupported()) {
            this.mHeadUpDisplay.setZoomIndex(this.mZoomValue);
        }
        FrameLayout frame = (FrameLayout)this.findViewById(2131427336);
        this.mGLRootView = new GLRootView((Context)this);
        this.mGLRootView.setContentPane(this.mHeadUpDisplay);
        frame.addView((View)this.mGLRootView);
    }

    private void detachHeadUpDisplay() {
        this.mHeadUpDisplay.setGpsHasSignal(false);
        this.mHeadUpDisplay.collapse();
        ((ViewGroup)this.mGLRootView.getParent()).removeView((View)this.mGLRootView);
        this.mGLRootView = null;
    }

    public static int roundOrientation(int orientation) {
        return (orientation + 45) / 90 * 90 % 360;
    }

    private void setOrientationIndicator(int degree) {
        ((RotateImageView)this.findViewById(2131427339)).setDegree(degree);
        ((RotateImageView)this.findViewById(2131427343)).setDegree(degree);
        ((RotateImageView)this.findViewById(2131427341)).setDegree(degree);
    }

    public void onStart() {
        super.onStart();
        if (!this.mIsImageCaptureIntent) {
            this.mSwitcher.setSwitch(true);
        }
    }

    public void onStop() {
        super.onStop();
        if (this.mMediaProviderClient != null) {
            this.mMediaProviderClient.release();
            this.mMediaProviderClient = null;
        }
    }

    private void checkStorage() {
        this.calculatePicturesRemaining();
        this.updateStorageHint(this.mPicturesRemaining);
    }

    public void onClick(View v) {
        switch (v.getId()) {
            case 2131427330: {
                this.hidePostCaptureAlert();
                this.restartPreview();
                break;
            }
            case 2131427339: {
                if (!this.isCameraIdle()) break;
                this.viewLastImage();
                break;
            }
            case 2131427333: {
                this.doAttach();
                break;
            }
            case 2131427329: {
                this.doCancel();
            }
        }
    }

    private Bitmap createCaptureBitmap(byte[] data) {
        String filepath = ImageManager.getTempJpegPath();
        int degree = 0;
        if (this.saveDataToFile(filepath, data)) {
            degree = ImageManager.getExifOrientation(filepath);
            new File(filepath).delete();
        }
        Bitmap bitmap = Util.makeBitmap(data, 51200);
        bitmap = Util.rotate(bitmap, degree);
        return bitmap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void doAttach() {
        block15: {
            byte[] data;
            block17: {
                block18: {
                    if (this.mPausing) {
                        return;
                    }
                    data = this.mImageCapture.getLastCaptureData();
                    if (this.mCropValue != null) break block17;
                    if (this.mSaveUri == null) break block18;
                    OutputStream outputStream = null;
                    try {
                        outputStream = this.mContentResolver.openOutputStream(this.mSaveUri);
                        outputStream.write(data);
                        outputStream.close();
                        this.setResult(-1);
                        this.finish();
                    }
                    catch (IOException ex) {
                        Util.closeSilently(outputStream);
                        break block15;
                        catch (Throwable throwable) {
                            Util.closeSilently(outputStream);
                            throw throwable;
                        }
                    }
                    Util.closeSilently(outputStream);
                    break block15;
                }
                Bitmap bitmap = this.createCaptureBitmap(data);
                this.setResult(-1, new Intent("inline-data").putExtra("data", (Parcelable)bitmap));
                this.finish();
                break block15;
            }
            Uri tempUri = null;
            FileOutputStream tempStream = null;
            try {
                File path = this.getFileStreamPath(sTempCropFilename);
                path.delete();
                tempStream = this.openFileOutput(sTempCropFilename, 0);
                tempStream.write(data);
                tempStream.close();
                tempUri = Uri.fromFile((File)path);
                Util.closeSilently(tempStream);
            }
            catch (FileNotFoundException ex) {
                this.setResult(0);
                this.finish();
                return;
            }
            catch (IOException ex2) {
                this.setResult(0);
                this.finish();
                return;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                Util.closeSilently(tempStream);
            }
            Bundle newExtras = new Bundle();
            if (this.mCropValue.equals("circle")) {
                newExtras.putString("circleCrop", "true");
            }
            if (this.mSaveUri != null) {
                newExtras.putParcelable("output", (Parcelable)this.mSaveUri);
            } else {
                newExtras.putBoolean("return-data", true);
            }
            Intent cropIntent = new Intent("com.android.camera.action.CROP");
            cropIntent.setData(tempUri);
            cropIntent.putExtras(newExtras);
            this.startActivityForResult(cropIntent, 1);
        }
    }

    private void doCancel() {
        this.setResult(0, new Intent());
        this.finish();
    }

    @Override
    public void onShutterButtonFocus(ShutterButton button, boolean pressed) {
        if (this.mPausing) {
            return;
        }
        switch (button.getId()) {
            case 2131427332: {
                this.doFocus(pressed);
            }
        }
    }

    @Override
    public void onShutterButtonClick(ShutterButton button) {
        if (this.mPausing) {
            return;
        }
        switch (button.getId()) {
            case 2131427332: {
                this.doSnap();
            }
        }
    }

    private void updateStorageHint(int remaining) {
        String noStorageText = null;
        if (remaining == -1) {
            String state = Environment.getExternalStorageState();
            noStorageText = state == "checking" ? this.getString(2131296265) : this.getString(2131296263);
        } else if (remaining == -2) {
            noStorageText = this.getString(2131296266);
        } else if (remaining < 1) {
            noStorageText = this.getString(2131296264);
        }
        if (noStorageText != null) {
            if (this.mStorageHint == null) {
                this.mStorageHint = OnScreenHint.makeText((Context)this, noStorageText);
            } else {
                this.mStorageHint.setText(noStorageText);
            }
            this.mStorageHint.show();
        } else if (this.mStorageHint != null) {
            this.mStorageHint.cancel();
            this.mStorageHint = null;
        }
    }

    private void installIntentFilter() {
        IntentFilter intentFilter = new IntentFilter("android.intent.action.MEDIA_MOUNTED");
        intentFilter.addAction("android.intent.action.MEDIA_UNMOUNTED");
        intentFilter.addAction("android.intent.action.MEDIA_SCANNER_FINISHED");
        intentFilter.addAction("android.intent.action.MEDIA_CHECKING");
        intentFilter.addDataScheme("file");
        this.registerReceiver(this.mReceiver, intentFilter);
        this.mDidRegister = true;
    }

    private void initializeFocusTone() {
        try {
            this.mFocusToneGenerator = new ToneGenerator(1, 100);
        }
        catch (Throwable ex) {
            Log.w((String)TAG, (String)"Exception caught while creating tone generator: ", (Throwable)ex);
            this.mFocusToneGenerator = null;
        }
    }

    private void initializeScreenBrightness() {
        Window win = this.getWindow();
        int mode = Settings.System.getInt((ContentResolver)this.getContentResolver(), (String)"screen_brightness_mode", (int)0);
        if (mode == 1) {
            WindowManager.LayoutParams winParams = win.getAttributes();
            winParams.screenBrightness = 0.7f;
            win.setAttributes(winParams);
        }
    }

    protected void onResume() {
        super.onResume();
        this.mPausing = false;
        this.mJpegPictureCallbackTime = 0L;
        this.mZoomValue = 0;
        this.mImageCapture = new ImageCapture();
        if (!this.mPreviewing && !this.mStartPreviewFail) {
            this.resetExposureCompensation();
            if (!this.restartPreview()) {
                return;
            }
        }
        if (this.mSurfaceHolder != null) {
            if (!this.mFirstTimeInitialized) {
                this.mHandler.sendEmptyMessage(2);
            } else {
                this.initializeSecondTime();
            }
        }
        this.keepScreenOnAwhile();
    }

    public void onConfigurationChanged(Configuration config) {
        super.onConfigurationChanged(config);
        this.changeHeadUpDisplayState();
    }

    private static ImageManager.DataLocation dataLocation() {
        return ImageManager.DataLocation.EXTERNAL;
    }

    protected void onPause() {
        this.mPausing = true;
        this.stopPreview();
        this.closeCamera();
        this.resetScreenOn();
        this.changeHeadUpDisplayState();
        if (this.mFirstTimeInitialized) {
            this.mOrientationListener.disable();
            if (!this.mIsImageCaptureIntent) {
                this.mThumbController.storeData(ImageManager.getLastImageThumbPath());
            }
            this.hidePostCaptureAlert();
        }
        if (this.mDidRegister) {
            this.unregisterReceiver(this.mReceiver);
            this.mDidRegister = false;
        }
        this.stopReceivingLocationUpdates();
        if (this.mFocusToneGenerator != null) {
            this.mFocusToneGenerator.release();
            this.mFocusToneGenerator = null;
        }
        if (this.mStorageHint != null) {
            this.mStorageHint.cancel();
            this.mStorageHint = null;
        }
        this.mImageCapture.clearLastData();
        this.mImageCapture = null;
        this.mHandler.removeMessages(3);
        this.mHandler.removeMessages(2);
        super.onPause();
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        switch (requestCode) {
            case 1: {
                Bundle extras;
                Intent intent = new Intent();
                if (data != null && (extras = data.getExtras()) != null) {
                    intent.putExtras(extras);
                }
                this.setResult(resultCode, intent);
                this.finish();
                File path = this.getFileStreamPath(sTempCropFilename);
                path.delete();
                break;
            }
        }
    }

    private boolean canTakePicture() {
        return this.isCameraIdle() && this.mPreviewing && this.mPicturesRemaining > 0;
    }

    private void autoFocus() {
        if (this.canTakePicture()) {
            this.mHeadUpDisplay.setEnabled(false);
            Log.v((String)TAG, (String)"Start autofocus.");
            this.mFocusStartTime = System.currentTimeMillis();
            this.mFocusState = 1;
            this.updateFocusIndicator();
            this.mCameraDevice.autoFocus((Camera.AutoFocusCallback)this.mAutoFocusCallback);
        }
    }

    private void cancelAutoFocus() {
        if (this.mStatus != 2 && (this.mFocusState == 1 || this.mFocusState == 3 || this.mFocusState == 4)) {
            Log.v((String)TAG, (String)"Cancel autofocus.");
            this.mHeadUpDisplay.setEnabled(true);
            this.mCameraDevice.cancelAutoFocus();
        }
        if (this.mFocusState != 2) {
            this.clearFocusState();
        }
    }

    private void clearFocusState() {
        this.mFocusState = 0;
        this.updateFocusIndicator();
    }

    private void updateFocusIndicator() {
        if (this.mFocusRectangle == null) {
            return;
        }
        if (this.mFocusState == 1 || this.mFocusState == 2) {
            this.mFocusRectangle.showStart();
        } else if (this.mFocusState == 3) {
            this.mFocusRectangle.showSuccess();
        } else if (this.mFocusState == 4) {
            this.mFocusRectangle.showFail();
        } else {
            this.mFocusRectangle.clear();
        }
    }

    public void onBackPressed() {
        if (!this.isCameraIdle()) {
            return;
        }
        if (this.mHeadUpDisplay == null || !this.mHeadUpDisplay.collapse()) {
            super.onBackPressed();
        }
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        switch (keyCode) {
            case 80: {
                if (this.mFirstTimeInitialized && event.getRepeatCount() == 0) {
                    this.doFocus(true);
                }
                return true;
            }
            case 27: {
                if (this.mFirstTimeInitialized && event.getRepeatCount() == 0) {
                    this.doSnap();
                }
                return true;
            }
            case 23: {
                if (this.mFirstTimeInitialized && event.getRepeatCount() == 0) {
                    if (this.mHeadUpDisplay.collapse()) {
                        return true;
                    }
                    this.doFocus(true);
                    if (this.mShutterButton.isInTouchMode()) {
                        this.mShutterButton.requestFocusFromTouch();
                    } else {
                        this.mShutterButton.requestFocus();
                    }
                    this.mShutterButton.setPressed(true);
                }
                return true;
            }
        }
        return super.onKeyDown(keyCode, event);
    }

    public boolean onKeyUp(int keyCode, KeyEvent event) {
        switch (keyCode) {
            case 80: {
                if (this.mFirstTimeInitialized) {
                    this.doFocus(false);
                }
                return true;
            }
        }
        return super.onKeyUp(keyCode, event);
    }

    private void doSnap() {
        if (this.mHeadUpDisplay.collapse()) {
            return;
        }
        Log.v((String)TAG, (String)("doSnap: mFocusState=" + this.mFocusState));
        if (this.mFocusMode.equals("infinity") || this.mFocusMode.equals("fixed") || this.mFocusMode.equals("edof") || this.mFocusState == 3 || this.mFocusState == 4) {
            this.mImageCapture.onSnap();
        } else if (this.mFocusState == 1) {
            this.mFocusState = 2;
        } else if (this.mFocusState == 0) {
            // empty if block
        }
    }

    private void doFocus(boolean pressed) {
        if (this.mHeadUpDisplay.collapse()) {
            return;
        }
        if (!(this.mFocusMode.equals("infinity") || this.mFocusMode.equals("fixed") || this.mFocusMode.equals("edof"))) {
            if (pressed) {
                this.autoFocus();
            } else {
                this.cancelAutoFocus();
            }
        }
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int w, int h) {
        if (holder.getSurface() == null) {
            Log.d((String)TAG, (String)"holder.getSurface() == null");
            return;
        }
        this.mSurfaceHolder = holder;
        if (this.mCameraDevice == null) {
            return;
        }
        if (this.mPausing || this.isFinishing()) {
            return;
        }
        if (this.mPreviewing && holder.isCreating()) {
            this.setPreviewDisplay(holder);
        } else {
            this.restartPreview();
        }
        if (!this.mFirstTimeInitialized) {
            this.mHandler.sendEmptyMessage(2);
        } else {
            this.initializeSecondTime();
        }
    }

    public void surfaceCreated(SurfaceHolder holder) {
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        this.stopPreview();
        this.mSurfaceHolder = null;
    }

    private void closeCamera() {
        if (this.mCameraDevice != null) {
            CameraHolder.instance().release();
            this.mCameraDevice.setZoomChangeListener(null);
            this.mCameraDevice = null;
            this.mPreviewing = false;
        }
    }

    private void ensureCameraDevice() throws CameraHardwareException {
        if (this.mCameraDevice == null) {
            this.mCameraDevice = CameraHolder.instance().open(this.mCameraId);
            this.mInitialParams = this.mCameraDevice.getParameters();
        }
    }

    private void updateLastImage() {
        IImageList list = ImageManager.makeImageList(this.mContentResolver, Camera.dataLocation(), 1, 1, ImageManager.CAMERA_IMAGE_BUCKET_ID);
        int count = list.getCount();
        if (count > 0) {
            IImage image = list.getImageAt(count - 1);
            Uri uri = image.fullSizeImageUri();
            this.mThumbController.setData(uri, image.miniThumbBitmap());
        } else {
            this.mThumbController.setData(null, null);
        }
        list.close();
    }

    private void showCameraErrorAndFinish() {
        Resources ress = this.getResources();
        Util.showFatalErrorAndFinish(this, ress.getString(2131296256), ress.getString(2131296257));
    }

    private boolean restartPreview() {
        try {
            this.startPreview();
        }
        catch (CameraHardwareException e) {
            this.showCameraErrorAndFinish();
            return false;
        }
        return true;
    }

    private void setPreviewDisplay(SurfaceHolder holder) {
        try {
            this.mCameraDevice.setPreviewDisplay(holder);
        }
        catch (Throwable ex) {
            this.closeCamera();
            throw new RuntimeException("setPreviewDisplay failed", ex);
        }
    }

    private void startPreview() throws CameraHardwareException {
        if (this.mPausing || this.isFinishing()) {
            return;
        }
        this.ensureCameraDevice();
        if (this.mPreviewing) {
            this.stopPreview();
        }
        this.setPreviewDisplay(this.mSurfaceHolder);
        Util.setCameraDisplayOrientation(this, this.mCameraId, this.mCameraDevice);
        this.setCameraParameters(-1);
        this.mCameraDevice.setErrorCallback((Camera.ErrorCallback)this.mErrorCallback);
        try {
            Log.v((String)TAG, (String)"startPreview");
            this.mCameraDevice.startPreview();
        }
        catch (Throwable ex) {
            this.closeCamera();
            throw new RuntimeException("startPreview failed", ex);
        }
        this.mPreviewing = true;
        this.mZoomState = 0;
        this.mStatus = 1;
    }

    private void stopPreview() {
        if (this.mCameraDevice != null && this.mPreviewing) {
            Log.v((String)TAG, (String)"stopPreview");
            this.mCameraDevice.stopPreview();
        }
        this.mPreviewing = false;
        this.clearFocusState();
    }

    private Camera.Size getOptimalPreviewSize(List<Camera.Size> sizes, double targetRatio) {
        double ASPECT_TOLERANCE = 0.05;
        if (sizes == null) {
            return null;
        }
        Camera.Size optimalSize = null;
        double minDiff = Double.MAX_VALUE;
        Display display = this.getWindowManager().getDefaultDisplay();
        int targetHeight = Math.min(display.getHeight(), display.getWidth());
        if (targetHeight <= 0) {
            WindowManager windowManager = (WindowManager)this.getSystemService("window");
            targetHeight = windowManager.getDefaultDisplay().getHeight();
        }
        for (Camera.Size size : sizes) {
            double ratio = (double)size.width / (double)size.height;
            if (Math.abs(ratio - targetRatio) > 0.05 || !((double)Math.abs(size.height - targetHeight) < minDiff)) continue;
            optimalSize = size;
            minDiff = Math.abs(size.height - targetHeight);
        }
        if (optimalSize == null) {
            Log.v((String)TAG, (String)"No preview size match the aspect ratio");
            minDiff = Double.MAX_VALUE;
            for (Camera.Size size : sizes) {
                if (!((double)Math.abs(size.height - targetHeight) < minDiff)) continue;
                optimalSize = size;
                minDiff = Math.abs(size.height - targetHeight);
            }
        }
        return optimalSize;
    }

    private static boolean isSupported(String value, List<String> supported) {
        return supported == null ? false : supported.indexOf(value) >= 0;
    }

    private void updateCameraParametersInitialize() {
        List frameRates = this.mParameters.getSupportedPreviewFrameRates();
        if (frameRates != null) {
            Integer max = (Integer)Collections.max(frameRates);
            this.mParameters.setPreviewFrameRate(max.intValue());
        }
    }

    private void updateCameraParametersZoom() {
        if (this.mParameters.isZoomSupported()) {
            this.mParameters.setZoom(this.mZoomValue);
        }
    }

    private void updateCameraParametersPreference() {
        Camera.Size original;
        String pictureSize = this.mPreferences.getString("pref_camera_picturesize_key", null);
        if (pictureSize == null) {
            CameraSettings.initialCameraPictureSize((Context)this, this.mParameters);
        } else {
            List supported = this.mParameters.getSupportedPictureSizes();
            CameraSettings.setCameraPictureSize(pictureSize, supported, this.mParameters);
        }
        Camera.Size size = this.mParameters.getPictureSize();
        PreviewFrameLayout frameLayout = (PreviewFrameLayout)this.findViewById(2131427335);
        frameLayout.setAspectRatio((double)size.width / (double)size.height);
        List sizes = this.mParameters.getSupportedPreviewSizes();
        Camera.Size optimalSize = this.getOptimalPreviewSize(sizes, (double)size.width / (double)size.height);
        if (optimalSize != null && !(original = this.mParameters.getPreviewSize()).equals((Object)optimalSize)) {
            this.mParameters.setPreviewSize(optimalSize.width, optimalSize.height);
            this.mCameraDevice.setParameters(this.mParameters);
            this.mParameters = this.mCameraDevice.getParameters();
        }
        this.mSceneMode = this.mPreferences.getString("pref_camera_scenemode_key", this.getString(2131296336));
        if (Camera.isSupported(this.mSceneMode, this.mParameters.getSupportedSceneModes())) {
            if (!this.mParameters.getSceneMode().equals(this.mSceneMode)) {
                this.mParameters.setSceneMode(this.mSceneMode);
                this.mCameraDevice.setParameters(this.mParameters);
                this.mParameters = this.mCameraDevice.getParameters();
            }
        } else {
            this.mSceneMode = this.mParameters.getSceneMode();
            if (this.mSceneMode == null) {
                this.mSceneMode = "auto";
            }
        }
        String jpegQuality = this.mPreferences.getString("pref_camera_jpegquality_key", this.getString(2131296298));
        this.mParameters.setJpegQuality(JpegEncodingQualityMappings.getQualityNumber(jpegQuality));
        String colorEffect = this.mPreferences.getString("pref_camera_coloreffect_key", this.getString(2131296322));
        if (Camera.isSupported(colorEffect, this.mParameters.getSupportedColorEffects())) {
            this.mParameters.setColorEffect(colorEffect);
        }
        String exposure = this.mPreferences.getString("pref_camera_exposure_key", this.getString(2131296355));
        try {
            int value = Integer.parseInt(exposure);
            int max = this.mParameters.getMaxExposureCompensation();
            int min = this.mParameters.getMinExposureCompensation();
            if (value >= min && value <= max) {
                this.mParameters.setExposureCompensation(value);
            } else {
                Log.w((String)TAG, (String)("invalid exposure range: " + exposure));
            }
        }
        catch (NumberFormatException e) {
            Log.w((String)TAG, (String)("invalid exposure: " + exposure));
        }
        if (this.mHeadUpDisplay != null) {
            this.updateSceneModeInHud();
        }
        if ("auto".equals(this.mSceneMode)) {
            List supportedFlash;
            String flashMode = this.mPreferences.getString("pref_camera_flashmode_key", this.getString(2131296308));
            if (Camera.isSupported(flashMode, supportedFlash = this.mParameters.getSupportedFlashModes())) {
                this.mParameters.setFlashMode(flashMode);
            } else {
                flashMode = this.mParameters.getFlashMode();
                if (flashMode == null) {
                    flashMode = this.getString(2131296309);
                }
            }
            String whiteBalance = this.mPreferences.getString("pref_camera_whitebalance_key", this.getString(2131296315));
            if (Camera.isSupported(whiteBalance, this.mParameters.getSupportedWhiteBalance())) {
                this.mParameters.setWhiteBalance(whiteBalance);
            } else {
                whiteBalance = this.mParameters.getWhiteBalance();
                if (whiteBalance == null) {
                    whiteBalance = "auto";
                }
            }
            this.mFocusMode = this.mPreferences.getString("pref_camera_focusmode_key", this.getString(2131296303));
            if (Camera.isSupported(this.mFocusMode, this.mParameters.getSupportedFocusModes())) {
                this.mParameters.setFocusMode(this.mFocusMode);
            } else {
                this.mFocusMode = this.mParameters.getFocusMode();
                if (this.mFocusMode == null) {
                    this.mFocusMode = "auto";
                }
            }
        } else {
            this.mFocusMode = this.mParameters.getFocusMode();
        }
    }

    private void setCameraParameters(int updateSet) {
        this.mParameters = this.mCameraDevice.getParameters();
        if ((updateSet & 1) != 0) {
            this.updateCameraParametersInitialize();
        }
        if ((updateSet & 2) != 0) {
            this.updateCameraParametersZoom();
        }
        if ((updateSet & 4) != 0) {
            this.updateCameraParametersPreference();
        }
        this.mCameraDevice.setParameters(this.mParameters);
    }

    private void setCameraParametersWhenIdle(int additionalUpdateSet) {
        this.mUpdateSet |= additionalUpdateSet;
        if (this.mCameraDevice == null) {
            this.mUpdateSet = 0;
            return;
        }
        if (this.isCameraIdle()) {
            this.setCameraParameters(this.mUpdateSet);
            this.mUpdateSet = 0;
        } else if (!this.mHandler.hasMessages(5)) {
            this.mHandler.sendEmptyMessageDelayed(5, 1000L);
        }
    }

    private void gotoGallery() {
        MenuHelper.gotoCameraImageGallery(this);
    }

    private void viewLastImage() {
        if (this.mThumbController.isUriValid()) {
            Intent intent = new Intent("com.cooliris.media.action.REVIEW", this.mThumbController.getUri());
            try {
                this.startActivity(intent);
            }
            catch (ActivityNotFoundException ex) {
                try {
                    intent = new Intent("android.intent.action.VIEW", this.mThumbController.getUri());
                    this.startActivity(intent);
                }
                catch (ActivityNotFoundException e) {
                    Log.e((String)TAG, (String)"review image fail", (Throwable)e);
                }
            }
        } else {
            Log.e((String)TAG, (String)"Can't view last image.");
        }
    }

    private void startReceivingLocationUpdates() {
        if (this.mLocationManager != null) {
            try {
                this.mLocationManager.requestLocationUpdates("network", 1000L, 0.0f, (android.location.LocationListener)this.mLocationListeners[1]);
            }
            catch (SecurityException ex) {
                Log.i((String)TAG, (String)"fail to request location update, ignore", (Throwable)ex);
            }
            catch (IllegalArgumentException ex) {
                Log.d((String)TAG, (String)("provider does not exist " + ex.getMessage()));
            }
            try {
                this.mLocationManager.requestLocationUpdates("gps", 1000L, 0.0f, (android.location.LocationListener)this.mLocationListeners[0]);
            }
            catch (SecurityException ex) {
                Log.i((String)TAG, (String)"fail to request location update, ignore", (Throwable)ex);
            }
            catch (IllegalArgumentException ex) {
                Log.d((String)TAG, (String)("provider does not exist " + ex.getMessage()));
            }
        }
    }

    private void stopReceivingLocationUpdates() {
        if (this.mLocationManager != null) {
            for (int i = 0; i < this.mLocationListeners.length; ++i) {
                try {
                    this.mLocationManager.removeUpdates((android.location.LocationListener)this.mLocationListeners[i]);
                    continue;
                }
                catch (Exception ex) {
                    Log.i((String)TAG, (String)"fail to remove location listners, ignore", (Throwable)ex);
                }
            }
        }
    }

    private Location getCurrentLocation() {
        for (int i = 0; i < this.mLocationListeners.length; ++i) {
            Location l = this.mLocationListeners[i].current();
            if (l == null) continue;
            return l;
        }
        return null;
    }

    private boolean isCameraIdle() {
        return this.mStatus == 1 && this.mFocusState == 0;
    }

    private boolean isImageCaptureIntent() {
        String action = this.getIntent().getAction();
        return "android.media.action.IMAGE_CAPTURE".equals(action);
    }

    private void setupCaptureParams() {
        Bundle myExtras = this.getIntent().getExtras();
        if (myExtras != null) {
            this.mSaveUri = (Uri)myExtras.getParcelable("output");
            this.mCropValue = myExtras.getString("crop");
        }
    }

    private void showPostCaptureAlert() {
        if (this.mIsImageCaptureIntent) {
            int[] pickIds;
            this.findViewById(2131427332).setVisibility(4);
            for (int id2 : pickIds = new int[]{2131427330, 2131427333}) {
                View button = this.findViewById(id2);
                ((View)button.getParent()).setVisibility(0);
            }
        }
    }

    private void hidePostCaptureAlert() {
        if (this.mIsImageCaptureIntent) {
            int[] pickIds;
            this.findViewById(2131427332).setVisibility(0);
            for (int id2 : pickIds = new int[]{2131427330, 2131427333}) {
                View button = this.findViewById(id2);
                ((View)button.getParent()).setVisibility(8);
            }
        }
    }

    private int calculatePicturesRemaining() {
        this.mPicturesRemaining = MenuHelper.calculatePicturesRemaining();
        return this.mPicturesRemaining;
    }

    public boolean onPrepareOptionsMenu(Menu menu) {
        super.onPrepareOptionsMenu(menu);
        for (int i = 0; i < menu.size(); ++i) {
            menu.getItem(i).setVisible(this.isCameraIdle());
        }
        return true;
    }

    public boolean onCreateOptionsMenu(Menu menu) {
        super.onCreateOptionsMenu(menu);
        if (this.mIsImageCaptureIntent) {
            return false;
        }
        this.addBaseMenuItems(menu);
        return true;
    }

    private void addBaseMenuItems(Menu menu) {
        MenuHelper.addSwitchModeMenuItem(menu, true, new Runnable(){

            public void run() {
                Camera.this.switchToVideoMode();
            }
        });
        MenuItem gallery = menu.add(0, 0, 2, 2131296273).setOnMenuItemClickListener(new MenuItem.OnMenuItemClickListener(){

            public boolean onMenuItemClick(MenuItem item) {
                Camera.this.gotoGallery();
                return true;
            }
        });
        gallery.setIcon(17301567);
        this.mGalleryItems.add(gallery);
        if (this.mNumberOfCameras > 1) {
            menu.add(0, 0, 3, 2131296274).setOnMenuItemClickListener(new MenuItem.OnMenuItemClickListener(){

                public boolean onMenuItemClick(MenuItem item) {
                    Camera.this.switchCameraId((Camera.this.mCameraId + 1) % Camera.this.mNumberOfCameras);
                    return true;
                }
            }).setIcon(17301559);
        }
    }

    private void switchCameraId(int cameraId) {
        if (this.mPausing || !this.isCameraIdle()) {
            return;
        }
        this.mCameraId = cameraId;
        CameraSettings.writePreferredCameraId(this.mPreferences, cameraId);
        this.stopPreview();
        this.closeCamera();
        this.mHandler.removeMessages(3);
        this.mJpegPictureCallbackTime = 0L;
        this.mZoomValue = 0;
        this.mPreferences.setLocalId((Context)this, this.mCameraId);
        CameraSettings.upgradeLocalPreferences(this.mPreferences.getLocal());
        this.resetExposureCompensation();
        if (!this.restartPreview()) {
            return;
        }
        this.initializeZoom();
        if (this.mFirstTimeInitialized) {
            this.initializeHeadUpDisplay();
        }
    }

    private boolean switchToVideoMode() {
        if (this.isFinishing() || !this.isCameraIdle()) {
            return false;
        }
        MenuHelper.gotoVideoMode(this);
        this.mHandler.removeMessages(2);
        this.finish();
        return true;
    }

    @Override
    public boolean onSwitchChanged(Switcher source, boolean onOff) {
        if (!onOff) {
            return this.switchToVideoMode();
        }
        return true;
    }

    private void onSharedPreferenceChanged() {
        int cameraId;
        if (this.mPausing) {
            return;
        }
        boolean recordLocation = RecordLocationPreference.get(this.mPreferences, this.getContentResolver());
        if (this.mRecordLocation != recordLocation) {
            this.mRecordLocation = recordLocation;
            if (this.mRecordLocation) {
                this.startReceivingLocationUpdates();
            } else {
                this.stopReceivingLocationUpdates();
            }
        }
        if (this.mCameraId != (cameraId = CameraSettings.readPreferredCameraId(this.mPreferences))) {
            this.switchCameraId(cameraId);
        } else {
            this.setCameraParametersWhenIdle(4);
        }
    }

    public void onUserInteraction() {
        super.onUserInteraction();
        this.keepScreenOnAwhile();
    }

    private void resetScreenOn() {
        this.mHandler.removeMessages(4);
        this.getWindow().clearFlags(128);
    }

    private void keepScreenOnAwhile() {
        this.mHandler.removeMessages(4);
        this.getWindow().addFlags(128);
        this.mHandler.sendEmptyMessageDelayed(4, 120000L);
    }

    protected void onRestorePreferencesClicked() {
        if (this.mPausing) {
            return;
        }
        Runnable runnable = new Runnable(){

            public void run() {
                Camera.this.mHeadUpDisplay.restorePreferences(Camera.this.mParameters);
            }
        };
        MenuHelper.confirmAction((Context)this, this.getString(2131296267), this.getString(2131296268), runnable);
    }

    private class MyHeadUpDisplayListener
    implements HeadUpDisplay.Listener {
        private MyHeadUpDisplayListener() {
        }

        public void onSharedPreferencesChanged() {
            Camera.this.onSharedPreferenceChanged();
        }

        public void onRestorePreferencesClicked() {
            Camera.this.onRestorePreferencesClicked();
        }

        public void onPopupWindowVisibilityChanged(int visibility) {
        }
    }

    private class MyOrientationEventListener
    extends OrientationEventListener {
        public MyOrientationEventListener(Context context) {
            super(context);
        }

        public void onOrientationChanged(int orientation) {
            if (orientation == -1) {
                return;
            }
            Camera.this.mOrientation = Camera.roundOrientation(orientation);
            int orientationCompensation = Camera.this.mOrientation + Util.getDisplayRotation(Camera.this);
            if (Camera.this.mOrientationCompensation != orientationCompensation) {
                Camera.this.mOrientationCompensation = orientationCompensation;
                if (!Camera.this.mIsImageCaptureIntent) {
                    Camera.this.setOrientationIndicator(Camera.this.mOrientationCompensation);
                }
                Camera.this.mHeadUpDisplay.setOrientation(Camera.this.mOrientationCompensation);
            }
        }
    }

    private class ImageCapture {
        private Uri mLastContentUri;
        byte[] mCaptureOnlyData;

        private ImageCapture() {
        }

        private int storeImage(byte[] data, Location loc) {
            try {
                long dateTaken = System.currentTimeMillis();
                String title = Camera.this.createName(dateTaken);
                String filename = title + ".jpg";
                int[] degree = new int[1];
                this.mLastContentUri = ImageManager.addImage(Camera.this.mContentResolver, title, dateTaken, loc, ImageManager.CAMERA_IMAGE_BUCKET_NAME, filename, null, data, degree);
                return degree[0];
            }
            catch (Exception ex) {
                Log.e((String)Camera.TAG, (String)"Exception while compressing image.", (Throwable)ex);
                return 0;
            }
        }

        public void storeImage(byte[] data, android.hardware.Camera camera, Location loc) {
            if (!Camera.this.mIsImageCaptureIntent) {
                int degree = this.storeImage(data, loc);
                Camera.this.sendBroadcast(new Intent("com.android.camera.NEW_PICTURE", this.mLastContentUri));
                Camera.this.setLastPictureThumb(data, degree, Camera.this.mImageCapture.getLastCaptureUri());
                Camera.this.mThumbController.updateDisplayIfNeeded();
            } else {
                this.mCaptureOnlyData = data;
                Camera.this.showPostCaptureAlert();
            }
        }

        public void initiate() {
            if (Camera.this.mCameraDevice == null) {
                return;
            }
            this.capture();
        }

        public Uri getLastCaptureUri() {
            return this.mLastContentUri;
        }

        public byte[] getLastCaptureData() {
            return this.mCaptureOnlyData;
        }

        private void capture() {
            Location loc;
            this.mCaptureOnlyData = null;
            int rotation = 0;
            if (Camera.this.mOrientation != -1) {
                Camera.CameraInfo info = CameraHolder.instance().getCameraInfo()[Camera.this.mCameraId];
                rotation = info.facing == 1 ? (info.orientation - Camera.this.mOrientation + 360) % 360 : (info.orientation + Camera.this.mOrientation) % 360;
            }
            Camera.this.mParameters.setRotation(rotation);
            Camera.this.mParameters.removeGpsData();
            Camera.this.mParameters.setGpsTimestamp(System.currentTimeMillis() / 1000L);
            Location location = loc = Camera.this.mRecordLocation ? Camera.this.getCurrentLocation() : null;
            if (loc != null) {
                boolean hasLatLon;
                double lat = loc.getLatitude();
                double lon = loc.getLongitude();
                boolean bl = hasLatLon = lat != 0.0 || lon != 0.0;
                if (hasLatLon) {
                    Camera.this.mParameters.setGpsLatitude(lat);
                    Camera.this.mParameters.setGpsLongitude(lon);
                    Camera.this.mParameters.setGpsProcessingMethod(loc.getProvider().toUpperCase());
                    if (loc.hasAltitude()) {
                        Camera.this.mParameters.setGpsAltitude(loc.getAltitude());
                    } else {
                        Camera.this.mParameters.setGpsAltitude(0.0);
                    }
                    if (loc.getTime() != 0L) {
                        long utcTimeSeconds = loc.getTime() / 1000L;
                        Camera.this.mParameters.setGpsTimestamp(utcTimeSeconds);
                    }
                } else {
                    loc = null;
                }
            }
            Camera.this.mCameraDevice.setParameters(Camera.this.mParameters);
            Camera.this.mCameraDevice.takePicture((Camera.ShutterCallback)Camera.this.mShutterCallback, (Camera.PictureCallback)Camera.this.mRawPictureCallback, (Camera.PictureCallback)Camera.this.mPostViewPictureCallback, (Camera.PictureCallback)new JpegPictureCallback(loc));
            Camera.this.mPreviewing = false;
        }

        public void onSnap() {
            if (Camera.this.mPausing || Camera.this.mStatus == 2) {
                return;
            }
            Camera.this.mCaptureStartTime = System.currentTimeMillis();
            Camera.this.mPostViewPictureCallbackTime = 0L;
            Camera.this.mHeadUpDisplay.setEnabled(false);
            Camera.this.mStatus = 2;
            Camera.this.mImageCapture.initiate();
        }

        private void clearLastData() {
            this.mCaptureOnlyData = null;
        }
    }

    private final class ZoomListener
    implements Camera.OnZoomChangeListener {
        private ZoomListener() {
        }

        public void onZoomChange(int value, boolean stopped, android.hardware.Camera camera) {
            Log.v((String)Camera.TAG, (String)("Zoom changed: value=" + value + ". stopped=" + stopped));
            Camera.this.mZoomValue = value;
            Camera.this.mParameters.setZoom(value);
            if (stopped && Camera.this.mZoomState != 0) {
                if (value != Camera.this.mTargetZoomValue) {
                    Camera.this.mCameraDevice.startSmoothZoom(Camera.this.mTargetZoomValue);
                    Camera.this.mZoomState = 1;
                } else {
                    Camera.this.mZoomState = 0;
                }
            }
        }
    }

    private static final class ErrorCallback
    implements Camera.ErrorCallback {
        private ErrorCallback() {
        }

        public void onError(int error, android.hardware.Camera camera) {
            if (error == 100) {
                mMediaServerDied = true;
                Log.v((String)Camera.TAG, (String)"media server died");
            }
        }
    }

    private final class AutoFocusCallback
    implements Camera.AutoFocusCallback {
        private AutoFocusCallback() {
        }

        public void onAutoFocus(boolean focused, android.hardware.Camera camera) {
            Camera.this.mFocusCallbackTime = System.currentTimeMillis();
            Camera.this.mAutoFocusTime = Camera.this.mFocusCallbackTime - Camera.this.mFocusStartTime;
            Log.v((String)Camera.TAG, (String)("mAutoFocusTime = " + Camera.this.mAutoFocusTime + "ms"));
            if (Camera.this.mFocusState == 2) {
                if (focused) {
                    Camera.this.mFocusState = 3;
                } else {
                    Camera.this.mFocusState = 4;
                }
                Camera.this.mImageCapture.onSnap();
            } else if (Camera.this.mFocusState == 1) {
                ToneGenerator tg = Camera.this.mFocusToneGenerator;
                if (tg != null) {
                    tg.startTone(28);
                }
                if (focused) {
                    Camera.this.mFocusState = 3;
                } else {
                    Camera.this.mFocusState = 4;
                }
            } else if (Camera.this.mFocusState == 0) {
                // empty if block
            }
            Camera.this.updateFocusIndicator();
        }
    }

    private final class JpegPictureCallback
    implements Camera.PictureCallback {
        Location mLocation;

        public JpegPictureCallback(Location loc) {
            this.mLocation = loc;
        }

        public void onPictureTaken(byte[] jpegData, android.hardware.Camera camera) {
            if (Camera.this.mPausing) {
                return;
            }
            Camera.this.mJpegPictureCallbackTime = System.currentTimeMillis();
            if (Camera.this.mPostViewPictureCallbackTime != 0L) {
                Camera.this.mShutterToPictureDisplayedTime = Camera.this.mPostViewPictureCallbackTime - Camera.this.mShutterCallbackTime;
                Camera.this.mPictureDisplayedToJpegCallbackTime = Camera.this.mJpegPictureCallbackTime - Camera.this.mPostViewPictureCallbackTime;
            } else {
                Camera.this.mShutterToPictureDisplayedTime = Camera.this.mRawPictureCallbackTime - Camera.this.mShutterCallbackTime;
                Camera.this.mPictureDisplayedToJpegCallbackTime = Camera.this.mJpegPictureCallbackTime - Camera.this.mRawPictureCallbackTime;
            }
            Log.v((String)Camera.TAG, (String)("mPictureDisplayedToJpegCallbackTime = " + Camera.this.mPictureDisplayedToJpegCallbackTime + "ms"));
            Camera.this.mHeadUpDisplay.setEnabled(true);
            if (!Camera.this.mIsImageCaptureIntent) {
                long delay = 1200L - Camera.this.mPictureDisplayedToJpegCallbackTime;
                if (delay < 0L) {
                    Camera.this.restartPreview();
                } else {
                    Camera.this.mHandler.sendEmptyMessageDelayed(3, delay);
                }
            }
            Camera.this.mImageCapture.storeImage(jpegData, camera, this.mLocation);
            Camera.this.calculatePicturesRemaining();
            if (Camera.this.mPicturesRemaining < 1) {
                Camera.this.updateStorageHint(Camera.this.mPicturesRemaining);
            }
            if (!Camera.this.mHandler.hasMessages(3)) {
                long now = System.currentTimeMillis();
                Camera.this.mJpegCallbackFinishTime = now - Camera.this.mJpegPictureCallbackTime;
                Log.v((String)Camera.TAG, (String)("mJpegCallbackFinishTime = " + Camera.this.mJpegCallbackFinishTime + "ms"));
                Camera.this.mJpegPictureCallbackTime = 0L;
            }
        }
    }

    private final class RawPictureCallback
    implements Camera.PictureCallback {
        private RawPictureCallback() {
        }

        public void onPictureTaken(byte[] rawData, android.hardware.Camera camera) {
            Camera.this.mRawPictureCallbackTime = System.currentTimeMillis();
            Log.v((String)Camera.TAG, (String)("mShutterToRawCallbackTime = " + (Camera.this.mRawPictureCallbackTime - Camera.this.mShutterCallbackTime) + "ms"));
        }
    }

    private final class PostViewPictureCallback
    implements Camera.PictureCallback {
        private PostViewPictureCallback() {
        }

        public void onPictureTaken(byte[] data, android.hardware.Camera camera) {
            Camera.this.mPostViewPictureCallbackTime = System.currentTimeMillis();
            Log.v((String)Camera.TAG, (String)("mShutterToPostViewCallbackTime = " + (Camera.this.mPostViewPictureCallbackTime - Camera.this.mShutterCallbackTime) + "ms"));
        }
    }

    private final class ShutterCallback
    implements Camera.ShutterCallback {
        private ShutterCallback() {
        }

        public void onShutter() {
            Camera.this.mShutterCallbackTime = System.currentTimeMillis();
            Camera.this.mShutterLag = Camera.this.mShutterCallbackTime - Camera.this.mCaptureStartTime;
            Log.v((String)Camera.TAG, (String)("mShutterLag = " + Camera.this.mShutterLag + "ms"));
            Camera.this.clearFocusState();
        }
    }

    private class LocationListener
    implements android.location.LocationListener {
        Location mLastLocation;
        boolean mValid = false;
        String mProvider;

        public LocationListener(String provider) {
            this.mProvider = provider;
            this.mLastLocation = new Location(this.mProvider);
        }

        public void onLocationChanged(Location newLocation) {
            if (newLocation.getLatitude() == 0.0 && newLocation.getLongitude() == 0.0) {
                return;
            }
            if (Camera.this.mRecordLocation && "gps".equals(this.mProvider) && Camera.this.mHeadUpDisplay != null) {
                Camera.this.mHeadUpDisplay.setGpsHasSignal(true);
            }
            this.mLastLocation.set(newLocation);
            this.mValid = true;
        }

        public void onProviderEnabled(String provider) {
        }

        public void onProviderDisabled(String provider) {
            this.mValid = false;
        }

        public void onStatusChanged(String provider, int status, Bundle extras) {
            switch (status) {
                case 0: 
                case 1: {
                    this.mValid = false;
                    if (!Camera.this.mRecordLocation || !"gps".equals(provider) || Camera.this.mHeadUpDisplay == null) break;
                    Camera.this.mHeadUpDisplay.setGpsHasSignal(false);
                }
            }
        }

        public Location current() {
            return this.mValid ? this.mLastLocation : null;
        }
    }

    private class ZoomGestureListener
    extends GestureDetector.SimpleOnGestureListener {
        private ZoomGestureListener() {
        }

        public boolean onDoubleTap(MotionEvent e) {
            if (Camera.this.mPausing || !Camera.this.isCameraIdle() || !Camera.this.mPreviewing || Camera.this.mZoomState != 0) {
                return false;
            }
            if (Camera.this.mZoomValue < Camera.this.mZoomMax) {
                Camera.this.mZoomValue = Camera.this.mZoomMax;
            } else {
                Camera.this.mZoomValue = 0;
            }
            Camera.this.setCameraParametersWhenIdle(2);
            Camera.this.mHeadUpDisplay.setZoomIndex(Camera.this.mZoomValue);
            return true;
        }
    }

    private class MainHandler
    extends Handler {
        private MainHandler() {
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 3: {
                    Camera.this.restartPreview();
                    if (Camera.this.mJpegPictureCallbackTime == 0L) break;
                    long now = System.currentTimeMillis();
                    Camera.this.mJpegCallbackFinishTime = now - Camera.this.mJpegPictureCallbackTime;
                    Log.v((String)Camera.TAG, (String)("mJpegCallbackFinishTime = " + Camera.this.mJpegCallbackFinishTime + "ms"));
                    Camera.this.mJpegPictureCallbackTime = 0L;
                    break;
                }
                case 4: {
                    Camera.this.getWindow().clearFlags(128);
                    break;
                }
                case 2: {
                    Camera.this.initializeFirstTime();
                    break;
                }
                case 5: {
                    Camera.this.setCameraParametersWhenIdle(0);
                }
            }
        }
    }
}

