/*
 * Decompiled with CFR 0.152.
 */
package org.javia.arity;

import org.javia.arity.FormatCase;
import org.javia.arity.MoreMath;
import org.javia.arity.SizeCase;
import org.javia.arity.Util;

class TestFormat {
    static FormatCase[] cases = new FormatCase[]{new FormatCase(0, 0.1, "0.1"), new FormatCase(0, 0.12, "0.12"), new FormatCase(0, 0.001, "0.001"), new FormatCase(0, 0.0012, "0.0012"), new FormatCase(0, 1.0E-7, "1E-7"), new FormatCase(0, 1.2E-7, "1.2E-7"), new FormatCase(0, 0.123456789012345, "0.123456789012345"), new FormatCase(0, 0.0, "0"), new FormatCase(0, 1.0, "1"), new FormatCase(0, 12.0, "12"), new FormatCase(0, 1.23456789E9, "1234567890"), new FormatCase(0, 1.0E9, "1000000000"), new FormatCase(0, 1.23456789012345, "1.23456789012345"), new FormatCase(0, 12345.6789012345, "12345.6789012345"), new FormatCase(0, 1.23456789012345E9, "1234567890.12345"), new FormatCase(0, 1.23456789012345E14, "1.23456789012345E14"), new FormatCase(0, 1.0E14, "1E14"), new FormatCase(0, 1.2E14, "1.2E14"), new FormatCase(0, 1.00000000000001E14, "1.00000000000001E14"), new FormatCase(2, 0.1, "0.1"), new FormatCase(2, 1.2E-7, "1.2E-7"), new FormatCase(2, 0.123456789012345, "0.12345678901235"), new FormatCase(2, 0.0, "0"), new FormatCase(2, 1.23456789012345, "1.2345678901235"), new FormatCase(3, 1.23456789012345, "1.234567890123"), new FormatCase(0, 12345.6789012345, "12345.6789012345"), new FormatCase(2, 1.23456789012345E9, "1234567890.1235"), new FormatCase(3, 1.23456789012345E14, "1.234567890123E14"), new FormatCase(2, 1.00000000000001E14, "1E14"), new FormatCase(0, 1.2345678901234568E16, "1.2345678901234568E16"), new FormatCase(2, 1.2345678901234568E16, "1.2345678901235E16"), new FormatCase(0, 1.0E17, "1E17"), new FormatCase(0, 1.0E16, "1E16"), new FormatCase(0, 9.99999999999999E14, "9.99999999999999E14"), new FormatCase(2, 9.99999999999999E14, "1E15"), new FormatCase(2, 9.99999999999994E14, "9.9999999999999E14"), new FormatCase(2, MoreMath.log2(1.00002), "0.000028853612282487"), new FormatCase(0, 4.0E-4, "0.0004"), new FormatCase(0, 1.0E30, "1E30")};
    static SizeCase[] sizeCases = new SizeCase[]{new SizeCase(9, "1111111110", "1.11111E9"), new SizeCase(10, "1111111110", "1111111110"), new SizeCase(10, "11111111110", "1.11111E10"), new SizeCase(10, "12.11111E9", "12.11111E9"), new SizeCase(9, "12.34567E9", "12.3456E9"), new SizeCase(9, "12345678E3", "1.2345E10"), new SizeCase(9, "-12345678E3", "-1.234E10"), new SizeCase(9, "-0.00000007", "-0.000000"), new SizeCase(5, "-1.23E123", "-1.23E123"), new SizeCase(5, "-1.2E123", "-1.2E123"), new SizeCase(5, "-1E123", "-1E123"), new SizeCase(2, "-1", "-1"), new SizeCase(1, "-1", "-1"), new SizeCase(1, "-0.02", "-0.02"), new SizeCase(1, "0.02", "0")};

    TestFormat() {
    }

    static boolean testFormat() {
        boolean bl = true;
        for (int i = 0; i < cases.length; ++i) {
            String string2;
            FormatCase formatCase = cases[i];
            double d = Double.parseDouble(formatCase.res);
            if (formatCase.rounding == 0 && d != formatCase.val) {
                System.out.println("wrong test? " + formatCase.res + " " + d + " " + formatCase.val);
            }
            if (!(string2 = Util.doubleToString(formatCase.val, formatCase.rounding)).equals(formatCase.res)) {
                System.out.println("Expected '" + formatCase.res + "', got '" + string2 + "'. " + Double.toString(formatCase.val));
                bl = false;
            }
            int n = formatCase.rounding == 0 ? 17 : 15 - formatCase.rounding;
        }
        return bl;
    }

    static boolean testSizeCases() {
        boolean bl = true;
        for (SizeCase sizeCase : sizeCases) {
            String string2 = Util.sizeTruncate(sizeCase.val, sizeCase.size);
            if (string2.equals(sizeCase.res)) continue;
            System.out.println("sizeTruncate(" + sizeCase.val + ", " + sizeCase.size + "): got '" + string2 + "' expected '" + sizeCase.res + "'");
            bl = false;
        }
        return bl;
    }
}

