/*
 * Decompiled with CFR 0.152.
 */
package org.javia.arity;

import org.javia.arity.ArityException;
import org.javia.arity.Complex;
import org.javia.arity.EvalCase;
import org.javia.arity.Function;
import org.javia.arity.FunctionAndName;
import org.javia.arity.Symbols;
import org.javia.arity.SyntaxException;
import org.javia.arity.UnitTest;
import org.javia.arity.Util;

class TestEval {
    static EvalCase[] cases = new EvalCase[]{new EvalCase(".", 0.0), new EvalCase("1+.", 1.0), new EvalCase("1", 1.0), new EvalCase("\u03c0", Math.PI), new EvalCase("2\u00d73", 6.0), new EvalCase("1+\u221a9*2", 7.0), new EvalCase("3\u221a 4", 6.0), new EvalCase("\u221a16sin(2\u03c0/4)", 4.0), new EvalCase("1+", -2.0), new EvalCase("1+1", 2.0), new EvalCase("1+-1", 0.0), new EvalCase("-0.5", -0.5), new EvalCase("+1e2", 100.0), new EvalCase("1e-1", 0.1), new EvalCase("1e\u22122", 0.01), new EvalCase("-2^3!", -64.0), new EvalCase("(-2)^3!", 64.0), new EvalCase("-2^1^2", -2.0), new EvalCase("--1", 1.0), new EvalCase("-3^--2", -9.0), new EvalCase("1+2)(2+3", 15.0), new EvalCase("1+2)!^-2", 0.027777777777777776), new EvalCase("sin(0)", 0.0), new EvalCase("cos(0)", 1.0), new EvalCase("sin(-1--1)", 0.0), new EvalCase("-(2+1)*-(4/2)", 6.0), new EvalCase("-.5E-1", -0.05), new EvalCase("1E1.5", -2.0), new EvalCase("2 3 4", 24.0), new EvalCase("pi", Math.PI), new EvalCase("e", Math.E), new EvalCase("sin(pi/2)", 1.0), new EvalCase("f=sin(2x)", -3.0), new EvalCase("f(pi/2)", 0.0), new EvalCase("a=3", 3.0), new EvalCase("b=a+1", 4.0), new EvalCase("f(x, y) = x*(y+1)", -3.0), new EvalCase("=", -2.0), new EvalCase("f(a, b-a)", 6.0), new EvalCase(" f(a pi/4)", -1.0), new EvalCase("f (  1  +  1  , a+1)", 10.0), new EvalCase("g(foo) = f (f(foo, 1)pi/2)", -3.0), new EvalCase("g(.5*2)", 0.0), new EvalCase("NaN", Double.NaN), new EvalCase("Inf", Double.POSITIVE_INFINITY), new EvalCase("Infinity", Double.POSITIVE_INFINITY), new EvalCase("-Inf", Double.NEGATIVE_INFINITY), new EvalCase("0/0", Double.NaN), new EvalCase("comb(11, 9)", 55.0), new EvalCase("perm(11, 2)", 110.0), new EvalCase("comb(1000, 999)", 1000.0), new EvalCase("perm(1000, 1)", 1000.0), new EvalCase("c(x)=1+x^2", -3.0), new EvalCase("c(3-1)", 5.0), new EvalCase("abs(3-4i)", 5.0), new EvalCase("exp(pi*i)", -1.0), new EvalCase("5%", 0.05), new EvalCase("200+5%", 210.0), new EvalCase("200-5%", 190.0), new EvalCase("100/200%", 50.0), new EvalCase("100+200%+5%", 315.0), new EvalCase("p1(x)=200+5%+x", -3.0), new EvalCase("p1(0)", 210.0), new EvalCase("p2(x,y)=x+y%+(2*y)%", -3.0), new EvalCase("p2(200,5)", 231.0), new EvalCase("mod(5,3)", 2.0), new EvalCase("5.2 # 3.2", 2.0), new EvalCase("f(x)=3", -3.0), new EvalCase("g(x)=f(x)", -3.0), new EvalCase("g(1)", 3.0), new EvalCase("a(x)=i+x-x", -3.0), new EvalCase("b(x)=a(x)*a(x)", -3.0), new EvalCase("b(5)", -1.0), new EvalCase("h(x)=sqrt(-1+x-x)", -3.0), new EvalCase("k(x)=h(x)*h(x)", -3.0), new EvalCase("k(5)", -1.0), new EvalCase("pi=4", 4.0), new EvalCase("pi", Math.PI), new EvalCase("fc(x)=e^(i*x^2", -3.0), new EvalCase("fc(0)", 1.0), new EvalCase("aa(x)=sin(x)^1+sin(x)^0", -3.0), new EvalCase("aa(0)", 1.0), new EvalCase("null(x)=0", -3.0), new EvalCase("n(x)=null(sin(x))", -3.0), new EvalCase("n(1)", 0.0), new EvalCase("(2,", -2.0), new EvalCase("100.1-100-.1", 0.0), new EvalCase("1.1-1+(-.1)", 0.0), new EvalCase("log(2,8)", 3.0), new EvalCase("log(9,81)", 2.0), new EvalCase("log(4,2)", 0.5), new EvalCase("sin'(0)", 1.0), new EvalCase("cos'(0)", 0.0), new EvalCase("cos'(pi/2)", -1.0), new EvalCase("f(x)=2*x^3+x^2+100", -3.0), new EvalCase("f'(1)", 8.0), new EvalCase("f'(2)", 28.0), new EvalCase("abs'(2)", 1.0), new EvalCase("abs'(-3)", -1.0), new EvalCase("0x0", 0.0), new EvalCase("0x100", 256.0), new EvalCase("0X10", 16.0), new EvalCase("0b10", 2.0), new EvalCase("0o10", 8.0), new EvalCase("0o8", -2.0), new EvalCase("0xg", -2.0), new EvalCase("0b20", -2.0), new EvalCase("sin(0x1*pi/2)", 1.0), new EvalCase("ln(e)", 1.0), new EvalCase("log(10)", 1.0), new EvalCase("log10(100)", 2.0), new EvalCase("lg(.1)", -1.0), new EvalCase("log2(2)", 1.0), new EvalCase("lb(256)", 8.0)};
    static EvalCase[] casesComplex = new EvalCase[]{new EvalCase("sqrt(-1)^2", new Complex(-1.0, 0.0)), new EvalCase("i", new Complex(0.0, 1.0)), new EvalCase("sqrt(-1)", new Complex(0.0, 1.0)), new EvalCase("c(2+0i)", new Complex(5.0, 0.0)), new EvalCase("c(1+i)", new Complex(1.0, 2.0)), new EvalCase("ln(-1)", new Complex(0.0, -Math.PI)), new EvalCase("i^i", new Complex(0.20787957635076193, 0.0)), new EvalCase("gcd(135-14i, 155+34i)", new Complex(12.0, -5.0)), new EvalCase("comb(1+.5i, 1)", new Complex(1.0, 0.5)), new EvalCase("perm(2+i, 2)", new Complex(1.0, 3.0)), new EvalCase("fc(2)", new Complex(-0.6536436208636119, -0.7568024953079282))};

    TestEval() {
    }

    static boolean testEval() throws ArityException {
        Object object;
        EvalCase evalCase;
        int n;
        boolean bl = true;
        Symbols symbols = new Symbols();
        for (n = 0; n < cases.length; ++n) {
            evalCase = cases[n];
            boolean bl2 = true;
            try {
                double d;
                double d2 = 0.0;
                Complex complex = new Complex();
                FunctionAndName functionAndName = symbols.compileWithName(evalCase.expr);
                Function function = functionAndName.function;
                symbols.define(functionAndName);
                if (function.arity() == 0) {
                    d = function.eval();
                    Complex complex2 = function.evalComplex();
                    bl2 = bl2 && UnitTest.equal(d, complex2);
                    object = Util.doubleToString(d, 1);
                    if (!Symbols.isDefinition(evalCase.expr)) {
                        d2 = symbols.eval(evalCase.expr);
                        complex = symbols.evalComplex(evalCase.expr);
                        boolean bl3 = bl2 = bl2 && UnitTest.equal(d, d2) && complex2.equals(complex);
                    }
                    if (!bl2) {
                        System.out.println("**** failed: " + d + ' ' + d2 + ' ' + complex2 + ' ' + complex);
                    }
                } else {
                    d = -3.0;
                    object = function.toString();
                }
                bl2 = bl2 && UnitTest.equal(evalCase.result, d);
            }
            catch (SyntaxException syntaxException) {
                object = syntaxException.toString();
                bl2 = evalCase.result == -2.0;
            }
            System.out.println((bl2 ? "" : "failed (expected " + evalCase.result + "): ") + evalCase.expr + "                                           ".substring(0, Math.max(15 - evalCase.expr.length(), 0)) + " = " + (String)object);
            if (bl2) continue;
            bl = false;
        }
        for (n = 0; n < casesComplex.length; ++n) {
            try {
                evalCase = casesComplex[n];
                object = symbols.evalComplex(evalCase.expr);
                if (!UnitTest.equal(evalCase.cResult, (Complex)object)) {
                    System.out.println("failed " + evalCase.expr + " expected " + evalCase.cResult + " got " + object);
                    bl = false;
                    continue;
                }
                System.out.println("" + evalCase.expr + " = " + Util.complexToString((Complex)object, 40, 0));
                continue;
            }
            catch (SyntaxException syntaxException) {
                // empty catch block
            }
        }
        return bl;
    }
}

