/*
 * Decompiled with CFR 0.152.
 */
package org.javia.arity;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import org.javia.arity.Compiler;
import org.javia.arity.Complex;
import org.javia.arity.Constant;
import org.javia.arity.Function;
import org.javia.arity.FunctionAndName;
import org.javia.arity.Symbol;
import org.javia.arity.SyntaxException;
import org.javia.arity.VM;

public class Symbols {
    private static final Symbol[] builtin;
    private static Symbol shell;
    private final Compiler compiler = new Compiler();
    private Hashtable symbols = new Hashtable();
    private HashSet<Symbol> delta = null;
    private Stack<HashSet<Symbol>> frames = new Stack();
    private static final String[] defines;

    public Symbols() {
        int n;
        for (n = 0; n < builtin.length; ++n) {
            this.add(builtin[n]);
        }
        try {
            for (n = 0; n < defines.length; ++n) {
                this.define(this.compileWithName(defines[n]));
            }
        }
        catch (SyntaxException syntaxException) {
            throw new Error("" + syntaxException);
        }
    }

    public static boolean isDefinition(String string2) {
        return string2.indexOf(61) != -1;
    }

    public synchronized double eval(String string2) throws SyntaxException {
        return this.compiler.compileSimple(this, string2).eval();
    }

    public synchronized Complex evalComplex(String string2) throws SyntaxException {
        return this.compiler.compileSimple(this, string2).evalComplex();
    }

    public synchronized FunctionAndName compileWithName(String string2) throws SyntaxException {
        return this.compiler.compileWithName(this, string2);
    }

    public synchronized Function compile(String string2) throws SyntaxException {
        return this.compiler.compile(this, string2);
    }

    public synchronized void define(String string2, Function function) {
        if (function instanceof Constant) {
            this.define(string2, function.eval());
        } else {
            this.add(new Symbol(string2, function));
        }
    }

    public synchronized void define(FunctionAndName functionAndName) {
        if (functionAndName.name != null) {
            this.define(functionAndName.name, functionAndName.function);
        }
    }

    public synchronized void define(String string2, double d) {
        this.add(new Symbol(string2, d, 0.0, false));
    }

    public synchronized void define(String string2, Complex complex) {
        this.add(new Symbol(string2, complex.re, complex.im, false));
    }

    public synchronized void pushFrame() {
        this.frames.push(this.delta);
        this.delta = null;
    }

    public synchronized void popFrame() {
        if (this.delta != null) {
            for (Symbol symbol : this.delta) {
                if (symbol.isEmpty()) {
                    this.symbols.remove(symbol);
                    continue;
                }
                this.symbols.put(symbol, symbol);
            }
        }
        this.delta = this.frames.pop();
    }

    public Symbol[] getTopFrame() {
        return this.delta == null ? new Symbol[]{} : this.delta.toArray(new Symbol[0]);
    }

    public Symbol[] getAllSymbols() {
        int n = this.symbols.size();
        Symbol[] symbolArray = new Symbol[n];
        this.symbols.keySet().toArray(symbolArray);
        return symbolArray;
    }

    public String[] getDictionary() {
        Symbol[] symbolArray = this.getAllSymbols();
        int n = symbolArray.length;
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = symbolArray[i].getName();
        }
        return stringArray;
    }

    void addArguments(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            this.add(Symbol.makeArg(stringArray[i], i));
        }
    }

    void add(Symbol symbol) {
        Symbol symbol2 = this.symbols.put(symbol, symbol);
        if (symbol2 != null && symbol2.isConst) {
            this.symbols.put(symbol2, symbol2);
            return;
        }
        if (this.delta == null) {
            this.delta = new HashSet();
        }
        if (!this.delta.contains(symbol)) {
            this.delta.add(symbol2 != null ? symbol2 : Symbol.newEmpty(symbol));
        }
    }

    synchronized Symbol lookup(String string2, int n) {
        return (Symbol)this.symbols.get(shell.setKey(string2, n));
    }

    Symbol lookupConst(String string2) {
        return this.lookup(string2, -3);
    }

    static {
        shell = new Symbol(null, 0.0, false);
        Vector<Symbol> vector = new Vector<Symbol>();
        byte[] objectArray = VM.builtins;
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            byte by = objectArray[i];
            vector.addElement(Symbol.makeVmOp(VM.opcodeName[by], by));
        }
        String[] stringArray = new String[]{"x", "y", "z"};
        for (n = 0; n < stringArray.length; n = (int)((byte)(n + 1))) {
            vector.addElement(Symbol.makeArg(stringArray[n], n));
        }
        vector.addElement(new Symbol("pi", Math.PI, true));
        vector.addElement(new Symbol("\u03c0", Math.PI, true));
        vector.addElement(new Symbol("e", Math.E, true));
        vector.addElement(new Symbol("Infinity", Double.POSITIVE_INFINITY, true));
        vector.addElement(new Symbol("infinity", Double.POSITIVE_INFINITY, true));
        vector.addElement(new Symbol("Inf", Double.POSITIVE_INFINITY, true));
        vector.addElement(new Symbol("inf", Double.POSITIVE_INFINITY, true));
        vector.addElement(new Symbol("\u221e", Double.POSITIVE_INFINITY, true));
        vector.addElement(new Symbol("NaN", Double.NaN, true));
        vector.addElement(new Symbol("nan", Double.NaN, true));
        vector.addElement(new Symbol("i", 0.0, 1.0, true));
        vector.addElement(new Symbol("j", 0.0, 1.0, false));
        int n2 = vector.size();
        builtin = new Symbol[n2];
        vector.copyInto(builtin);
        defines = new String[]{"log(x)=ln(x)*0.43429448190325182765", "log10(x)=log(x)", "lg(x)=log(x)", "log2(x)=ln(x)*1.4426950408889634074", "lb(x)=log2(x)", "log(base,x)=ln(x)/ln(base)", "gamma(x)=(x-1)!", "deg=0.017453292519943295", "indeg=57.29577951308232", "sind(x)=sin(x deg)", "cosd(x)=cos(x deg)", "tand(x)=tan(x deg)", "asind(x)=asin(x) indeg", "acosd(x)=acos(x) indeg", "atand(x)=atan(x) indeg", "tg(x)=tan(x)", "tgd(x)=tand(x)"};
    }
}

