/*
 * Decompiled with CFR 0.152.
 */
package org.javia.arity;

import org.javia.arity.Function;
import org.javia.arity.VM;

public class Symbol {
    static final int CONST_ARITY = -3;
    private String name;
    private int arity;
    byte op;
    Function fun;
    double valueRe;
    double valueIm;
    boolean isConst = false;

    private Symbol(String string2, int n, byte by, boolean bl, int n2) {
        this.setKey(string2, n);
        this.op = by;
        this.isConst = bl;
    }

    Symbol(String string2, Function function) {
        this.setKey(string2, function.arity());
        this.fun = function;
    }

    Symbol(String string2, double d, boolean bl) {
        this(string2, d, 0.0, bl);
    }

    Symbol(String string2, double d, double d2, boolean bl) {
        this.setKey(string2, -3);
        this.valueRe = d;
        this.valueIm = d2;
        this.isConst = bl;
    }

    static Symbol makeArg(String string2, int n) {
        return new Symbol(string2, -3, (byte)(38 + n), false, 0);
    }

    static Symbol makeVmOp(String string2, int n) {
        return new Symbol(string2, VM.arity[n], (byte)n, true, 0);
    }

    public String toString() {
        return "Symbol '" + this.name + "' arity " + this.arity + " val " + this.valueRe + " op " + this.op;
    }

    public String getName() {
        return this.name;
    }

    public int getArity() {
        return this.arity == -3 ? 0 : this.arity;
    }

    static Symbol newEmpty(Symbol symbol) {
        return new Symbol(symbol.name, symbol.arity, 0, false, 0);
    }

    boolean isEmpty() {
        return this.op == 0 && this.fun == null && this.valueRe == 0.0 && this.valueIm == 0.0;
    }

    Symbol setKey(String string2, int n) {
        this.name = string2;
        this.arity = n;
        return this;
    }

    public boolean equals(Object object) {
        Symbol symbol = (Symbol)object;
        return this.name.equals(symbol.name) && this.arity == symbol.arity;
    }

    public int hashCode() {
        return this.name.hashCode() + this.arity;
    }
}

