/*
 * Decompiled with CFR 0.152.
 */
package org.javia.arity;

import org.javia.arity.CompiledFunction;
import org.javia.arity.Complex;
import org.javia.arity.EvalContext;
import org.javia.arity.Function;
import org.javia.arity.SimpleCodeGen;
import org.javia.arity.Symbol;
import org.javia.arity.SyntaxException;
import org.javia.arity.Token;
import org.javia.arity.VM;

class OptCodeGen
extends SimpleCodeGen {
    EvalContext context = new EvalContext();
    int sp;
    Complex[] stack;
    double[] traceConstsRe;
    double[] traceConstsIm;
    Function[] traceFuncs;
    byte[] traceCode;
    CompiledFunction tracer;
    int intrinsicArity;
    private boolean isPercent;

    OptCodeGen(SyntaxException syntaxException) {
        super(syntaxException);
        this.stack = this.context.stackComplex;
        this.traceConstsRe = new double[1];
        this.traceConstsIm = new double[1];
        this.traceFuncs = new Function[1];
        this.traceCode = new byte[1];
        this.tracer = new CompiledFunction(0, this.traceCode, this.traceConstsRe, this.traceConstsIm, this.traceFuncs);
    }

    void start() {
        super.start();
        this.sp = -1;
        this.intrinsicArity = 0;
        this.isPercent = false;
    }

    void push(Token token) throws SyntaxException {
        byte by;
        boolean bl = this.isPercent;
        this.isPercent = false;
        switch (token.id) {
            case 9: {
                by = 1;
                this.traceConstsRe[0] = token.value;
                this.traceConstsIm[0] = 0.0;
                break;
            }
            case 10: 
            case 11: {
                Symbol symbol = this.getSymbol(token);
                if (token.isDerivative()) {
                    by = 2;
                    this.traceFuncs[0] = symbol.fun.getDerivative();
                    break;
                }
                if (symbol.op > 0) {
                    by = symbol.op;
                    if (by < 38 || by > 42) break;
                    int n = by - 38;
                    if (n + 1 > this.intrinsicArity) {
                        this.intrinsicArity = n + 1;
                    }
                    ++this.sp;
                    this.stack[this.sp + 1].re = Double.NaN;
                    this.stack[this.sp].im = 0.0;
                    this.code.push(by);
                    return;
                }
                if (symbol.fun != null) {
                    by = 2;
                    this.traceFuncs[0] = symbol.fun;
                    break;
                }
                by = 1;
                this.traceConstsRe[0] = symbol.valueRe;
                this.traceConstsIm[0] = symbol.valueIm;
                break;
            }
            default: {
                by = token.vmop;
                if (by <= 0) {
                    throw new Error("wrong vmop: " + by);
                }
                if (by != 12) break;
                this.isPercent = true;
            }
        }
        int n = this.sp++;
        this.traceCode[0] = by;
        if (by != 8) {
            this.sp = this.tracer.execWithoutCheckComplex(this.context, this.sp, bl ? -1 : -2);
        } else {
            this.stack[this.sp + 1].re = Double.NaN;
            this.stack[this.sp].im = 0.0;
        }
        if (!this.stack[this.sp].isNaN() || by == 1) {
            int n2;
            int n3 = n2 = by == 2 ? this.traceFuncs[0].arity() : VM.arity[by];
            while (n2 > 0) {
                byte by2 = this.code.pop();
                if (by2 == 1) {
                    this.consts.pop();
                } else if (by2 == 2) {
                    Function function = this.funcs.pop();
                    n2 += function.arity() - 1;
                } else {
                    n2 += VM.arity[by2];
                }
                --n2;
            }
            this.consts.push(this.stack[this.sp].re, this.stack[this.sp].im);
            by = 1;
        } else if (by == 2) {
            this.funcs.push(this.traceFuncs[0]);
        }
        this.code.push(by);
    }

    CompiledFunction getFun(int n) {
        return new CompiledFunction(n, this.code.toArray(), this.consts.getRe(), this.consts.getIm(), this.funcs.toArray());
    }
}

