/*
 * Decompiled with CFR 0.152.
 */
package org.javia.arity;

import org.javia.arity.SyntaxException;
import org.javia.arity.Token;
import org.javia.arity.TokenConsumer;

class Lexer {
    static final int ADD = 1;
    static final int SUB = 2;
    static final int MUL = 3;
    static final int DIV = 4;
    static final int MOD = 5;
    static final int UMIN = 6;
    static final int POWER = 7;
    static final int FACT = 8;
    static final int NUMBER = 9;
    static final int CONST = 10;
    static final int CALL = 11;
    static final int COMMA = 12;
    static final int LPAREN = 13;
    static final int RPAREN = 14;
    static final int END = 15;
    static final int SQRT = 16;
    static final int PERCENT = 17;
    static final Token TOK_ADD = new Token(1, 4, 2, 3);
    static final Token TOK_SUB = new Token(2, 4, 2, 4);
    static final Token TOK_MUL = new Token(3, 5, 2, 5);
    static final Token TOK_DIV = new Token(4, 5, 2, 6);
    static final Token TOK_MOD = new Token(5, 5, 2, 7);
    static final Token TOK_UMIN = new Token(6, 6, 1, 9);
    static final Token TOK_POWER = new Token(7, 7, 3, 10);
    static final Token TOK_FACT = new Token(8, 8, 4, 11);
    static final Token TOK_PERCENT = new Token(17, 9, 4, 12);
    static final Token TOK_SQRT = new Token(16, 10, 1, 13);
    static final Token TOK_LPAREN = new Token(13, 1, 1, 0);
    static final Token TOK_RPAREN = new Token(14, 3, 0, 0);
    static final Token TOK_COMMA = new Token(12, 2, 0, 0);
    static final Token TOK_END = new Token(15, 0, 0, 0);
    static final Token TOK_NUMBER = new Token(9, 20, 0, 0);
    static final Token TOK_CONST = new Token(10, 20, 0, 0);
    private static final char UNICODE_MINUS = '\u2212';
    private static final char UNICODE_MUL = '\u00d7';
    private static final char UNICODE_DIV = '\u00f7';
    private static final char UNICODE_SQRT = '\u221a';
    private static final String WHITESPACE = " \n\r\t";
    private static final char END_MARKER = '$';
    private char[] input = new char[32];
    private int pos;
    private SyntaxException exception;

    Lexer(SyntaxException syntaxException) {
        this.exception = syntaxException;
    }

    void scan(String string2, TokenConsumer tokenConsumer) throws SyntaxException {
        Token token;
        this.exception.expression = string2;
        if (string2.indexOf(36) != -1) {
            throw this.exception.set("Invalid character '$'", string2.indexOf(36));
        }
        this.init(string2);
        tokenConsumer.start();
        do {
            int n = this.pos;
            token = this.nextToken();
            token.position = n;
            tokenConsumer.push(token);
        } while (token != TOK_END);
    }

    private void init(String string2) {
        int n = string2.length();
        if (this.input.length < n + 1) {
            this.input = new char[n + 1];
        }
        string2.getChars(0, n, this.input, 0);
        this.input[n] = 36;
        this.pos = 0;
    }

    Token nextToken() throws SyntaxException {
        while (WHITESPACE.indexOf(this.input[this.pos]) != -1) {
            ++this.pos;
        }
        char c = this.input[this.pos];
        int n = this.pos++;
        switch (c) {
            case '!': {
                return TOK_FACT;
            }
            case '$': {
                return TOK_END;
            }
            case '%': {
                return TOK_PERCENT;
            }
            case '#': {
                return TOK_MOD;
            }
            case '(': {
                return TOK_LPAREN;
            }
            case ')': {
                return TOK_RPAREN;
            }
            case '*': {
                return TOK_MUL;
            }
            case '+': {
                return TOK_ADD;
            }
            case ',': {
                return TOK_COMMA;
            }
            case '-': {
                return TOK_SUB;
            }
            case '/': {
                return TOK_DIV;
            }
        }
        int n2 = this.pos;
        if ('0' <= c && c <= '9' || c == '.') {
            if (c == '0') {
                int n3;
                char c2 = Character.toLowerCase(this.input[n2]);
                int n4 = c2 == 'x' ? 16 : (c2 == 'b' ? 2 : (n3 = c2 == 'o' ? 8 : 0));
                if (n3 > 0) {
                    int n5;
                    do {
                        n5 = ++n2;
                        ++n2;
                    } while ('a' <= (c = this.input[n5]) && c <= 'z' || 'A' <= c && c <= 'Z' || '0' <= c && c <= '9');
                    String string2 = String.valueOf(this.input, n + 2, n2 - 3 - n);
                    this.pos = n2 - 1;
                    try {
                        return TOK_NUMBER.setValue(Integer.parseInt(string2, n3));
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw this.exception.set("invalid number '" + String.valueOf(this.input, n, n2 - 1 - n) + "'", n);
                    }
                }
            }
            while ('0' <= c && c <= '9' || c == '.' || c == 'E' || c == 'e') {
                if (!(c != 'E' && c != 'e' || this.input[n2] != '-' && this.input[n2] != '\u2212')) {
                    this.input[n2] = 45;
                }
                int n6 = ++n2;
                ++n2;
                c = this.input[n6];
            }
            this.pos = n2 - 1;
            String string3 = String.valueOf(this.input, n, n2 - 1 - n);
            try {
                if (string3.equals(".")) {
                    return TOK_NUMBER.setValue(0.0);
                }
                double d = Double.parseDouble(string3);
                return TOK_NUMBER.setValue(d);
            }
            catch (NumberFormatException numberFormatException) {
                throw this.exception.set("invalid number '" + string3 + "'", n);
            }
        }
        if ('a' <= c && c <= 'z' || 'A' <= c && c <= 'Z') {
            while ('a' <= (c = this.input[n2++]) && c <= 'z' || 'A' <= c && c <= 'Z' || '0' <= c && c <= '9') {
            }
            if (c == '\'') {
                c = this.input[n2++];
            }
            String string4 = String.valueOf(this.input, n, n2 - 1 - n);
            while (WHITESPACE.indexOf(c) != -1) {
                c = this.input[n2++];
            }
            if (c == '(') {
                this.pos = n2;
                return new Token(11, 0, 1, 0).setAlpha(string4);
            }
            this.pos = n2 - 1;
            return TOK_CONST.setAlpha(string4);
        }
        if (c >= '\u0391' && c <= '\u03a9' || c >= '\u03b1' && c <= '\u03c9' || c == '\u221e') {
            return TOK_CONST.setAlpha("" + c);
        }
        switch (c) {
            case '^': {
                return TOK_POWER;
            }
            case '\u00d7': {
                return TOK_MUL;
            }
            case '\u00f7': {
                return TOK_DIV;
            }
            case '\u2212': {
                return TOK_SUB;
            }
            case '\u221a': {
                return TOK_SQRT;
            }
        }
        throw this.exception.set("invalid character '" + c + "'", n);
    }
}

