/*
 * Decompiled with CFR 0.152.
 */
package org.javia.arity;

import org.javia.arity.ArityException;
import org.javia.arity.Complex;
import org.javia.arity.Derivative;

public abstract class Function {
    private Function cachedDerivate = null;
    String comment;

    public abstract int arity();

    public Function getDerivative() {
        if (this.cachedDerivate == null) {
            this.cachedDerivate = new Derivative(this);
        }
        return this.cachedDerivate;
    }

    void setDerivative(Function function) {
        this.cachedDerivate = function;
    }

    public double eval() {
        throw new ArityException(0);
    }

    public double eval(double d) {
        throw new ArityException(1);
    }

    public double eval(double d, double d2) {
        throw new ArityException(2);
    }

    public double eval(double[] dArray) {
        switch (dArray.length) {
            case 0: {
                return this.eval();
            }
            case 1: {
                return this.eval(dArray[0]);
            }
            case 2: {
                return this.eval(dArray[0], dArray[1]);
            }
        }
        throw new ArityException(dArray.length);
    }

    public Complex evalComplex() {
        this.checkArity(0);
        return new Complex(this.eval(), 0.0);
    }

    public Complex eval(Complex complex) {
        this.checkArity(1);
        return new Complex(complex.im == 0.0 ? this.eval(complex.re) : Double.NaN, 0.0);
    }

    public Complex eval(Complex complex, Complex complex2) {
        this.checkArity(2);
        return new Complex(complex.im == 0.0 && complex2.im == 0.0 ? this.eval(complex.re, complex2.re) : Double.NaN, 0.0);
    }

    public Complex eval(Complex[] complexArray) {
        switch (complexArray.length) {
            case 0: {
                return this.evalComplex();
            }
            case 1: {
                return this.eval(complexArray[0]);
            }
            case 2: {
                return this.eval(complexArray[0], complexArray[1]);
            }
        }
        int n = complexArray.length;
        this.checkArity(n);
        double[] dArray = new double[n];
        for (int i = complexArray.length - 1; i >= 0; --i) {
            if (complexArray[i].im != 0.0) {
                return new Complex(Double.NaN, 0.0);
            }
            dArray[i] = complexArray[i].re;
        }
        return new Complex(this.eval(dArray), 0.0);
    }

    public void checkArity(int n) throws ArityException {
        if (this.arity() != n) {
            throw new ArityException("Expected " + this.arity() + " arguments, got " + n);
        }
    }
}

